/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.css;

import com.intellij.javascript.flex.css.FlexCssElementDescriptorProvider;
import com.intellij.javascript.flex.css.FlexCssUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermType;
import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.descriptor.value.CssColorValue;
import com.intellij.psi.css.impl.descriptor.value.CssLengthValue;
import com.intellij.psi.css.impl.descriptor.value.CssStringValue;
import com.intellij.psi.css.impl.descriptor.value.CssValueValidatorImpl;
import com.intellij.xml.util.ColorMap;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FlexCssValueValidator
extends CssValueValidatorImpl {
    public FlexCssValueValidator(@NotNull FlexCssElementDescriptorProvider provider) {
        if (provider == null) {
            FlexCssValueValidator.$$$reportNull$$$0(0);
        }
        super((CssElementDescriptorProvider)provider);
    }

    public boolean isValid(@Nullable PsiElement term, @NotNull CssValueDescriptor valueDescriptor) {
        if (valueDescriptor == null) {
            FlexCssValueValidator.$$$reportNull$$$0(1);
        }
        if (valueDescriptor instanceof CssColorValue) {
            return term != null && FlexCssValueValidator.isValidColor(term);
        }
        if (valueDescriptor instanceof CssStringValue) {
            return term != null && FlexCssValueValidator.isValidString(term) && super.isValid(term, valueDescriptor);
        }
        if (valueDescriptor instanceof CssLengthValue) {
            return term instanceof CssTerm && (super.isValid(term, valueDescriptor) || FlexCssValueValidator.isValidLength((CssTerm)term));
        }
        return super.isValid(term, valueDescriptor);
    }

    private static boolean isValidString(@NotNull PsiElement element) {
        if (element == null) {
            FlexCssValueValidator.$$$reportNull$$$0(2);
        }
        return FlexCssUtil.inQuotes(element.getText().trim());
    }

    private static boolean isValidLength(@NotNull CssTerm cssTerm) {
        CssTermType termType;
        if (cssTerm == null) {
            FlexCssValueValidator.$$$reportNull$$$0(3);
        }
        return (termType = cssTerm.getTermType()) == CssTermTypes.NEGATIVE_NUMBER || termType == CssTermTypes.NUMBER || termType == CssTermTypes.INTEGER;
    }

    private static boolean isValidColor(@NotNull PsiElement element) {
        String text;
        if (element == null) {
            FlexCssValueValidator.$$$reportNull$$$0(4);
        }
        if (FlexCssValueValidator.isInteger(text = element.getText().trim())) {
            return true;
        }
        if (!(element instanceof CssTerm) || ((CssTerm)element).getTermType() != CssTermTypes.COLOR) {
            if (FlexCssUtil.inQuotes(text)) {
                if ((text = StringUtil.unquoteString((String)text, (char)'\"')).startsWith("0x")) {
                    return FlexCssValueValidator.isInteger(text.substring(2));
                }
                if (FlexCssValueValidator.containsOnlyLetters(text)) {
                    return ColorMap.isStandardColor((String)text.toLowerCase(Locale.US));
                }
            }
            return false;
        }
        if (FlexCssValueValidator.containsOnlyLetters(text)) {
            return ColorMap.isStandardColor((String)text.toLowerCase(Locale.US));
        }
        return true;
    }

    private static boolean containsOnlyLetters(@NotNull String s) {
        if (s == null) {
            FlexCssValueValidator.$$$reportNull$$$0(5);
        }
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if (Character.isLetter(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean isInteger(@NotNull String s) {
        if (s == null) {
            FlexCssValueValidator.$$$reportNull$$$0(6);
        }
        try {
            Integer.parseInt(s, 16);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueDescriptor";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cssTerm";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/flex/css/FlexCssValueValidator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isValid";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidLength";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidColor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "containsOnlyLetters";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isInteger";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

