/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.documentation;

import com.intellij.lang.actionscript.psi.impl.ActionScriptFunctionImpl;
import com.intellij.lang.actionscript.psi.impl.ActionScriptVariableImpl;
import com.intellij.lang.javascript.documentation.JSQuickNavigateBuilder;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FlexQuickNavigateBuilder
extends JSQuickNavigateBuilder {
    FlexQuickNavigateBuilder() {
    }

    protected String getQuickNavigateInfoForNavigationElement(PsiElement element, PsiElement originalElement) {
        if (element instanceof JSNamespaceDeclaration) {
            return FlexQuickNavigateBuilder.createQuickNavigateForNamespace((JSNamespaceDeclaration)element);
        }
        if (element instanceof JSAttributeNameValuePair) {
            return this.createQuickNavigateForAnnotationDerived(element, originalElement);
        }
        return super.getQuickNavigateInfoForNavigationElement(element, originalElement);
    }

    @Nullable
    protected String getParentInfo(PsiElement parent, @NotNull PsiNamedElement element, @NotNull JSTypeSubstitutor substitutor) {
        if (element == null) {
            FlexQuickNavigateBuilder.$$$reportNull$$$0(0);
        }
        if (substitutor == null) {
            FlexQuickNavigateBuilder.$$$reportNull$$$0(1);
        }
        if (parent instanceof JSClass) {
            return ((JSClass)parent).getQualifiedName();
        }
        if (parent instanceof JSPackageStatement) {
            return ((JSPackageStatement)parent).getQualifiedName();
        }
        if (parent instanceof JSFile) {
            if (parent.getContext() != null) {
                String mxmlPackage = ActionScriptResolveUtil.findPackageForMxml((PsiElement)parent);
                if (mxmlPackage != null) {
                    return mxmlPackage + (mxmlPackage.length() > 0 ? "." : "") + parent.getContext().getContainingFile().getName();
                }
            } else if (element instanceof ActionScriptFunctionImpl && ((ActionScriptFunctionImpl)element).hasQualifiedName() || element instanceof ActionScriptVariableImpl && ((ActionScriptVariableImpl)element).hasQualifiedName()) {
                JSQualifiedName namespace = ((JSQualifiedNamedElement)element).getNamespace();
                assert (namespace != null) : "null namespace of element having qualified name";
                return namespace.getQualifiedName();
            }
        }
        return null;
    }

    @Nullable
    private static String createQuickNavigateForNamespace(JSNamespaceDeclaration ns) {
        String qName = ns.getQualifiedName();
        if (qName == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        String packageName = StringUtil.getPackageName((String)qName);
        if (packageName.length() > 0) {
            result.append(packageName).append("\n");
        }
        result.append("namespace");
        String name = ns.getName();
        result.append(" ").append(name);
        String s = ns.getInitialValueString();
        if (s != null) {
            result.append(" = ").append(s);
        }
        return result.toString();
    }

    private String createQuickNavigateForAnnotationDerived(PsiElement element, PsiElement originalElement) {
        JSAttributeNameValuePair valuePair = (JSAttributeNameValuePair)element;
        JSAttribute parent = (JSAttribute)valuePair.getParent();
        StringBuilder builder = new StringBuilder();
        JSClass clazz = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)valuePair, JSClass.class);
        Object realParent = clazz != null ? clazz : parent.getContainingFile();
        String info = this.getParentInfo((PsiElement)realParent, (PsiNamedElement)parent, JSTypeSubstitutor.EMPTY);
        if (!StringUtil.isEmpty((String)info)) {
            builder.append(info).append("\n");
        }
        builder.append(parent.getName()).append(" ").append(valuePair.getSimpleValue());
        return FlexQuickNavigateBuilder.buildResult((JSQuickNavigateBuilder.ObjectKind)JSQuickNavigateBuilder.ObjectKind.SIMPLE_DECLARATION, (String)builder.toString(), (boolean)false, (PsiElement)element, (PsiElement)originalElement);
    }

    protected boolean isIncludeObjectInExtendsList() {
        return true;
    }

    protected boolean shouldAppendFunctionKeyword(@NotNull JSFunction function, @Nullable PsiElement parent) {
        if (function == null) {
            FlexQuickNavigateBuilder.$$$reportNull$$$0(2);
        }
        return parent instanceof JSClass || super.shouldAppendFunctionKeyword(function, parent);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/flex/documentation/FlexQuickNavigateBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getParentInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldAppendFunctionKeyword";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

