/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.maven;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorBasicTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class RuntimeModulesGenerateConfigTask
extends MavenProjectsProcessorBasicTask {
    private final Module myModule;
    private final String myMainConfigFilePath;
    private final Collection<RLMInfo> myRlmInfos;
    private static final String[] ELEMENTS_TO_REMOVE = new String[]{"dump-config", "link-report", "resource-bundle-list"};

    public RuntimeModulesGenerateConfigTask(Module module, MavenProject mavenProject, MavenProjectsTree mavenProjectsTree, String mainConfigFilePath, Collection<RLMInfo> rlmInfos) {
        super(mavenProject, mavenProjectsTree);
        this.myModule = module;
        this.myMainConfigFilePath = mainConfigFilePath;
        this.myRlmInfos = rlmInfos;
    }

    public void perform(Project project, MavenEmbeddersManager embeddersManager, MavenConsole console, MavenProgressIndicator indicator) throws MavenProcessCanceledException {
        Element mainConfigRootElement = RuntimeModulesGenerateConfigTask.getClonedRootElementOfMainConfigFile(this.myMainConfigFilePath);
        if (mainConfigRootElement == null) {
            return;
        }
        for (RLMInfo info : this.myRlmInfos) {
            indicator.setText("Generating Flex compiler configuration file for " + info.myRLMName);
            String mainClassAbsolutePath = RuntimeModulesGenerateConfigTask.findAbsolutePath(this.myModule, info.myMainClassRelativePath);
            RuntimeModulesGenerateConfigTask.changeInputAndOutputFilePaths(mainConfigRootElement, mainClassAbsolutePath, info.myOutputFolderPath + "/" + info.myOutputFileName);
            RuntimeModulesGenerateConfigTask.removeChildrenWithNames(mainConfigRootElement, ELEMENTS_TO_REMOVE);
            try {
                JDOMUtil.writeDocument((Document)mainConfigRootElement.getDocument(), (String)info.myConfigFilePath, (String)CodeStyleSettingsManager.getSettings((Project)project).getLineSeparator());
            }
            catch (IOException iOException) {}
        }
        MavenUtil.invokeAndWaitWriteAction((Project)project, () -> {
            for (RLMInfo info : this.myRlmInfos) {
                VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(info.myConfigFilePath);
                if (file == null) continue;
                file.refresh(false, false);
            }
        });
    }

    @Nullable
    private static Element getClonedRootElementOfMainConfigFile(String filePath) {
        VirtualFile configFile = LocalFileSystem.getInstance().findFileByPath(filePath);
        if (configFile != null) {
            try {
                Document document = JDOMUtil.loadDocument((InputStream)configFile.getInputStream());
                Element clonedRootElement = document.clone().getRootElement();
                if (clonedRootElement.getName().equals("flex-config")) {
                    return clonedRootElement;
                }
            }
            catch (JDOMException jDOMException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @NotNull
    private static String findAbsolutePath(Module module, String relativeToSourceRoot) {
        for (VirtualFile root : ModuleRootManager.getInstance((Module)module).getSourceRoots()) {
            VirtualFile file = VfsUtilCore.findRelativeFile((String)relativeToSourceRoot, (VirtualFile)root);
            if (file == null) continue;
            String string = file.getPath();
            if (string == null) {
                RuntimeModulesGenerateConfigTask.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = relativeToSourceRoot;
        if (string == null) {
            RuntimeModulesGenerateConfigTask.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static void changeInputAndOutputFilePaths(Element configElement, String mainClassAbsolutePath, String outputFilePath) {
        Element pathElement;
        Element fileSpecsElement = configElement.getChild("file-specs", configElement.getNamespace());
        if (fileSpecsElement == null) {
            fileSpecsElement = new Element("file-specs", configElement.getNamespace());
            configElement.addContent(fileSpecsElement);
        }
        if ((pathElement = fileSpecsElement.getChild("path-element", fileSpecsElement.getNamespace())) == null) {
            pathElement = new Element("path-element", fileSpecsElement.getNamespace());
            fileSpecsElement.addContent(pathElement);
        }
        pathElement.setText(mainClassAbsolutePath);
        Element outputElement = configElement.getChild("output", configElement.getNamespace());
        if (outputElement == null) {
            outputElement = new Element("output", configElement.getNamespace());
            configElement.addContent(outputElement);
        }
        outputElement.setText(outputFilePath);
    }

    private static void removeChildrenWithNames(Element rootElement, String[] elementNamesToRemove) {
        for (String elementName : elementNamesToRemove) {
            rootElement.removeChildren(elementName, rootElement.getNamespace());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/maven/RuntimeModulesGenerateConfigTask", "findAbsolutePath"));
    }

    static class RLMInfo {
        final String myRLMName;
        final String myMainClass;
        final String myMainClassRelativePath;
        final String myOutputFileName;
        final String myOutputFolderPath;
        final String myConfigFilePath;

        RLMInfo(String RLMName, String mainClass, String mainClassRelativePath, String outputFileName, String outputFolderPath, String configFilePath) {
            this.myRLMName = RLMName;
            this.myMainClass = mainClass;
            this.myMainClassRelativePath = mainClassRelativePath;
            this.myOutputFileName = outputFileName;
            this.myOutputFolderPath = outputFolderPath;
            this.myConfigFilePath = configFilePath;
        }
    }
}

