/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.refactoring;

import com.intellij.javascript.flex.refactoring.FlexPackageImpl;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveDirectoryWithClassesProcessor;
import com.intellij.refactoring.rename.DirectoryAsPackageRenameHandlerBase;
import com.intellij.util.Query;
import org.jetbrains.annotations.NotNull;

public class FlexDirectoryAsPackageRenameHandler
extends DirectoryAsPackageRenameHandlerBase<FlexPackageImpl> {
    protected VirtualFile[] occursInPackagePrefixes(FlexPackageImpl aPackage) {
        return VirtualFile.EMPTY_ARRAY;
    }

    protected boolean isIdentifier(String name, Project project) {
        return ((NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4)).isIdentifier(name, project);
    }

    protected String getQualifiedName(FlexPackageImpl aPackage) {
        return aPackage.getQualifiedName();
    }

    protected FlexPackageImpl getPackage(PsiDirectory psiDirectory) {
        Project project = psiDirectory.getProject();
        DirectoryIndex index = DirectoryIndex.getInstance((Project)project);
        String packageName = index.getPackageName(psiDirectory.getVirtualFile());
        if (packageName == null) {
            return null;
        }
        Query dirs = index.getDirectoriesByPackageName(packageName, false);
        if (dirs.findFirst() == null) {
            return null;
        }
        return new FlexPackageImpl(PsiManager.getInstance((Project)project), packageName);
    }

    protected BaseRefactoringProcessor createProcessor(final String newQName, Project project, final PsiDirectory[] dirsToRename, boolean searchInComments, boolean searchInNonJavaFiles) {
        return new MoveDirectoryWithClassesProcessor(project, dirsToRename, null, searchInComments, searchInNonJavaFiles, false, null){

            public MoveDirectoryWithClassesProcessor.TargetDirectoryWrapper getTargetDirectory(PsiDirectory dir) {
                return new MoveDirectoryWithClassesProcessor.TargetDirectoryWrapper(dir.getParentDirectory(), StringUtil.getShortName((String)newQName));
            }

            protected String getTargetName() {
                return newQName;
            }

            @NotNull
            protected String getCommandName() {
                String string = RefactoringBundle.message((String)(dirsToRename.length == 1 ? "rename.directory.command.name" : "rename.directories.command.name"));
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/refactoring/FlexDirectoryAsPackageRenameHandler$1", "getCommandName"));
            }
        };
    }
}

