/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.build;

import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class CompilerMessagesBuffer {
    private final List<CompilerMessage> messages;
    private final CompileContext compileContext;
    private boolean bufferingEnabled;
    private static final String OUT_OF_MEMORY = "java.lang.OutOfMemoryError";

    public CompilerMessagesBuffer(@Nullable CompileContext compileContext, boolean bufferingEnabled) {
        this.compileContext = compileContext;
        this.bufferingEnabled = bufferingEnabled;
        this.messages = bufferingEnabled ? Collections.synchronizedList(new ArrayList()) : null;
    }

    public void addMessage(CompilerMessageCategory category, String message, String url, int line, int column) {
        if (this.bufferingEnabled) {
            this.messages.add(new CompilerMessage(category, message, url, line, column));
        } else if (this.compileContext != null) {
            this.compileContext.addMessage(category, message, url, line, column);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        if (this.bufferingEnabled && this.compileContext != null) {
            List<CompilerMessage> list = this.messages;
            synchronized (list) {
                for (CompilerMessage message : this.messages) {
                    this.compileContext.addMessage(message.category, message.message, message.url, message.line, message.column);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsErrors() {
        if (!this.bufferingEnabled) {
            throw new IllegalStateException();
        }
        List<CompilerMessage> list = this.messages;
        synchronized (list) {
            for (CompilerMessage message : this.messages) {
                if (message.category != CompilerMessageCategory.ERROR) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsOutOfMemoryError() {
        if (!this.bufferingEnabled) {
            throw new IllegalStateException();
        }
        List<CompilerMessage> list = this.messages;
        synchronized (list) {
            for (CompilerMessage message : this.messages) {
                if (message.message.indexOf(OUT_OF_MEMORY) == -1) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeErrorsAndStackTrace() {
        if (this.bufferingEnabled) {
            List<CompilerMessage> list = this.messages;
            synchronized (list) {
                Iterator<CompilerMessage> iterator = this.messages.iterator();
                while (iterator.hasNext()) {
                    CompilerMessage message = iterator.next();
                    if (message.category == CompilerMessageCategory.ERROR) {
                        iterator.remove();
                        continue;
                    }
                    if (!CompilerMessagesBuffer.isStackTrace(message.message)) continue;
                    iterator.remove();
                }
            }
        }
    }

    private static boolean isStackTrace(String message) {
        return message.startsWith("\tat ") || message.startsWith(OUT_OF_MEMORY);
    }

    private static class CompilerMessage {
        private final CompilerMessageCategory category;
        private final String message;
        private final String url;
        private final int line;
        private final int column;

        private CompilerMessage(CompilerMessageCategory category, String message, String url, int line, int column) {
            this.category = category;
            this.message = message;
            this.url = url;
            this.line = line;
            this.column = column;
        }
    }
}

