/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.debug;

import com.intellij.lang.javascript.flex.debug.FlexValue;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlObjectEvaluator {
    private final FakeCompositeNode myRootNode;
    static final Font MONOSPACED_FONT;

    public XmlObjectEvaluator(@NotNull XValue value, @NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
        if (value == null) {
            XmlObjectEvaluator.$$$reportNull$$$0(0);
        }
        if (callback == null) {
            XmlObjectEvaluator.$$$reportNull$$$0(1);
        }
        this.myRootNode = new FakeCompositeNode(value, callback);
    }

    public void startEvaluation() {
        this.myRootNode.myValue.computeChildren((XCompositeNode)this.myRootNode);
    }

    static {
        Font font = UIUtil.getToolTipFont();
        MONOSPACED_FONT = new Font("Monospaced", 0, font == null ? 12 : font.getSize());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "value";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "callback";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/flex/debug/XmlObjectEvaluator";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class FakeCompositeNode
    implements XCompositeNode {
        private final XValue myValue;
        private final XFullValueEvaluator.XFullValueEvaluationCallback myCallback;
        private final FakeCompositeNode myParent;
        private final List<FakeCompositeNode> myChildren;
        private static final String XML_MARKER = " class='XML@";
        private static final String XMLLIST_MARKER = " class='XMLList'";

        public FakeCompositeNode(@NotNull XValue value, @NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
            if (value == null) {
                FakeCompositeNode.$$$reportNull$$$0(0);
            }
            if (callback == null) {
                FakeCompositeNode.$$$reportNull$$$0(1);
            }
            this.myChildren = new ArrayList<FakeCompositeNode>();
            this.myValue = value;
            this.myCallback = callback;
            this.myParent = null;
        }

        private FakeCompositeNode(@NotNull XValue value, @NotNull FakeCompositeNode parent) {
            if (value == null) {
                FakeCompositeNode.$$$reportNull$$$0(2);
            }
            if (parent == null) {
                FakeCompositeNode.$$$reportNull$$$0(3);
            }
            this.myChildren = new ArrayList<FakeCompositeNode>();
            this.myValue = value;
            this.myCallback = null;
            this.myParent = parent;
        }

        public void setAlreadySorted(boolean alreadySorted) {
        }

        public void addChildren(@NotNull XValueChildrenList children, boolean last) {
            if (children == null) {
                FakeCompositeNode.$$$reportNull$$$0(4);
            }
            if (this.getRootNode().myCallback.isObsolete()) {
                return;
            }
            for (int i = 0; i < children.size(); ++i) {
                XValue value = children.getValue(i);
                FakeCompositeNode node = new FakeCompositeNode(value, this);
                this.myChildren.add(node);
                value.computeChildren((XCompositeNode)node);
            }
            this.getRootNode().myCallback.evaluated(this.getRootNode().toPresentableSting(0), MONOSPACED_FONT);
        }

        private FakeCompositeNode getRootNode() {
            FakeCompositeNode node = this;
            while (node.myCallback == null) {
                node = node.myParent;
            }
            return node;
        }

        private String toPresentableSting(int level) {
            int xmlInfoEndIndex;
            StringBuilder buffer = new StringBuilder();
            String rawText = ((FlexValue)this.myValue).getResult();
            if (rawText.contains(XMLLIST_MARKER)) {
                for (FakeCompositeNode child : this.myChildren) {
                    buffer.append(child.toPresentableSting(level));
                }
                return buffer.toString();
            }
            int xmlMarkerIndex = rawText.indexOf(XML_MARKER);
            int xmlInfoStartIndex = xmlMarkerIndex < 0 ? -1 : rawText.indexOf(" ", xmlMarkerIndex + XML_MARKER.length());
            int n = xmlInfoEndIndex = xmlMarkerIndex < 0 ? -1 : rawText.lastIndexOf("'");
            if (xmlInfoStartIndex > 0 && xmlInfoEndIndex > xmlInfoStartIndex) {
                boolean isText;
                String xmlInfo = rawText.substring(xmlInfoStartIndex, xmlInfoEndIndex);
                boolean isElement = xmlInfo.startsWith(" element <") && xmlInfo.endsWith(">");
                boolean isEmptyElement = isElement && xmlInfo.endsWith("/>");
                boolean bl = isText = !isElement && xmlInfo.startsWith(" text ");
                if (isText || isElement) {
                    if (isText) {
                        FakeCompositeNode.appendIndent(buffer, level);
                        buffer.append(xmlInfo.substring(" text ".length()));
                        buffer.append("\n");
                    } else if (isEmptyElement) {
                        FakeCompositeNode.appendIndent(buffer, level);
                        buffer.append(xmlInfo.substring(" element ".length()));
                        buffer.append("\n");
                    } else {
                        String startTag;
                        int spaceIndex = (startTag = xmlInfo.substring(" element ".length())).indexOf(" ");
                        String tagName = startTag.substring(1, spaceIndex > 0 ? spaceIndex : startTag.length() - 1);
                        FakeCompositeNode.appendIndent(buffer, level);
                        buffer.append(startTag);
                        buffer.append("\n");
                        for (FakeCompositeNode child : this.myChildren) {
                            buffer.append(child.toPresentableSting(level + 1));
                        }
                        FakeCompositeNode.appendIndent(buffer, level);
                        buffer.append("</").append(tagName).append("> ");
                        buffer.append("\n");
                    }
                }
            }
            return buffer.toString();
        }

        private static void appendIndent(StringBuilder buffer, int level) {
            for (int i = 0; i < level; ++i) {
                buffer.append("    ");
            }
        }

        public void tooManyChildren(int remaining) {
        }

        public void setErrorMessage(@NotNull String errorMessage) {
            if (errorMessage == null) {
                FakeCompositeNode.$$$reportNull$$$0(5);
            }
        }

        public void setErrorMessage(@NotNull String errorMessage, @Nullable XDebuggerTreeNodeHyperlink link) {
            if (errorMessage == null) {
                FakeCompositeNode.$$$reportNull$$$0(6);
            }
        }

        public void setMessage(@NotNull String message, Icon icon, @NotNull SimpleTextAttributes attributes, @Nullable XDebuggerTreeNodeHyperlink link) {
            if (message == null) {
                FakeCompositeNode.$$$reportNull$$$0(7);
            }
            if (attributes == null) {
                FakeCompositeNode.$$$reportNull$$$0(8);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callback";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "children";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorMessage";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/flex/debug/XmlObjectEvaluator$FakeCompositeNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addChildren";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setErrorMessage";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setMessage";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

