/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.importer;

import com.intellij.lang.javascript.flex.importer.AS3InterfaceDumper;
import com.intellij.lang.javascript.flex.importer.Abc;
import com.intellij.lang.javascript.flex.importer.FlexByteCodeInformationProcessor;
import com.intellij.lang.javascript.flex.importer.MemberInfo;
import com.intellij.lang.javascript.flex.importer.MetaData;
import com.intellij.lang.javascript.flex.importer.MethodInfo;
import com.intellij.lang.javascript.flex.importer.Multiname;
import com.intellij.lang.javascript.flex.importer.SlotInfo;
import com.intellij.lang.javascript.flex.importer.Traits;
import com.intellij.lang.javascript.refactoring.ECMAL4NamesValidator;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

abstract class AbstractDumpProcessor
implements FlexByteCodeInformationProcessor {
    @NonNls
    protected StringBuilder sb = new StringBuilder();
    private boolean firstMetaDataMember;
    final Set<String> classNameTable = new THashSet();
    private static final Multiname NsType = new Multiname(Abc.PUBLIC_NS_SET, "*");

    AbstractDumpProcessor() {
    }

    String getResult() {
        return this.sb.toString();
    }

    @Override
    public void append(@NotNull @NonNls String str) {
        if (str == null) {
            AbstractDumpProcessor.$$$reportNull$$$0(0);
        }
        this.sb.append(str);
    }

    @Override
    public String getParentName(MemberInfo member) {
        String parentName = null;
        if (member.parentTraits != null) {
            Multiname multiname;
            if (member.parentTraits.name instanceof Multiname && (multiname = (Multiname)member.parentTraits.name).hasNamespace()) {
                parentName = multiname.name;
            }
            if (parentName == null) {
                parentName = StringUtil.replace((String)member.parentTraits.name.toString(), (String)"::", (String)".");
            }
        }
        return parentName;
    }

    public void addMetaDataValue(String s, String s1) {
        this.append(this.firstMetaDataMember ? "(" : ",");
        this.firstMetaDataMember = false;
        if (s != null) {
            this.append(s);
            this.append("=");
        }
        this.append(s1);
    }

    @Override
    public void processVariable(SlotInfo info, String indent, String attr) {
        this.appendFieldSeparator();
        attr = this.appendModifiers(info, attr);
        this.processModifierList(info, attr, indent);
        this.append(indent + attr);
        this.processMemberKindAndName(info);
        this.append(":");
        this.dumpTypeRef(info.type, info.parentTraits.getClassName(), true);
        if (info.value != null) {
            this.processValue(info.type, info.value);
        }
    }

    @Override
    public void processFunction(MethodInfo methodInfo, boolean referenceNameRequested, Abc abc, String indent, String attr) {
        if (!referenceNameRequested) {
            this.appendMethodSeparator();
        }
        attr = this.appendModifiers(methodInfo, attr);
        this.processModifierList(methodInfo, attr, indent);
        this.append(indent + attr);
        this.processMemberKindAndName(methodInfo);
        String parentName = methodInfo.getParentName();
        this.processArgumentList(methodInfo, parentName);
        this.append(":");
        this.dumpTypeRef(methodInfo.returnType, parentName, referenceNameRequested);
    }

    protected void dumpTypeRef(Multiname name, String parentName, boolean referenceNameRequested) {
        this.processMultinameAsPackageName(name, parentName);
    }

    protected void processMemberKindAndName(@NotNull MemberInfo member) {
        if (member == null) {
            AbstractDumpProcessor.$$$reportNull$$$0(1);
        }
        this.append(Abc.traitKinds[member.kind != null ? member.kind.ordinal() : 0]);
        this.append(" ");
        if (member.name != null) {
            this.processMultinameAsPackageName(member.name, member.parentTraits.getClassName());
        } else {
            this.append("undefined");
        }
    }

    protected abstract String appendModifiers(MemberInfo var1, String var2);

    protected abstract void processValue(Multiname var1, Object var2);

    protected void processArgumentList(MethodInfo methodInfo, String parentName) {
        this.append("(");
        for (int i = 0; i < methodInfo.paramTypes.length; ++i) {
            Multiname paramType = methodInfo.paramTypes[i];
            boolean restParameter = "...".equals(paramType.name);
            if (restParameter && !this.dumpRestParameter()) break;
            if (i > 0) {
                this.append(",");
            }
            String name = methodInfo.paramNames != null && ECMAL4NamesValidator.isIdentifier((String)methodInfo.paramNames[i]) ? methodInfo.paramNames[i] : "a" + (i > 0 ? String.valueOf(i + 1) : "");
            this.processParameter(name, paramType, parentName, methodInfo.optionalValues != null && i < methodInfo.optionalValues.length ? methodInfo.optionalValues[i] : null, restParameter);
        }
        this.append(")");
    }

    protected abstract boolean dumpRestParameter();

    @Override
    public void processMetadata(MetaData metaData) {
        this.append("[");
        this.append(metaData.name);
        this.firstMetaDataMember = true;
        for (String n : metaData.keySet()) {
            this.addMetaDataValue(!"*".equals(n) || this.doStarMetaAttrNameDump() ? n : null, '\"' + AbstractDumpProcessor.quote((String)metaData.get(n)) + '\"');
        }
        if (!this.firstMetaDataMember) {
            this.append(")");
        }
        this.append("]");
    }

    @Override
    public void processClass(SlotInfo slotInfo, Abc abc, String attr, String indent) {
        this.append("\n");
        boolean isInterface = slotInfo.isInterfaceClass();
        String def = isInterface ? "interface" : "class";
        if (!this.doStarTypeDumpInExtends()) {
            String ns = slotInfo.name.hasNamespace() ? slotInfo.name.getNsName(slotInfo) : null;
            attr = ns != null && ns.length() > 0 ? attr + ns : attr + "public";
            attr = attr + " ";
        }
        Traits ct = (Traits)slotInfo.value;
        Traits it = ct.itraits;
        if (!isInterface) {
            if ((it.flags & 2) != 0) {
                attr = attr + "final ";
            }
            if ((it.flags & 1) == 0) {
                attr = attr + "dynamic ";
            }
        }
        this.processModifierList(slotInfo, attr, indent);
        this.append(indent + attr + def + " ");
        if (slotInfo.name.hasNotEmptyNs()) {
            this.classNameTable.add(slotInfo.name.nsset[0] + ":" + slotInfo.name.name);
        }
        this.processMultinameAsPackageName(slotInfo.name, null);
        this.dumpExtendsList(it);
        this.append("\n");
        String oldindent = indent;
        indent = indent + "  ";
        this.dumpInterfacesList(indent, it, isInterface);
        this.append(oldindent + "{\n");
        this.setProcessingInterface(isInterface);
        if (this.doDumpMember(it.init)) {
            it.init.dump(abc, indent, "", this);
        }
        it.dump(abc, indent, "", this);
        ct.dump(abc, indent, "static ", this);
        ct.init.dump(abc, indent, "static ", this);
        if (ct.usedNamespacesToNamesMap != null) {
            Object[] strings = new String[ct.usedNamespacesToNamesMap.size()];
            ct.usedNamespacesToNamesMap.keySet().toArray(strings);
            Arrays.sort(strings);
            for (Object e : strings) {
                SlotInfo info = new SlotInfo(new Multiname(Abc.PRIVATE_NS_SET, (String)ct.usedNamespacesToNamesMap.get(e)), Abc.TraitType.Const);
                info.type = NsType;
                info.value = e;
                info.parentTraits = it;
                info.dump(abc, indent, "static ", this);
            }
        }
        this.append(oldindent + "}\n");
        this.setProcessingInterface(false);
    }

    protected void processModifierList(MemberInfo memberInfo, String attr, String indent) {
        memberInfo.dumpMetaData(indent, this);
    }

    protected void dumpExtendsList(Traits it) {
        if (!it.base.isStarReference() || this.doStarTypeDumpInExtends()) {
            this.append(" extends ");
            this.dumpTypeRef(it.base, null, true);
        }
    }

    protected void dumpInterfacesList(String indent, Traits it, boolean anInterface) {
        if (it.interfaces.length > 0) {
            this.append(indent + (anInterface && this instanceof AS3InterfaceDumper ? "extends " : "implements "));
            boolean first = true;
            for (Multiname name : it.interfaces) {
                if (!first) {
                    this.append(",");
                }
                first = false;
                this.dumpTypeRef(name, null, true);
            }
            this.append("\n");
        }
    }

    protected static String quote(String s) {
        if (s.length() == 0) {
            return s;
        }
        StringBuilder b = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == '\\' || ch == '\"') {
                b.append('\\');
            } else {
                if (ch == '\n') {
                    b.append("\\n");
                    continue;
                }
                if (ch == '\r') {
                    b.append("\\r");
                    continue;
                }
            }
            b.append(ch);
        }
        return b.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/flex/importer/AbstractDumpProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "append";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "processMemberKindAndName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

