/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.run;

import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.flex.FlexCommonBundle;
import com.intellij.flex.FlexCommonUtils;
import com.intellij.flex.model.bc.LinkageType;
import com.intellij.flex.model.bc.OutputType;
import com.intellij.flex.model.bc.TargetPlatform;
import com.intellij.ide.BrowserUtil;
import com.intellij.javascript.flex.resolve.ActionScriptClassResolver;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.build.FlashProjectStructureProblem;
import com.intellij.lang.javascript.flex.projectStructure.model.AirPackagingOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.AndroidPackagingOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.CompilerOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.IosPackagingOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableAndroidPackagingOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableDependencyEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableFlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.Factory;
import com.intellij.lang.javascript.flex.projectStructure.options.BCUtils;
import com.intellij.lang.javascript.flex.projectStructure.ui.AirPackagingConfigurableBase;
import com.intellij.lang.javascript.flex.run.BCBasedRunnerParameters;
import com.intellij.lang.javascript.flex.run.LauncherParameters;
import com.intellij.lang.javascript.flex.sdk.FlexSdkUtils;
import com.intellij.lang.javascript.flex.sdk.FlexmojosSdkType;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlashRunnerParameters
extends BCBasedRunnerParameters
implements Cloneable {
    private boolean myOverrideMainClass = false;
    @NotNull
    private String myOverriddenMainClass = "";
    @NotNull
    private String myOverriddenOutputFileName = "";
    private boolean myLaunchUrl = false;
    @NotNull
    private String myUrl = "http://";
    @NotNull
    private LauncherParameters myLauncherParameters = new LauncherParameters();
    private boolean myRunTrusted = true;
    @NotNull
    private String myAdlOptions = "";
    @NotNull
    private String myAirProgramParameters = "";
    @NotNull
    private AirMobileRunTarget myMobileRunTarget = AirMobileRunTarget.Emulator;
    @NotNull
    private Emulator myEmulator = Emulator.NexusOne;
    private int myScreenWidth = 0;
    private int myScreenHeight = 0;
    private int myFullScreenWidth = 0;
    private int myFullScreenHeight = 0;
    private int myScreenDpi = 0;
    @NotNull
    private String myIOSSimulatorSdkPath = "";
    private boolean myFastPackaging = true;
    @NotNull
    private AirMobileDebugTransport myDebugTransport = AirMobileDebugTransport.USB;
    private int myUsbDebugPort = 7936;
    @NotNull
    private String myEmulatorAdlOptions = "";
    @NotNull
    private AppDescriptorForEmulator myAppDescriptorForEmulator = AppDescriptorForEmulator.Android;
    @NotNull
    private String myDebuggerSdkRaw = "BC SDK";

    public static void checkAirVersionIfCustomDescriptor(Module module, Sdk sdk, AirPackagingOptions packagingOptions, Consumer<FlashProjectStructureProblem> errorConsumer, boolean errorMessageForRunConfigValidation, String bcName) {
        if (packagingOptions.isUseGeneratedDescriptor()) {
            return;
        }
        if (packagingOptions.getCustomDescriptorPath().isEmpty()) {
            return;
        }
        VirtualFile descriptorFile = LocalFileSystem.getInstance().findFileByPath(packagingOptions.getCustomDescriptorPath());
        if (descriptorFile == null || descriptorFile.isDirectory()) {
            return;
        }
        if (sdk.getSdkType() == FlexmojosSdkType.getInstance()) {
            return;
        }
        PsiFile file = PsiManager.getInstance((Project)module.getProject()).findFile(descriptorFile);
        XmlTag rootTag = file instanceof XmlFile ? ((XmlFile)file).getRootTag() : null;
        String ns = rootTag == null ? null : rootTag.getNamespace();
        String nsVersion = ns != null && ns.startsWith("http://ns.adobe.com/air/application/") ? ns.substring("http://ns.adobe.com/air/application/".length()) : null;
        String airSdkVersion = FlexCommonUtils.getAirVersion((String)sdk.getHomePath(), (String)sdk.getVersionString());
        if (nsVersion != null && airSdkVersion != null && !nsVersion.equals(airSdkVersion)) {
            String message;
            if (errorMessageForRunConfigValidation) {
                message = FlexBundle.message("bc.0.module.1.air.version.mismatch.warning", bcName, module.getName(), nsVersion, airSdkVersion, FileUtil.toSystemDependentName((String)descriptorFile.getPath()));
            } else {
                String device = packagingOptions instanceof AndroidPackagingOptions ? "Android" : (packagingOptions instanceof IosPackagingOptions ? "iOS" : "");
                message = FlexBundle.message("air.version.mismatch.warning", device, descriptorFile.getName(), nsVersion, airSdkVersion);
            }
            errorConsumer.consume((Object)FlashProjectStructureProblem.createPackagingOptionsProblem(ProjectStructureProblemType.Severity.WARNING, packagingOptions, message, AirPackagingConfigurableBase.Location.CustomDescriptor));
        }
    }

    public boolean isOverrideMainClass() {
        return this.myOverrideMainClass;
    }

    public void setOverrideMainClass(boolean overrideMainClass) {
        this.myOverrideMainClass = overrideMainClass;
    }

    @NotNull
    public String getOverriddenMainClass() {
        String string = this.myOverriddenMainClass;
        if (string == null) {
            FlashRunnerParameters.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void setOverriddenMainClass(@NotNull String overriddenMainClass) {
        if (overriddenMainClass == null) {
            FlashRunnerParameters.$$$reportNull$$$0(1);
        }
        this.myOverriddenMainClass = overriddenMainClass;
    }

    @NotNull
    public String getOverriddenOutputFileName() {
        String string = this.myOverriddenOutputFileName;
        if (string == null) {
            FlashRunnerParameters.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void setOverriddenOutputFileName(@NotNull String overriddenOutputFileName) {
        if (overriddenOutputFileName == null) {
            FlashRunnerParameters.$$$reportNull$$$0(3);
        }
        this.myOverriddenOutputFileName = overriddenOutputFileName;
    }

    public boolean isLaunchUrl() {
        return this.myLaunchUrl;
    }

    public void setLaunchUrl(boolean launchUrl) {
        this.myLaunchUrl = launchUrl;
    }

    @NotNull
    public String getUrl() {
        String string = this.myUrl;
        if (string == null) {
            FlashRunnerParameters.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void setUrl(@NotNull String url) {
        if (url == null) {
            FlashRunnerParameters.$$$reportNull$$$0(5);
        }
        this.myUrl = url;
    }

    @NotNull
    public LauncherParameters getLauncherParameters() {
        LauncherParameters launcherParameters = this.myLauncherParameters;
        if (launcherParameters == null) {
            FlashRunnerParameters.$$$reportNull$$$0(6);
        }
        return launcherParameters;
    }

    public void setLauncherParameters(@NotNull LauncherParameters launcherParameters) {
        if (launcherParameters == null) {
            FlashRunnerParameters.$$$reportNull$$$0(7);
        }
        this.myLauncherParameters = launcherParameters;
    }

    public boolean isRunTrusted() {
        return this.myRunTrusted;
    }

    public void setRunTrusted(boolean runTrusted) {
        this.myRunTrusted = runTrusted;
    }

    @NotNull
    public String getAdlOptions() {
        String string = this.myAdlOptions;
        if (string == null) {
            FlashRunnerParameters.$$$reportNull$$$0(8);
        }
        return string;
    }

    public void setAdlOptions(@NotNull String adlOptions) {
        if (adlOptions == null) {
            FlashRunnerParameters.$$$reportNull$$$0(9);
        }
        this.myAdlOptions = adlOptions;
    }

    @NotNull
    public String getAirProgramParameters() {
        String string = this.myAirProgramParameters;
        if (string == null) {
            FlashRunnerParameters.$$$reportNull$$$0(10);
        }
        return string;
    }

    public void setAirProgramParameters(@NotNull String airProgramParameters) {
        if (airProgramParameters == null) {
            FlashRunnerParameters.$$$reportNull$$$0(11);
        }
        this.myAirProgramParameters = airProgramParameters;
    }

    @NotNull
    public AirMobileRunTarget getMobileRunTarget() {
        AirMobileRunTarget airMobileRunTarget = this.myMobileRunTarget;
        if (airMobileRunTarget == null) {
            FlashRunnerParameters.$$$reportNull$$$0(12);
        }
        return airMobileRunTarget;
    }

    public void setMobileRunTarget(@NotNull AirMobileRunTarget mobileRunTarget) {
        if (mobileRunTarget == null) {
            FlashRunnerParameters.$$$reportNull$$$0(13);
        }
        this.myMobileRunTarget = mobileRunTarget;
    }

    @NotNull
    public Emulator getEmulator() {
        Emulator emulator = this.myEmulator;
        if (emulator == null) {
            FlashRunnerParameters.$$$reportNull$$$0(14);
        }
        return emulator;
    }

    public void setEmulator(Emulator emulator) {
        if (Emulator.ALL_EMULATORS.contains((Object)emulator)) {
            this.myEmulator = emulator;
        } else if (emulator == Emulator.Other) {
            this.myEmulator = Emulator.OtherAndroidDevice;
        }
    }

    public int getScreenWidth() {
        return this.myScreenWidth;
    }

    public void setScreenWidth(int screenWidth) {
        this.myScreenWidth = screenWidth;
    }

    public int getScreenHeight() {
        return this.myScreenHeight;
    }

    public void setScreenHeight(int screenHeight) {
        this.myScreenHeight = screenHeight;
    }

    public int getFullScreenWidth() {
        return this.myFullScreenWidth;
    }

    public void setFullScreenWidth(int fullScreenWidth) {
        this.myFullScreenWidth = fullScreenWidth;
    }

    public int getFullScreenHeight() {
        return this.myFullScreenHeight;
    }

    public void setFullScreenHeight(int fullScreenHeight) {
        this.myFullScreenHeight = fullScreenHeight;
    }

    public int getScreenDpi() {
        return this.myScreenDpi;
    }

    public void setScreenDpi(int screenDpi) {
        this.myScreenDpi = screenDpi;
    }

    @NotNull
    public String getIOSSimulatorSdkPath() {
        String string = this.myIOSSimulatorSdkPath;
        if (string == null) {
            FlashRunnerParameters.$$$reportNull$$$0(15);
        }
        return string;
    }

    public void setIOSSimulatorSdkPath(@NotNull String IOSSimulatorSdkPath) {
        if (IOSSimulatorSdkPath == null) {
            FlashRunnerParameters.$$$reportNull$$$0(16);
        }
        this.myIOSSimulatorSdkPath = IOSSimulatorSdkPath;
    }

    public boolean isFastPackaging() {
        return this.myFastPackaging;
    }

    public void setFastPackaging(boolean fastPackaging) {
        this.myFastPackaging = fastPackaging;
    }

    @NotNull
    public AirMobileDebugTransport getDebugTransport() {
        AirMobileDebugTransport airMobileDebugTransport = this.myDebugTransport;
        if (airMobileDebugTransport == null) {
            FlashRunnerParameters.$$$reportNull$$$0(17);
        }
        return airMobileDebugTransport;
    }

    public void setDebugTransport(@NotNull AirMobileDebugTransport debugTransport) {
        if (debugTransport == null) {
            FlashRunnerParameters.$$$reportNull$$$0(18);
        }
        this.myDebugTransport = debugTransport;
    }

    public int getUsbDebugPort() {
        return this.myUsbDebugPort;
    }

    public void setUsbDebugPort(int usbDebugPort) {
        this.myUsbDebugPort = usbDebugPort;
    }

    @NotNull
    public String getEmulatorAdlOptions() {
        String string = this.myEmulatorAdlOptions;
        if (string == null) {
            FlashRunnerParameters.$$$reportNull$$$0(19);
        }
        return string;
    }

    public void setEmulatorAdlOptions(@NotNull String emulatorAdlOptions) {
        if (emulatorAdlOptions == null) {
            FlashRunnerParameters.$$$reportNull$$$0(20);
        }
        this.myEmulatorAdlOptions = emulatorAdlOptions;
    }

    @NotNull
    public AppDescriptorForEmulator getAppDescriptorForEmulator() {
        AppDescriptorForEmulator appDescriptorForEmulator = this.myAppDescriptorForEmulator;
        if (appDescriptorForEmulator == null) {
            FlashRunnerParameters.$$$reportNull$$$0(21);
        }
        return appDescriptorForEmulator;
    }

    public void setAppDescriptorForEmulator(AppDescriptorForEmulator appDescriptorForEmulator) {
        if (appDescriptorForEmulator != null) {
            this.myAppDescriptorForEmulator = appDescriptorForEmulator;
        }
    }

    @NotNull
    public String getDebuggerSdkRaw() {
        String string = this.myDebuggerSdkRaw;
        if (string == null) {
            FlashRunnerParameters.$$$reportNull$$$0(22);
        }
        return string;
    }

    public void setDebuggerSdkRaw(@NotNull String debuggerSdkRaw) {
        if (debuggerSdkRaw == null) {
            FlashRunnerParameters.$$$reportNull$$$0(23);
        }
        this.myDebuggerSdkRaw = debuggerSdkRaw;
    }

    public void check(Project project) throws RuntimeConfigurationError {
        this.doCheck(super.checkAndGetModuleAndBC(project));
    }

    public void reportWarnings(Project project) throws RuntimeConfigurationWarning {
        try {
            Pair<Module, FlexBuildConfiguration> moduleAndBC = super.checkAndGetModuleAndBC(project);
            Module module = (Module)moduleAndBC.first;
            FlexBuildConfiguration bc = (FlexBuildConfiguration)moduleAndBC.second;
            Ref errorMessageRef = new Ref(null);
            Consumer consumer = problem -> errorMessageRef.set((Object)problem.errorMessage);
            if (bc.getTargetPlatform() == TargetPlatform.Desktop) {
                FlashRunnerParameters.checkAirVersionIfCustomDescriptor(module, bc.getSdk(), bc.getAirDesktopPackagingOptions(), (Consumer<FlashProjectStructureProblem>)consumer, true, this.getBCName());
            } else if (bc.getTargetPlatform() == TargetPlatform.Mobile) {
                switch (this.myMobileRunTarget) {
                    case Emulator: {
                        switch (this.myAppDescriptorForEmulator) {
                            case Android: {
                                FlashRunnerParameters.checkAirVersionIfCustomDescriptor(module, bc.getSdk(), bc.getAndroidPackagingOptions(), (Consumer<FlashProjectStructureProblem>)consumer, true, this.getBCName());
                                break;
                            }
                            case IOS: {
                                FlashRunnerParameters.checkAirVersionIfCustomDescriptor(module, bc.getSdk(), bc.getIosPackagingOptions(), (Consumer<FlashProjectStructureProblem>)consumer, true, this.getBCName());
                            }
                        }
                        break;
                    }
                    case AndroidDevice: {
                        FlashRunnerParameters.checkAirVersionIfCustomDescriptor(module, bc.getSdk(), bc.getAndroidPackagingOptions(), (Consumer<FlashProjectStructureProblem>)consumer, true, this.getBCName());
                        break;
                    }
                    case iOSSimulator: 
                    case iOSDevice: {
                        FlashRunnerParameters.checkAirVersionIfCustomDescriptor(module, bc.getSdk(), bc.getIosPackagingOptions(), (Consumer<FlashProjectStructureProblem>)consumer, true, this.getBCName());
                    }
                }
            }
            if (!errorMessageRef.isNull()) {
                throw new RuntimeConfigurationWarning((String)errorMessageRef.get());
            }
        }
        catch (RuntimeConfigurationError runtimeConfigurationError) {
            // empty catch block
        }
    }

    @Override
    public Pair<Module, FlexBuildConfiguration> checkAndGetModuleAndBC(Project project) throws RuntimeConfigurationError {
        Pair<Module, FlexBuildConfiguration> moduleAndBC = super.checkAndGetModuleAndBC(project);
        this.doCheck(moduleAndBC);
        if (this.myOverrideMainClass) {
            FlexBuildConfiguration origBC = (FlexBuildConfiguration)moduleAndBC.second;
            ModifiableFlexBuildConfiguration overriddenBC = Factory.getTemporaryCopyForCompilation(origBC);
            overriddenBC.setOutputType(OutputType.Application);
            overriddenBC.setMainClass(this.myOverriddenMainClass);
            overriddenBC.setOutputFileName(this.myOverriddenOutputFileName);
            overriddenBC.setRLMs(Collections.emptyList());
            if (origBC.getOutputType() != OutputType.Application) {
                overriddenBC.setUseHtmlWrapper(false);
                overriddenBC.setCssFilesToCompile(Collections.emptyList());
                overriddenBC.getDependencies().setFrameworkLinkage(LinkageType.Merged);
                for (ModifiableDependencyEntry entry : overriddenBC.getDependencies().getModifiableEntries()) {
                    if (entry.getDependencyType().getLinkageType() != LinkageType.External) continue;
                    entry.getDependencyType().setLinkageType(LinkageType.Merged);
                }
                overriddenBC.getAirDesktopPackagingOptions().setUseGeneratedDescriptor(true);
                ModifiableAndroidPackagingOptions androidOptions = overriddenBC.getAndroidPackagingOptions();
                androidOptions.setEnabled(true);
                androidOptions.setUseGeneratedDescriptor(true);
                androidOptions.getSigningOptions().setUseTempCertificate(true);
                overriddenBC.getIosPackagingOptions().setEnabled(false);
            }
            if (BCUtils.canHaveResourceFiles(overriddenBC.getNature()) && !BCUtils.canHaveResourceFiles(origBC.getNature())) {
                overriddenBC.getCompilerOptions().setResourceFilesMode(CompilerOptions.ResourceFilesMode.None);
            }
            overriddenBC.getAndroidPackagingOptions().setPackageFileName(FileUtil.getNameWithoutExtension((String)this.myOverriddenOutputFileName));
            overriddenBC.getIosPackagingOptions().setPackageFileName(FileUtil.getNameWithoutExtension((String)this.myOverriddenOutputFileName));
            return Pair.create((Object)moduleAndBC.first, (Object)overriddenBC);
        }
        return moduleAndBC;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doCheck(Pair<Module, FlexBuildConfiguration> moduleAndBC) throws RuntimeConfigurationError {
        block38: {
            FlexBuildConfiguration bc = (FlexBuildConfiguration)moduleAndBC.second;
            Sdk sdk = bc.getSdk();
            if (sdk == null) {
                throw new RuntimeConfigurationError(FlexCommonBundle.message((String)"sdk.not.set.for.bc.0.of.module.1", (Object[])new Object[]{bc.getName(), ((Module)moduleAndBC.first).getName()}));
            }
            if (this.myOverrideMainClass) {
                if (this.myOverriddenMainClass.isEmpty()) {
                    throw new RuntimeConfigurationError(FlexBundle.message("main.class.not.set", new Object[0]));
                }
                PsiElement clazz = ActionScriptClassResolver.findClassByQNameStatic(this.myOverriddenMainClass, ((Module)moduleAndBC.first).getModuleScope(true));
                if (!(clazz instanceof JSClass)) {
                    throw new RuntimeConfigurationError(FlexBundle.message("main.class.not.found", this.myOverriddenMainClass, bc.getName()));
                }
                if (this.myOverriddenOutputFileName.isEmpty()) {
                    throw new RuntimeConfigurationError(FlexBundle.message("output.file.name.not.specified", new Object[0]));
                }
                if (!this.myOverriddenOutputFileName.toLowerCase().endsWith(".swf")) {
                    throw new RuntimeConfigurationError(FlexBundle.message("output.file.must.have.swf.extension", new Object[0]));
                }
            } else if (bc.getOutputType() != OutputType.Application) {
                throw new RuntimeConfigurationError(FlexBundle.message("bc.does.not.produce.app", this.getBCName(), this.getModuleName()));
            }
            block1 : switch (bc.getTargetPlatform()) {
                case Web: {
                    if (this.myLaunchUrl) {
                        if (this.myUrl.isEmpty()) {
                            throw new RuntimeConfigurationError(FlexBundle.message("flex.run.config.url.not.set", new Object[0]));
                        }
                        try {
                            if (BrowserUtil.getURL((String)this.myUrl) == null) {
                                throw new RuntimeConfigurationError(FlexBundle.message("flex.run.config.incorrect.url", new Object[0]));
                            }
                        }
                        catch (MalformedURLException e) {
                            throw new RuntimeConfigurationError(FlexBundle.message("flex.run.config.incorrect.url", new Object[0]));
                        }
                    }
                    if (this.myLauncherParameters.getLauncherType() == LauncherParameters.LauncherType.Player) {
                        if (StringUtil.isEmptyOrSpaces((String)this.myLauncherParameters.getPlayerPath())) {
                            throw new RuntimeConfigurationError(FlexBundle.message("path.to.flash.player.not.set", new Object[0]));
                        }
                        if (!new File(this.myLauncherParameters.getPlayerPath()).exists()) {
                            throw new RuntimeConfigurationError(FlexBundle.message("flash.player.not.found", this.myLauncherParameters.getPresentableText()));
                        }
                    }
                    this.checkDebuggerSdk();
                    return;
                }
                case Desktop: {
                    FlashRunnerParameters.checkAdlAndAirRuntime(sdk);
                    if (bc.getOutputType() != OutputType.Application) return;
                    FlashRunnerParameters.checkCustomDescriptor(bc.getAirDesktopPackagingOptions(), this.getBCName(), this.getModuleName());
                    return;
                }
                case Mobile: {
                    switch (this.myMobileRunTarget) {
                        case Emulator: {
                            FlashRunnerParameters.checkAdlAndAirRuntime(sdk);
                            if (bc.getOutputType() != OutputType.Application) return;
                            switch (this.myAppDescriptorForEmulator) {
                                case Android: {
                                    FlashRunnerParameters.checkCustomDescriptor(bc.getAndroidPackagingOptions(), this.getBCName(), this.getModuleName());
                                    break block1;
                                }
                                case IOS: {
                                    FlashRunnerParameters.checkCustomDescriptor(bc.getIosPackagingOptions(), this.getBCName(), this.getModuleName());
                                }
                            }
                            break block38;
                        }
                        case AndroidDevice: {
                            if (bc.getOutputType() != OutputType.Application) return;
                            FlashRunnerParameters.checkCustomDescriptor(bc.getAndroidPackagingOptions(), this.getBCName(), this.getModuleName());
                            break block38;
                        }
                        case iOSSimulator: {
                            if (bc.getOutputType() == OutputType.Application) {
                                FlashRunnerParameters.checkCustomDescriptor(bc.getIosPackagingOptions(), this.getBCName(), this.getModuleName());
                            }
                            if (!SystemInfo.isMac) {
                                throw new RuntimeConfigurationError(FlexBundle.message("ios.simulator.on.mac.only.warning", new Object[0]));
                            }
                            if (this.myIOSSimulatorSdkPath.isEmpty()) {
                                throw new RuntimeConfigurationError(FlexBundle.message("ios.simulator.sdk.not.set", new Object[0]));
                            }
                            if (new File(FileUtil.toSystemDependentName((String)this.myIOSSimulatorSdkPath)).isDirectory()) return;
                            throw new RuntimeConfigurationError(FlexBundle.message("ios.simulator.sdk.not.found", FileUtil.toSystemDependentName((String)this.myIOSSimulatorSdkPath)));
                        }
                        case iOSDevice: {
                            if (bc.getOutputType() != OutputType.Application) return;
                            FlashRunnerParameters.checkCustomDescriptor(bc.getIosPackagingOptions(), this.getBCName(), this.getModuleName());
                        }
                    }
                }
            }
        }
    }

    protected void checkDebuggerSdk() throws RuntimeConfigurationError {
        Sdk sdk;
        if (!this.myDebuggerSdkRaw.equals("BC SDK") && (sdk = FlexSdkUtils.findFlexOrFlexmojosSdk(this.myDebuggerSdkRaw)) == null) {
            throw new RuntimeConfigurationError(FlexBundle.message("debugger.sdk.not.found", this.myDebuggerSdkRaw));
        }
    }

    public static void checkCustomDescriptor(AirPackagingOptions packagingOptions, String bcName, String moduleName) throws RuntimeConfigurationError {
        boolean android = packagingOptions instanceof AndroidPackagingOptions;
        boolean ios = packagingOptions instanceof IosPackagingOptions;
        if (android && !((AndroidPackagingOptions)packagingOptions).isEnabled()) {
            throw new RuntimeConfigurationError(FlexBundle.message("android.disabled.in.bc", bcName, moduleName));
        }
        if (ios && !((IosPackagingOptions)packagingOptions).isEnabled()) {
            throw new RuntimeConfigurationError(FlexBundle.message("ios.disabled.in.bc", bcName, moduleName));
        }
        if (!packagingOptions.isUseGeneratedDescriptor()) {
            if (packagingOptions.getCustomDescriptorPath().isEmpty()) {
                String key = android ? "bc.0.module.1.android.custom.descriptor.not.set" : (ios ? "bc.0.module.1.ios.custom.descriptor.not.set" : "bc.0.module.1.custom.descriptor.not.set");
                throw new RuntimeConfigurationError(FlexBundle.message(key, bcName, moduleName));
            }
            VirtualFile descriptorFile = LocalFileSystem.getInstance().findFileByPath(packagingOptions.getCustomDescriptorPath());
            if (descriptorFile == null || descriptorFile.isDirectory()) {
                String key = android ? "bc.0.module.1.android.custom.descriptor.not.found" : (ios ? "bc.0.module.1.ios.custom.descriptor.not.found" : "bc.0.module.1.custom.descriptor.not.found");
                throw new RuntimeConfigurationError(FlexBundle.message(key, bcName, moduleName, FileUtil.toSystemDependentName((String)packagingOptions.getCustomDescriptorPath())));
            }
        }
    }

    public static void checkAdlAndAirRuntime(@NotNull Sdk sdk) throws RuntimeConfigurationError {
        String adlPath;
        if (sdk == null) {
            FlashRunnerParameters.$$$reportNull$$$0(24);
        }
        if (StringUtil.isEmpty((String)(adlPath = FlexSdkUtils.getAdlPath(sdk)))) {
            throw new RuntimeConfigurationError(FlexBundle.message("adl.not.set.check.sdk.settings", sdk.getName()));
        }
        VirtualFile adlFile = LocalFileSystem.getInstance().findFileByPath(adlPath);
        if (adlFile == null || adlFile.isDirectory()) {
            throw new RuntimeConfigurationError(sdk.getSdkType() instanceof FlexmojosSdkType ? FlexBundle.message("adl.not.found.check.sdk.settings", adlPath, sdk.getName()) : FlexBundle.message("adl.not.found.check.sdk.installation", adlPath, sdk.getName()));
        }
        if (sdk.getSdkType() instanceof FlexmojosSdkType) {
            String airRuntimePath = FlexSdkUtils.getAirRuntimePathForFlexmojosSdk(sdk);
            if (StringUtil.isEmpty((String)airRuntimePath)) {
                throw new RuntimeConfigurationError(FlexBundle.message("air.runtime.not.set.check.sdk.settings", sdk.getName()));
            }
            VirtualFile airRuntimeDir = LocalFileSystem.getInstance().findFileByPath(airRuntimePath);
            if (airRuntimeDir == null) {
                throw new RuntimeConfigurationError(FlexBundle.message("air.runtime.not.found.check.sdk.settings", airRuntimePath, sdk.getName()));
            }
        }
    }

    public String suggestName() {
        return this.myOverrideMainClass ? StringUtil.getShortName((String)this.myOverriddenMainClass) : (this.getBCName().equals(this.getModuleName()) ? this.getBCName() : this.getBCName() + " (" + this.getModuleName() + ")");
    }

    public String suggestUniqueName(List<RunConfiguration> existingConfigurations) {
        int i;
        String suggestedName = this.suggestName();
        String[] used = new String[existingConfigurations.size()];
        for (i = 0; i < existingConfigurations.size(); ++i) {
            used[i] = existingConfigurations.get(i).getName();
        }
        if (ArrayUtil.contains((String)suggestedName, (String[])used)) {
            String name;
            i = 1;
            while (ArrayUtil.contains((String)(name = suggestedName + " (" + i + ")"), (String[])used)) {
                ++i;
            }
            return name;
        }
        return suggestedName;
    }

    @Override
    protected FlashRunnerParameters clone() {
        FlashRunnerParameters clone = (FlashRunnerParameters)super.clone();
        clone.myLauncherParameters = this.myLauncherParameters.clone();
        return clone;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FlashRunnerParameters that = (FlashRunnerParameters)o;
        if (this.myScreenDpi != that.myScreenDpi) {
            return false;
        }
        if (this.myFullScreenHeight != that.myFullScreenHeight) {
            return false;
        }
        if (this.myFullScreenWidth != that.myFullScreenWidth) {
            return false;
        }
        if (this.myLaunchUrl != that.myLaunchUrl) {
            return false;
        }
        if (this.myOverrideMainClass != that.myOverrideMainClass) {
            return false;
        }
        if (this.myRunTrusted != that.myRunTrusted) {
            return false;
        }
        if (this.myScreenHeight != that.myScreenHeight) {
            return false;
        }
        if (this.myScreenWidth != that.myScreenWidth) {
            return false;
        }
        if (this.myUsbDebugPort != that.myUsbDebugPort) {
            return false;
        }
        if (!this.myAdlOptions.equals(that.myAdlOptions)) {
            return false;
        }
        if (!this.myAirProgramParameters.equals(that.myAirProgramParameters)) {
            return false;
        }
        if (this.myDebugTransport != that.myDebugTransport) {
            return false;
        }
        if (this.myEmulator != that.myEmulator) {
            return false;
        }
        if (!this.myEmulatorAdlOptions.equals(that.myEmulatorAdlOptions)) {
            return false;
        }
        if (!this.myLauncherParameters.equals(that.myLauncherParameters)) {
            return false;
        }
        if (this.myMobileRunTarget != that.myMobileRunTarget) {
            return false;
        }
        if (!this.myOverriddenMainClass.equals(that.myOverriddenMainClass)) {
            return false;
        }
        if (!this.myOverriddenOutputFileName.equals(that.myOverriddenOutputFileName)) {
            return false;
        }
        return this.myUrl.equals(that.myUrl);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 20: 
            case 23: 
            case 24: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 20: 
            case 23: 
            case 24: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flex/run/FlashRunnerParameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overriddenMainClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overriddenOutputFileName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcherParameters";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adlOptions";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "airProgramParameters";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mobileRunTarget";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "IOSSimulatorSdkPath";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugTransport";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emulatorAdlOptions";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerSdkRaw";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOverriddenMainClass";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 20: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flex/run/FlashRunnerParameters";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOverriddenOutputFileName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLauncherParameters";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdlOptions";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAirProgramParameters";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getMobileRunTarget";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmulator";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getIOSSimulatorSdkPath";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugTransport";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmulatorAdlOptions";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppDescriptorForEmulator";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebuggerSdkRaw";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setOverriddenMainClass";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setOverriddenOutputFileName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setUrl";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setLauncherParameters";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setAdlOptions";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setAirProgramParameters";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setMobileRunTarget";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setIOSSimulatorSdkPath";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setDebugTransport";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setEmulatorAdlOptions";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setDebuggerSdkRaw";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "checkAdlAndAirRuntime";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 20: 
            case 23: 
            case 24: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum AppDescriptorForEmulator {
        Android,
        IOS;

    }

    public static enum AirMobileDebugTransport {
        Network,
        USB;

    }

    public static enum Emulator {
        E480("720 x 480", "480", 0, null, 720, 480, 720, 480),
        E720("1280 x 720", "720", 0, null, 1280, 720, 1280, 720),
        E1080("1920 x 1080", "1080", 0, null, 1920, 1080, 1920, 1080),
        iPad("Apple iPad", "iPad", 132, "IOS", 768, 1004, 768, 1024),
        iPadRetina("Apple iPad Retina", "iPadRetina", 264, "IOS", 1536, 2008, 1536, 2048),
        iPhone("Apple iPhone", "iPhone", 163, "IOS", 320, 460, 320, 480),
        iPhoneRetina("Apple iPhone Retina", "iPhoneRetina", 326, "IOS", 640, 920, 640, 960),
        NexusOne("Google Nexus One", "NexusOne", 252, "AND", 480, 762, 480, 800),
        Droid("Motorola Droid", "Droid", 265, "AND", 480, 816, 480, 854),
        SamsungGalaxyS("Samsung Galaxy S", "SamsungGalaxyS", 233, "AND", 480, 762, 480, 800),
        SamsungGalaxyTab("Samsung Galaxy Tab", "SamsungGalaxyTab", 168, "AND", 600, 986, 600, 1024),
        OtherAndroidDevice("Other Android device...", null, 0, "AND", 0, 0, 0, 0),
        OtherIOSDevice("Other iOS Device...", null, 0, "IOS", 0, 0, 0, 0),
        Other("Other...", null, 0, null, 0, 0, 0, 0),
        FWQVGA("FWQVGA", "FWQVGA", 0, null, 240, 432, 240, 432),
        FWVGA("FWVGA", "FWVGA", 0, null, 480, 584, 480, 854),
        HVGA("HVGA", "HVGA", 0, null, 320, 480, 320, 480),
        QVGA("QVGA", "QVGA", 0, null, 240, 320, 240, 320),
        WQVGA("WQVGA", "WQVGA", 0, null, 240, 400, 240, 400),
        WVGA("WVGA", "WVGA", 0, null, 480, 800, 480, 800);

        public static final EnumSet<Emulator> ALL_EMULATORS;
        public final String name;
        @Nullable
        public final String adlAlias;
        public final int screenDPI;
        @Nullable
        public final String versionPlatform;
        public final int screenWidth;
        public final int screenHeight;
        public final int fullScreenWidth;
        public final int fullScreenHeight;

        private Emulator(String name, @Nullable String adlAlias, int screenDPI, String versionPlatform, int screenWidth, int screenHeight, int fullScreenWidth, int fullScreenHeight) {
            this.name = name;
            this.adlAlias = adlAlias;
            this.screenDPI = screenDPI;
            this.versionPlatform = versionPlatform;
            this.screenWidth = screenWidth;
            this.screenHeight = screenHeight;
            this.fullScreenWidth = fullScreenWidth;
            this.fullScreenHeight = fullScreenHeight;
        }

        static {
            ALL_EMULATORS = EnumSet.range(Emulator.values()[0], OtherIOSDevice);
        }
    }

    public static enum AirMobileRunTarget {
        Emulator,
        AndroidDevice,
        iOSSimulator,
        iOSDevice;

    }
}

