/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configuration.EmptyRunProfileState;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.lang.javascript.flex.FlexModuleType;
import com.intellij.lang.javascript.flex.run.RemoteFlashRunConfigurationForm;
import com.intellij.lang.javascript.flex.run.RemoteFlashRunnerParameters;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.XmlSerializer;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class RemoteFlashRunConfiguration
extends LocatableConfigurationBase {
    private static final String DEFAULT_NAME = "Remote debug";
    private RemoteFlashRunnerParameters myRunnerParameters = new RemoteFlashRunnerParameters();

    public RemoteFlashRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
    }

    public RemoteFlashRunConfiguration clone() {
        RemoteFlashRunConfiguration clone = (RemoteFlashRunConfiguration)super.clone();
        clone.myRunnerParameters = this.myRunnerParameters.clone();
        return clone;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        RemoteFlashRunConfigurationForm remoteFlashRunConfigurationForm = new RemoteFlashRunConfigurationForm(this.getProject());
        if (remoteFlashRunConfigurationForm == null) {
            RemoteFlashRunConfiguration.$$$reportNull$$$0(0);
        }
        return remoteFlashRunConfigurationForm;
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            RemoteFlashRunConfiguration.$$$reportNull$$$0(1);
        }
        super.readExternal(element);
        this.myRunnerParameters = new RemoteFlashRunnerParameters();
        XmlSerializer.deserializeInto((Object)this.myRunnerParameters, (Element)element);
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            RemoteFlashRunConfiguration.$$$reportNull$$$0(2);
        }
        super.writeExternal(element);
        XmlSerializer.serializeInto((Object)this.myRunnerParameters, (Element)element);
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            RemoteFlashRunConfiguration.$$$reportNull$$$0(3);
        }
        if (env == null) {
            RemoteFlashRunConfiguration.$$$reportNull$$$0(4);
        }
        try {
            this.myRunnerParameters.checkAndGetModuleAndBC(this.getProject());
        }
        catch (RuntimeConfigurationError e) {
            throw new ExecutionException(e.getMessage());
        }
        return EmptyRunProfileState.INSTANCE;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        this.myRunnerParameters.checkAndGetModuleAndBC(this.getProject());
    }

    @NotNull
    public RemoteFlashRunnerParameters getRunnerParameters() {
        RemoteFlashRunnerParameters remoteFlashRunnerParameters = this.myRunnerParameters;
        if (remoteFlashRunnerParameters == null) {
            RemoteFlashRunConfiguration.$$$reportNull$$$0(5);
        }
        return remoteFlashRunnerParameters;
    }

    @NotNull
    public Module[] getModules() {
        Module module = ModuleManager.getInstance((Project)this.getProject()).findModuleByName(this.myRunnerParameters.getModuleName());
        if (module != null && ModuleType.get((Module)module) instanceof FlexModuleType) {
            Module[] moduleArray = new Module[]{module};
            if (moduleArray == null) {
                RemoteFlashRunConfiguration.$$$reportNull$$$0(6);
            }
            return moduleArray;
        }
        if (Module.EMPTY_ARRAY == null) {
            RemoteFlashRunConfiguration.$$$reportNull$$$0(7);
        }
        return Module.EMPTY_ARRAY;
    }

    public String suggestedName() {
        String bcName = this.myRunnerParameters.getBCName();
        return StringUtil.isEmptyOrSpaces((String)bcName) ? DEFAULT_NAME : "Remote debug (" + bcName + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flex/run/RemoteFlashRunConfiguration";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flex/run/RemoteFlashRunConfiguration";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunnerParameters";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

