/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.generation;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.generation.BaseJSGenerateHandler;
import com.intellij.lang.javascript.generation.JSChooserElementNode;
import com.intellij.lang.javascript.generation.JSNamedElementNode;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.validation.ActionScriptImplementedMethodProcessor;
import com.intellij.lang.javascript.validation.fixes.BaseCreateMembersFix;
import com.intellij.lang.javascript.validation.fixes.ImplementMethodsFix;
import com.intellij.psi.PsiElement;
import java.util.Collection;

public class JavaScriptImplementMethodsHandlerForFlex
extends BaseJSGenerateHandler {
    protected void collectCandidates(PsiElement clazz, Collection<JSChooserElementNode> candidates) {
        for (JSFunction fun : ActionScriptImplementedMethodProcessor.collectFunctionsToImplement((JSClass)clazz)) {
            candidates.add((JSChooserElementNode)new JSNamedElementNode((JSPsiNamedElementBase)fun));
        }
    }

    protected String getTitleKey() {
        return "methods.to.implement.chooser.title";
    }

    protected String getNoCandidatesMessage() {
        return JSBundle.message((String)"no.methods.to.implement", (Object[])new Object[0]);
    }

    protected BaseCreateMembersFix createFix(PsiElement clazz) {
        return new ImplementMethodsFix((JSClass)clazz);
    }

    protected boolean isValidForTarget(PsiElement jsClass) {
        return jsClass instanceof JSClass && !((JSClass)jsClass).isInterface() && !DialectDetector.isJavaScriptFamily((PsiElement)jsClass);
    }

    protected String getProductivityFeatureId() {
        return "codeassists.overrideimplement";
    }
}

