/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections.actionscript;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.flex.AddImportECMAScriptClassOrFunctionAction;
import com.intellij.lang.javascript.flex.FlexModuleType;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.actionscript.DeclareConditionalCompilerDefinitionFix;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.e4x.JSE4XNamespaceReference;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSPackageWrapper;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.validation.JSReferenceInspectionProblemReporter;
import com.intellij.lang.javascript.validation.TypedJSReferenceChecker;
import com.intellij.lang.javascript.validation.fixes.CreateFlexMobileViewIntentionAndFix;
import com.intellij.lang.javascript.validation.fixes.CreateJSEventMethod;
import com.intellij.lang.javascript.validation.fixes.CreateJSFunctionIntentionAction;
import com.intellij.lang.javascript.validation.fixes.CreateJSPropertyAccessorIntentionAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionScriptReferenceChecker
extends TypedJSReferenceChecker {
    public ActionScriptReferenceChecker(@NotNull JSReferenceInspectionProblemReporter reporter) {
        if (reporter == null) {
            ActionScriptReferenceChecker.$$$reportNull$$$0(0);
        }
        super(reporter);
    }

    @Nullable
    protected LocalQuickFix getPreferredQuickFixForUnresolvedRef(PsiElement nameIdentifier) {
        JSExpression[] params;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)nameIdentifier);
        if (module == null || ModuleType.get((Module)module) != FlexModuleType.getInstance()) {
            return null;
        }
        String conditionalCompilerDefinitionName = ActionScriptReferenceChecker.getPotentialConditionalCompilerDefinitionName(nameIdentifier);
        if (conditionalCompilerDefinitionName != null) {
            return new DeclareConditionalCompilerDefinitionFix(module, conditionalCompilerDefinitionName);
        }
        JSCallExpression callExpression = (JSCallExpression)PsiTreeUtil.getParentOfType((PsiElement)nameIdentifier, JSCallExpression.class);
        if (callExpression == null) {
            return null;
        }
        if (JSResolveUtil.isEventListenerCall((JSCallExpression)callExpression)) {
            JSExpression[] params2 = callExpression.getArguments();
            if (params2.length >= 2 && PsiTreeUtil.isAncestor((PsiElement)params2[1], (PsiElement)nameIdentifier, (boolean)true)) {
                return new CreateJSEventMethod(nameIdentifier.getText(), (Computable<String>)((Computable)() -> {
                    JSExpression responsibleElement = null;
                    if (params2[0] instanceof JSReferenceExpression) {
                        responsibleElement = ((JSReferenceExpression)params2[0]).getQualifier();
                    }
                    return responsibleElement == null ? "flash.events.Event" : responsibleElement.getText();
                }));
            }
        } else if (ActionScriptReferenceChecker.needsFlexMobileViewAsFirstArgument(callExpression) && (params = callExpression.getArguments()).length >= 1 && PsiTreeUtil.isAncestor((PsiElement)params[0], (PsiElement)nameIdentifier, (boolean)true)) {
            String contextPackage = JSResolveUtil.getPackageNameFromPlace((PsiElement)callExpression);
            String fqn = StringUtil.getQualifiedName((String)contextPackage, (String)nameIdentifier.getText());
            CreateFlexMobileViewIntentionAndFix fix = new CreateFlexMobileViewIntentionAndFix(fqn, nameIdentifier, true);
            fix.setCreatedClassFqnConsumer((Consumer<String>)((Consumer)fqn1 -> {
                String packageName = StringUtil.getPackageName((String)fqn1);
                if (StringUtil.isNotEmpty((String)packageName) && !packageName.equals(contextPackage)) {
                    ImportUtils.doImport((PsiElement)nameIdentifier, (String)fqn1, (boolean)true);
                }
            }));
            return fix;
        }
        return null;
    }

    @Nullable
    private static String getPotentialConditionalCompilerDefinitionName(PsiElement identifier) {
        PsiElement parent3;
        PsiElement parent1 = identifier.getParent();
        PsiElement parent2 = parent1 == null ? null : parent1.getParent();
        PsiElement psiElement = parent3 = parent2 == null ? null : parent2.getParent();
        if (parent1 instanceof JSReferenceExpression && ((JSReferenceExpression)parent1).getQualifier() == null && parent2 instanceof JSE4XNamespaceReference && parent3 instanceof JSReferenceExpression && ((JSReferenceExpression)parent3).getQualifier() == null) {
            return ActionScriptReferenceChecker.getNormalizedConditionalCompilerDefinitionName(parent3.getText());
        }
        return null;
    }

    @Nullable
    private static String getNormalizedConditionalCompilerDefinitionName(String name) {
        int colonsIndex = name.indexOf("::");
        if (colonsIndex > 0) {
            String first = name.substring(0, colonsIndex).trim();
            String second = name.substring(colonsIndex + "::".length()).trim();
            if (StringUtil.isJavaIdentifier((String)first) && StringUtil.isJavaIdentifier((String)second)) {
                return first + "::" + second;
            }
        }
        return null;
    }

    private static boolean needsFlexMobileViewAsFirstArgument(JSCallExpression callExpression) {
        JSExpression methodExpr = callExpression.getMethodExpression();
        PsiElement function = methodExpr instanceof JSReferenceExpression ? ((JSReferenceExpression)methodExpr).resolve() : null;
        PsiElement clazz = function instanceof JSFunction && ArrayUtil.contains((String)((JSFunction)function).getName(), (String[])new String[]{"pushView", "replaceView"}) ? function.getParent() : null;
        return clazz instanceof JSClass && "spark.components.ViewNavigator".equals(((JSClass)clazz).getQualifiedName());
    }

    protected boolean addCreateFromUsageFixes(JSReferenceExpression node, ResolveResult[] resolveResults, List<LocalQuickFix> fixes, boolean inTypeContext, boolean ecma) {
        PsiElement nodeParent = node.getParent();
        JSExpression qualifier = node.getQualifier();
        String referencedName = node.getReferenceName();
        inTypeContext = super.addCreateFromUsageFixes(node, resolveResults, fixes, inTypeContext, ecma);
        if (!(nodeParent instanceof JSArgumentList) && nodeParent.getParent() instanceof JSCallExpression) {
            inTypeContext = true;
        }
        if (!inTypeContext) {
            boolean getter = !(node.getParent() instanceof JSDefinitionExpression);
            fixes.add((LocalQuickFix)new CreateJSPropertyAccessorIntentionAction(referencedName, getter));
        }
        if (qualifier == null) {
            boolean canHaveTypeFix = false;
            if (nodeParent instanceof JSReferenceListMember) {
                canHaveTypeFix = true;
            } else if (!(nodeParent instanceof JSDefinitionExpression) && resolveResults.length == 0) {
                canHaveTypeFix = true;
                fixes.add(ActionScriptReferenceChecker.createClassOrInterfaceFix((JSReferenceExpression)node, (boolean)false));
                fixes.add(ActionScriptReferenceChecker.createClassOrInterfaceFix((JSReferenceExpression)node, (boolean)true));
            }
            if (!inTypeContext && JSReadWriteAccessDetector.ourInstance.getExpressionAccess((PsiElement)node) == ReadWriteAccessDetector.Access.Read) {
                canHaveTypeFix = true;
                fixes.add((LocalQuickFix)new CreateJSFunctionIntentionAction(referencedName, true));
            }
            if (canHaveTypeFix) {
                fixes.add(new AddImportECMAScriptClassOrFunctionAction(null, (PsiPolyVariantReference)node));
            }
        } else if (ActionScriptReferenceChecker.canHaveImportTo(resolveResults)) {
            fixes.add(new AddImportECMAScriptClassOrFunctionAction(null, (PsiPolyVariantReference)node));
        }
        return inTypeContext;
    }

    protected void addCreateFromUsageFixesForCall(@NotNull JSCallExpression node, @NotNull JSReferenceExpression referenceExpression, @NotNull ResolveResult[] resolveResults, @NotNull List<LocalQuickFix> quickFixes) {
        if (node == null) {
            ActionScriptReferenceChecker.$$$reportNull$$$0(1);
        }
        if (referenceExpression == null) {
            ActionScriptReferenceChecker.$$$reportNull$$$0(2);
        }
        if (resolveResults == null) {
            ActionScriptReferenceChecker.$$$reportNull$$$0(3);
        }
        if (quickFixes == null) {
            ActionScriptReferenceChecker.$$$reportNull$$$0(4);
        }
        if (ActionScriptReferenceChecker.canHaveImportTo(resolveResults)) {
            quickFixes.add(new AddImportECMAScriptClassOrFunctionAction(null, (PsiPolyVariantReference)referenceExpression));
        }
        if (!(node instanceof JSNewExpression)) {
            quickFixes.add(JSFixFactory.getInstance().createJSFunctionIntentionAction(referenceExpression.getReferenceName(), true));
        }
        super.addCreateFromUsageFixesForCall(node, referenceExpression, resolveResults, quickFixes);
    }

    private static boolean canHaveImportTo(ResolveResult[] resolveResults) {
        if (resolveResults.length == 0) {
            return true;
        }
        for (ResolveResult r : resolveResults) {
            if (!r.isValidResult()) {
                if (!(r instanceof JSResolveResult) || ((JSResolveResult)r).getResolveProblemKey() != "javascript.qualified.name.is.not.imported.message") continue;
                return true;
            }
            PsiElement element = r.getElement();
            if (element instanceof JSClass) {
                return true;
            }
            if (!(element instanceof JSFunction) || !((JSFunction)element).isConstructor()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public ProblemHighlightType getUnresolvedReferenceHighlightType(@NotNull JSReferenceExpression node) {
        JSExpression qualifier;
        if (node == null) {
            ActionScriptReferenceChecker.$$$reportNull$$$0(5);
        }
        if ((qualifier = ((JSReferenceExpressionImpl)node).getResolveQualifier()) != null) {
            PsiFile containingFile = node.getContainingFile();
            JSType type = null;
            boolean checkType = false;
            if (qualifier instanceof JSReferenceExpression) {
                ResolveResult[] results = ((JSReferenceExpression)qualifier).multiResolve(false);
                if (results.length != 0) {
                    PsiElement resultElement = results[0].getElement();
                    if (resultElement instanceof JSPackageWrapper) {
                        return ProblemHighlightType.ERROR;
                    }
                    type = this.getResolveResultType(qualifier, resultElement);
                    checkType = true;
                }
            } else {
                type = JSResolveUtil.getExpressionJSType((JSExpression)qualifier);
                checkType = true;
            }
            if (checkType && (type instanceof JSAnyType || type == null)) {
                return ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
            }
            JSClass jsClass = JSResolveUtil.findClassOfQualifier((JSExpression)qualifier, (PsiFile)containingFile);
            if (jsClass == null) {
                return ProblemHighlightType.ERROR;
            }
            JSAttributeList attributeList = jsClass.getAttributeList();
            if (attributeList == null || !attributeList.hasModifier(JSAttributeList.ModifierType.DYNAMIC)) {
                return ProblemHighlightType.ERROR;
            }
            String qualifiedName = jsClass.getQualifiedName();
            if ("Error".equals(qualifiedName) || "Date".equals(qualifiedName)) {
                return ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
            }
        }
        return super.getUnresolvedReferenceHighlightType(node);
    }

    @Nullable
    protected JSType getResolveResultType(JSExpression qualifier, PsiElement resultElement) {
        if (resultElement instanceof JSVariable) {
            return ((JSVariable)resultElement).getType();
        }
        return JSResolveUtil.getExpressionJSType((JSExpression)qualifier);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResults";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFixes";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/inspections/actionscript/ActionScriptReferenceChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addCreateFromUsageFixesForCall";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getUnresolvedReferenceHighlightType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

