/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections.actionscript;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLocalVariable;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.JSChangeVisibilityUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class JSImplicitlyInternalDeclarationInspection
extends JSInspection {
    @NotNull
    public String getDisplayName() {
        String string = FlexBundle.message("js.implicitly.internal.declaration.inspection.name", new Object[0]);
        if (string == null) {
            JSImplicitlyInternalDeclarationInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    protected JSElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSClass(JSClass aClass) {
                JSImplicitlyInternalDeclarationInspection.process((JSNamedElement)aClass, holder);
            }

            public void visitJSLocalVariable(JSLocalVariable var) {
            }

            public void visitJSVariable(JSVariable node) {
                JSImplicitlyInternalDeclarationInspection.process((JSNamedElement)node, holder);
            }

            public void visitJSFunctionDeclaration(JSFunction node) {
                JSImplicitlyInternalDeclarationInspection.process((JSNamedElement)node, holder);
            }
        };
        if (jSElementVisitor == null) {
            JSImplicitlyInternalDeclarationInspection.$$$reportNull$$$0(1);
        }
        return jSElementVisitor;
    }

    private static void process(JSNamedElement node, ProblemsHolder holder) {
        JSAttributeList.AccessType accessType;
        PsiElement parent;
        if (!DialectDetector.isActionScript((PsiElement)node)) {
            return;
        }
        JSFunction fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)node, JSFunction.class);
        if (fun != null) {
            return;
        }
        ASTNode nameIdentifier = node.findNameIdentifier();
        if (nameIdentifier == null) {
            return;
        }
        JSClass clazz = JSResolveUtil.getClassOfContext((PsiElement)node);
        if (clazz == null && !((parent = JSResolveUtil.findParent((PsiElement)node)) instanceof JSPackageStatement)) {
            return;
        }
        JSAttributeList attributeList = ((JSAttributeListOwner)node).getAttributeList();
        JSAttributeList.AccessType accessType2 = accessType = attributeList != null ? attributeList.getAccessType() : null;
        if (accessType == JSAttributeList.AccessType.PACKAGE_LOCAL && attributeList.findAccessTypeElement() == null && attributeList.getNamespaceElement() == null && !JSResolveUtil.isConstructorFunction((PsiElement)node)) {
            holder.registerProblem(nameIdentifier.getPsi(), FlexBundle.message("js.implicitly.internal.declaration.problem", new Object[0]), new LocalQuickFix[]{new LocalQuickFix(){

                @NotNull
                public String getFamilyName() {
                    String string = FlexBundle.message("js.implicitly.internal.declaration.problem.add.internal.fix", new Object[0]);
                    if (string == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                    if (project == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (descriptor == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    PsiElement anchor = descriptor.getPsiElement();
                    JSChangeVisibilityUtil.setVisibility((JSAttributeListOwner)((JSAttributeListOwner)anchor.getParent()), (JSAttributeList.AccessType)JSAttributeList.AccessType.PACKAGE_LOCAL);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                        case 1: 
                        case 2: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 2;
                            break;
                        }
                        case 1: 
                        case 2: {
                            n2 = 3;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/lang/javascript/inspections/actionscript/JSImplicitlyInternalDeclarationInspection$2";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "project";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "descriptor";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getFamilyName";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/lang/javascript/inspections/actionscript/JSImplicitlyInternalDeclarationInspection$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "applyFix";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                        case 1: 
                        case 2: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            }});
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/inspections/actionscript/JSImplicitlyInternalDeclarationInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

