/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.generation.JSChooserElementNode;
import com.intellij.lang.javascript.generation.JavaScriptImplementMethodsHandlerForFlex;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.validation.fixes.ActionScriptCreateClassOrInterfaceFix;
import com.intellij.lang.javascript.validation.fixes.CreateClassParameters;
import com.intellij.lang.javascript.validation.fixes.ImplementMethodsFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CreateJSSubclassIntention
extends PsiElementBaseIntentionAction {
    @NonNls
    private static final String IMPL_SUFFIX = "Impl";

    public CreateJSSubclassIntention() {
        this.setText(CodeInsightBundle.message((String)"intention.implement.abstract.class.subclass.text", (Object[])new Object[0]));
    }

    @NotNull
    public String getFamilyName() {
        String string = FlexBundle.message("intention.create.subclass.or.implement.interface", new Object[0]);
        if (string == null) {
            CreateJSSubclassIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        JSAttributeList attributeList;
        PsiFile psiFile;
        if (project == null) {
            CreateJSSubclassIntention.$$$reportNull$$$0(1);
        }
        if (element == null) {
            CreateJSSubclassIntention.$$$reportNull$$$0(2);
        }
        if (!((psiFile = element.getContainingFile()) instanceof JSFile) || InjectedLanguageManager.getInstance((Project)project).getInjectionHost((PsiElement)psiFile) != null || !psiFile.getLanguage().isKindOf((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4)) {
            return false;
        }
        JSClass jsClass = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)element, JSClass.class);
        if (jsClass == null || !(jsClass.getParent() instanceof JSPackageStatement)) {
            return false;
        }
        if (!jsClass.isInterface() && (attributeList = jsClass.getAttributeList()) != null && attributeList.hasModifier(JSAttributeList.ModifierType.FINAL)) {
            return false;
        }
        TextRange declarationRange = CreateJSSubclassIntention.getClassDeclarationTextRange(jsClass);
        int offset = editor.getCaretModel().getOffset();
        if (offset < declarationRange.getStartOffset() || offset > declarationRange.getEndOffset()) {
            return false;
        }
        this.setText(CreateJSSubclassIntention.getTitle(jsClass));
        return true;
    }

    private static String getTitle(JSClass jsClass) {
        return jsClass.isInterface() ? CodeInsightBundle.message((String)"intention.implement.abstract.class.interface.text", (Object[])new Object[0]) : CodeInsightBundle.message((String)"intention.implement.abstract.class.subclass.text", (Object[])new Object[0]);
    }

    public static TextRange getClassDeclarationTextRange(JSClass jsClass) {
        int start = jsClass.getTextRange().getStartOffset();
        JSAttributeList attributeList = jsClass.getAttributeList();
        if (attributeList != null) {
            PsiElement accessTypeElement = attributeList.findAccessTypeElement();
            if (accessTypeElement != null) {
                start = accessTypeElement.getTextRange().getStartOffset();
            } else {
                ASTNode classKeyWordNode;
                ASTNode node = jsClass.getNode();
                ASTNode aSTNode = classKeyWordNode = node == null ? null : node.findChildByType(JSTokenTypes.CLASS_KEYWORD);
                if (classKeyWordNode != null) {
                    start = classKeyWordNode.getTextRange().getStartOffset();
                }
            }
        }
        int end = start;
        JSReferenceList jsReferenceList = jsClass.getImplementsList();
        if (jsReferenceList == null) {
            jsReferenceList = jsClass.getExtendsList();
        }
        if (jsReferenceList != null) {
            end = jsReferenceList.getTextRange().getEndOffset();
        } else {
            PsiElement nameIdentifier = jsClass.getNameIdentifier();
            if (nameIdentifier != null) {
                end = nameIdentifier.getTextRange().getEndOffset();
            }
        }
        return new TextRange(start, end);
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        JSClass superClass;
        Map templateAttributes;
        Collection<Object> interfaces;
        PsiDirectory targetDirectory;
        String templateName;
        String packageName;
        String className;
        JSClass jsClass;
        if (project == null) {
            CreateJSSubclassIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            CreateJSSubclassIntention.$$$reportNull$$$0(4);
        }
        if ((jsClass = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)element, JSClass.class)) == null) {
            return;
        }
        PsiElement parent = jsClass.getParent();
        if (!(parent instanceof JSPackageStatement)) {
            return;
        }
        JSPackageStatement jsPackageStatement = (JSPackageStatement)parent;
        String defaultTemplateName = "ActionScript Class with Supers";
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            className = CreateJSSubclassIntention.suggestSubclassName(jsClass.getName());
            packageName = "foo";
            templateName = "ActionScript Class with Supers";
            targetDirectory = (PsiDirectory)WriteAction.compute(() -> ActionScriptCreateClassOrInterfaceFix.findOrCreateDirectory((String)packageName, (PsiElement)jsPackageStatement));
            interfaces = jsClass.isInterface() ? Collections.singletonList(jsClass.getQualifiedName()) : Collections.emptyList();
            templateAttributes = Collections.emptyMap();
            superClass = jsClass.isInterface() ? null : jsClass;
        } else {
            CreateClassParameters p = ActionScriptCreateClassOrInterfaceFix.createAndShow((String)"ActionScript Class with Supers", (PsiElement)jsClass, (String)CreateJSSubclassIntention.suggestSubclassName(jsClass.getName()), (boolean)true, (String)jsPackageStatement.getQualifiedName(), (JSClass)jsClass, (String)JSBundle.message((String)"new.actionscript.class.dialog.title", (Object[])new Object[0]), () -> {
                if (project == null) {
                    CreateJSSubclassIntention.$$$reportNull$$$0(5);
                }
                return ActionScriptCreateClassOrInterfaceFix.getApplicableTemplates((Collection)ActionScriptCreateClassOrInterfaceFix.ACTIONSCRIPT_TEMPLATES_EXTENSIONS, (Project)project);
            });
            if (p == null) {
                return;
            }
            className = p.getClassName();
            packageName = p.getPackageName();
            templateName = p.getTemplateName();
            targetDirectory = p.getTargetDirectory();
            superClass = ActionScriptCreateClassOrInterfaceFix.calcClass((String)p.getSuperclassFqn(), (PsiElement)element);
            interfaces = p.getInterfacesFqns();
            templateAttributes = new HashMap(p.getTemplateAttributes());
        }
        JSClass createdClass = ActionScriptCreateClassOrInterfaceFix.createClass((String)templateName, (String)className, (String)packageName, (JSClass)superClass, interfaces, (PsiDirectory)targetDirectory, (String)CreateJSSubclassIntention.getTitle(jsClass), (boolean)true, templateAttributes, aClass -> {
            if (!(aClass == null || aClass.isInterface() || !jsClass.isInterface() && interfaces.isEmpty())) {
                new MyImplementMethodsHandlerForFlex((JSClass)aClass).execute();
            }
        });
        if (createdClass != null) {
            createdClass.navigate(true);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static String suggestSubclassName(String name) {
        return name + IMPL_SUFFIX;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/CreateJSSubclassIntention";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/CreateJSSubclassIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invoke$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyImplementMethodsHandlerForFlex
    extends JavaScriptImplementMethodsHandlerForFlex {
        private final JSClass myClass;

        public MyImplementMethodsHandlerForFlex(JSClass aClass) {
            this.myClass = aClass;
        }

        public void execute() {
            ArrayList<JSChooserElementNode> candidates = new ArrayList<JSChooserElementNode>();
            this.collectCandidates((PsiElement)this.myClass, candidates);
            ImplementMethodsFix fix = new ImplementMethodsFix(this.myClass);
            for (JSChooserElementNode el : candidates) {
                fix.addElementToProcess((JSElement)((JSFunction)el.getPsiElement()));
            }
            fix.invoke(this.myClass.getProject(), null, this.myClass.getContainingFile());
        }
    }
}

