/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.uml;

import com.intellij.javascript.flex.FlexReferenceContributor;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.AnnotationBackedDescriptor;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSGenericSignature;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.uml.FlashUmlRelationship;
import com.intellij.lang.javascript.uml.FlashUmlVfsResolver;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssString;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FlashUmlDependencyProvider {
    private static final Language CSS = Language.findLanguageByID((String)"CSS");
    private final JSClass myClazz;

    public FlashUmlDependencyProvider(JSClass clazz) {
        this.myClazz = clazz;
    }

    public Collection<Pair<JSClass, FlashUmlRelationship>> computeUsedClasses() {
        final ArrayList<Pair<JSClass, FlashUmlRelationship>> result = new ArrayList<Pair<JSClass, FlashUmlRelationship>>();
        final JSElementVisitor visitor = new JSElementVisitor(){
            JSVariable myVariable;
            JSNewExpression myNewExpression;
            boolean myInField;
            boolean myInParameter;

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                if (PsiTreeUtil.getParentOfType((PsiElement)node, JSImportStatement.class) != null) {
                    return;
                }
                if (this.myVariable == null && this.myNewExpression == null && !this.myInParameter && FlashUmlDependencyProvider.isReturnTypeReference(node)) {
                    return;
                }
                PsiElement resolved = node.resolve();
                if (this.myNewExpression != null && resolved instanceof JSFunction && ((JSFunction)resolved).isConstructor()) {
                    resolved = JSResolveUtil.findParent((PsiElement)resolved);
                }
                if (resolved instanceof JSClass) {
                    FlashUmlRelationship relType;
                    if (node.getParent() instanceof JSReferenceExpression) {
                        relType = FlashUmlRelationship.Factory.dependency(this.myInField ? this.myVariable.getName() : null, (PsiElement)(this.myVariable != null ? this.myVariable : node));
                    } else if (this.myNewExpression != null) {
                        relType = node.getParent() instanceof JSGenericSignature ? FlashUmlRelationship.Factory.dependency(this.myInField ? this.myVariable.getName() : null, (PsiElement)(this.myVariable != null ? this.myVariable : node)) : FlashUmlRelationship.Factory.create((PsiElement)this.myNewExpression);
                    } else if (this.myInField && node.getParent() instanceof JSGenericSignature) {
                        assert (this.myVariable != null);
                        String qName = ((JSClass)resolved).getQualifiedName();
                        relType = FlashUmlVfsResolver.isVectorType(qName) ? FlashUmlRelationship.Factory.dependency(this.myVariable.getName(), (PsiElement)this.myVariable) : FlashUmlRelationship.Factory.oneToMany(this.myVariable.getName(), (PsiElement)this.myVariable);
                    } else if (this.myInField) {
                        assert (this.myVariable != null);
                        String qName = ((JSClass)resolved).getQualifiedName();
                        relType = FlashUmlVfsResolver.isVectorType(qName) ? FlashUmlRelationship.Factory.dependency(this.myVariable.getName(), (PsiElement)this.myVariable) : FlashUmlRelationship.Factory.oneToOne(this.myVariable.getName(), (PsiElement)this.myVariable);
                    } else {
                        relType = FlashUmlRelationship.Factory.dependency(null, (PsiElement)(this.myVariable != null ? this.myVariable : node));
                    }
                    result.add(Pair.create((Object)((JSClass)resolved), (Object)relType));
                }
                super.visitJSReferenceExpression(node);
            }

            public void visitJSVariable(JSVariable node) {
                if (node instanceof JSParameter) {
                    this.myInParameter = true;
                } else {
                    this.myVariable = node;
                }
                this.myInField = JSResolveUtil.findParent((PsiElement)node) instanceof JSClass;
                try {
                    super.visitJSVariable(node);
                }
                finally {
                    this.myVariable = null;
                    this.myInField = false;
                    this.myInParameter = false;
                }
            }

            public void visitJSNewExpression(JSNewExpression node) {
                this.myNewExpression = node;
                try {
                    super.visitJSNewExpression(node);
                }
                finally {
                    this.myNewExpression = null;
                }
            }

            public void visitElement(PsiElement element) {
                super.visitElement(element);
                element.acceptChildren((PsiElementVisitor)this);
            }
        };
        if (this.myClazz instanceof XmlBackedJSClassImpl) {
            ((XmlBackedJSClassImpl)this.myClazz).processInjectedFiles(jsFile -> {
                jsFile.accept((PsiElementVisitor)visitor);
                return true;
            });
            this.myClazz.getParent().acceptChildren((PsiElementVisitor)new XmlElementVisitor(){
                private String myInClassAttributeName;

                public void visitXmlTag(XmlTag tag) {
                    XmlElementDescriptor descriptor = tag.getDescriptor();
                    if (descriptor != null) {
                        PsiElement declaration = descriptor.getDeclaration();
                        if (declaration instanceof XmlFile && JavaScriptSupportLoader.isFlexMxmFile((PsiFile)((PsiFile)declaration))) {
                            declaration = XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)((XmlFile)declaration));
                        }
                        if (declaration instanceof JSClass) {
                            XmlAttribute id = tag.getAttribute("id");
                            FlashUmlRelationship type = id != null && StringUtil.isNotEmpty((String)id.getValue()) ? FlashUmlRelationship.Factory.oneToOne(id.getValue(), (PsiElement)id) : FlashUmlRelationship.Factory.dependency(null, (PsiElement)tag);
                            result.add(Pair.create((Object)((JSClass)declaration), (Object)type));
                        }
                    }
                    super.visitXmlTag(tag);
                }

                public void visitXmlAttribute(XmlAttribute attribute) {
                    XmlAttributeDescriptor descriptor = attribute.getDescriptor();
                    if (descriptor instanceof AnnotationBackedDescriptor && FlexReferenceContributor.isClassReferenceType(((AnnotationBackedDescriptor)descriptor).getType())) {
                        this.myInClassAttributeName = StringUtil.notNullize((String)attribute.getName());
                        try {
                            super.visitXmlAttribute(attribute);
                        }
                        finally {
                            this.myInClassAttributeName = null;
                        }
                    }
                }

                public void visitXmlAttributeValue(XmlAttributeValue value) {
                    if (this.myInClassAttributeName != null) {
                        FlashUmlDependencyProvider.processReferenceSet(value.getReferences(), result, FlashUmlRelationship.Factory.dependency(this.myInClassAttributeName, value.getParent()));
                    }
                }

                public void visitXmlText(XmlText text) {
                    List injectedFiles = InjectedLanguageManager.getInstance((Project)text.getProject()).getInjectedPsiFiles((PsiElement)text);
                    if (injectedFiles != null) {
                        for (Pair pair : injectedFiles) {
                            if (!CSS.is(((PsiElement)pair.first).getLanguage())) continue;
                            ((PsiElement)pair.first).accept((PsiElementVisitor)new CssElementVisitor(){
                                private boolean myInClassReference;

                                public void visitElement(PsiElement element) {
                                    super.visitElement(element);
                                    element.acceptChildren((PsiElementVisitor)this);
                                }

                                public void visitCssFunction(CssFunction _function) {
                                    if ("ClassReference".equals(_function.getName())) {
                                        this.myInClassReference = true;
                                        try {
                                            super.visitCssFunction(_function);
                                        }
                                        finally {
                                            this.myInClassReference = false;
                                        }
                                    }
                                }

                                public void visitCssString(CssString _string) {
                                    CssDeclaration declaration;
                                    if (this.myInClassReference && (declaration = (CssDeclaration)PsiTreeUtil.getParentOfType((PsiElement)_string, CssDeclaration.class)) != null) {
                                        FlashUmlDependencyProvider.processReferenceSet(_string.getReferences(), result, FlashUmlRelationship.Factory.dependency(declaration.getPropertyName(), (PsiElement)declaration));
                                    }
                                }
                            });
                        }
                    }
                    super.visitXmlText(text);
                }

                public void visitElement(PsiElement element) {
                    super.visitElement(element);
                    element.acceptChildren((PsiElementVisitor)this);
                }
            });
        }
        this.myClazz.processDeclarations(new PsiScopeProcessor(){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    3.$$$reportNull$$$0(1);
                }
                element.accept((PsiElementVisitor)visitor);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/uml/FlashUmlDependencyProvider$3";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, ResolveState.initial(), (PsiElement)this.myClazz, (PsiElement)this.myClazz);
        return result;
    }

    private static boolean isReturnTypeReference(JSReferenceExpression node) {
        PsiElement parent = JSResolveUtil.getTopReferenceParent((PsiElement)node);
        return parent instanceof JSFunction && PsiTreeUtil.isAncestor((PsiElement)((JSFunction)parent).getReturnTypeElement(), (PsiElement)node, (boolean)true);
    }

    private static void processReferenceSet(PsiReference[] references, Collection<Pair<JSClass, FlashUmlRelationship>> result, FlashUmlRelationship relType) {
        PsiElement element;
        if (references.length > 0 && (element = references[references.length - 1].resolve()) instanceof JSClass) {
            result.add((Pair<JSClass, FlashUmlRelationship>)Pair.create((Object)((JSClass)element), (Object)relType));
        }
    }
}

