/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.template.Template;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.ECMAScriptImportOptimizer;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.changeSignature.JSCallerChooser;
import com.intellij.lang.javascript.refactoring.changeSignature.JSChangeSignatureDialog;
import com.intellij.lang.javascript.refactoring.changeSignature.JSChangeSignatureProcessor;
import com.intellij.lang.javascript.refactoring.changeSignature.JSMethodDescriptor;
import com.intellij.lang.javascript.refactoring.changeSignature.JSMethodNode;
import com.intellij.lang.javascript.refactoring.changeSignature.JSParameterInfo;
import com.intellij.lang.javascript.validation.fixes.ChangeSignatureFix;
import com.intellij.lang.javascript.validation.fixes.CreateJSFunctionIntentionAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.changeSignature.CallerChooserBase;
import com.intellij.refactoring.changeSignature.MemberNodeBase;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionScriptCreateConstructorFix
extends CreateJSFunctionIntentionAction {
    @NotNull
    private final JSClass myClass;
    private final JSReferenceExpression myRefExpr;
    private final JSCallExpression myNode;

    private ActionScriptCreateConstructorFix(@NotNull JSClass clazz, JSReferenceExpression refExpr, JSCallExpression node) {
        if (clazz == null) {
            ActionScriptCreateConstructorFix.$$$reportNull$$$0(0);
        }
        super(clazz.getName(), true);
        this.myClass = clazz;
        this.myRefExpr = refExpr;
        this.myNode = node;
    }

    protected void appendFunctionBody(Template template, JSReferenceExpression refExpr, PsiFile file) {
    }

    @Nullable
    public static ActionScriptCreateConstructorFix createIfApplicable(JSCallExpression node) {
        JSReferenceExpression reference;
        JSClass clazz;
        if (node instanceof JSNewExpression) {
            JSExpression methodExpression = node.getMethodExpression();
            if (!(methodExpression instanceof JSReferenceExpression)) {
                return null;
            }
            PsiElement resolved = ((JSReferenceExpression)methodExpression).resolve();
            if (!(resolved instanceof JSClass) || resolved instanceof XmlBackedJSClass || ((JSClass)resolved).isInterface()) {
                return null;
            }
            clazz = (JSClass)resolved;
            reference = (JSReferenceExpression)methodExpression;
        } else {
            JSExpression methodExpression = node.getMethodExpression();
            if (!(methodExpression instanceof JSSuperExpression)) {
                return null;
            }
            JSClass containingClass = JSResolveUtil.getClassOfContext((PsiElement)node);
            if (containingClass == null) {
                return null;
            }
            clazz = containingClass.getSuperClasses()[0];
            if (clazz.isInterface()) {
                return null;
            }
            reference = (JSReferenceExpression)clazz.findNameIdentifier().getPsi();
        }
        return new ActionScriptCreateConstructorFix(clazz, reference, node);
    }

    @NotNull
    protected Pair<JSReferenceExpression, PsiElement> calculateAnchors(PsiElement psiElement) {
        ASTNode lbrace = this.myClass.getNode().findChildByType(JSTokenTypes.LBRACE);
        Pair pair = Pair.create((Object)this.myRefExpr, (Object)lbrace.getPsi());
        if (pair == null) {
            ActionScriptCreateConstructorFix.$$$reportNull$$$0(1);
        }
        return pair;
    }

    protected void applyFix(Project project, PsiElement psiElement, PsiFile file, Editor editor) {
        AtomicInteger count = new AtomicInteger();
        ReferencesSearch.search((PsiElement)this.myClass, (SearchScope)this.myClass.getUseScope()).forEach(psiReference -> !ActionScriptCreateConstructorFix.isClassInstantiation(psiReference) || count.incrementAndGet() < 2);
        int usages = count.get();
        if (usages < 2) {
            usages += JSInheritanceUtil.findSuperConstructorCalls((JSClass)this.myClass).size();
        }
        if (usages < 2) {
            ArrayList<String> toImport = new ArrayList<String>();
            for (JSExpression argument : this.myNode.getArguments()) {
                String type = JSResolveUtil.getQualifiedExpressionType((JSExpression)argument, (PsiFile)argument.getContainingFile());
                if (!StringUtil.isNotEmpty((String)type) || !ImportUtils.needsImport((JSQualifiedNamedElement)this.myClass, (String)StringUtil.getPackageName((String)type))) continue;
                toImport.add(type);
            }
            if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)this.myClass)) {
                return;
            }
            Editor finalEditor = ActionScriptCreateConstructorFix.getEditor((Project)this.myClass.getProject(), (PsiFile)this.myClass.getContainingFile());
            WriteAction.run(() -> {
                FormatFixer formatFixer;
                if (!toImport.isEmpty() && (formatFixer = ImportUtils.insertImportStatements((PsiElement)this.myClass, (Collection)toImport)) != null) {
                    formatFixer.fixFormat();
                }
                super.applyFix(project, psiElement, this.myClass.getContainingFile(), finalEditor);
            });
        } else {
            String text = "function " + this.myClass.getName() + "(){}";
            JSFunction fakeFunction = (JSFunction)JSChangeUtil.createStatementFromText((Project)project, (String)text, (JSLanguageDialect)JavaScriptSupportLoader.ECMA_SCRIPT_L4).getPsi();
            new ChangeSignatureFix(fakeFunction, this.myNode.getArgumentList()){

                protected Pair<Boolean, List<JSParameterInfo>> handleCall(@NotNull JSFunction function, JSExpression[] arguments, boolean dummy) {
                    if (function == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    List parameterInfos = (List)super.handleCall((JSFunction)function, (JSExpression[])arguments, (boolean)dummy).second;
                    return Pair.create((Object)true, (Object)parameterInfos);
                }

                protected JSChangeSignatureDialog createDialog(PsiElement context, final List<JSParameterInfo> paramInfos) {
                    JSMethodDescriptor descriptor = new JSMethodDescriptor((JSFunction)this.myFunction.getElement(), true){

                        public List<JSParameterInfo> getParameters() {
                            return paramInfos;
                        }
                    };
                    return new MyDialog(descriptor, context);
                }

                protected JSChangeSignatureProcessor createProcessor(List<JSParameterInfo> paramInfos, JSAttributeList attributeList, @NotNull JSFunction function) {
                    if (function == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return new MyProcessor(function, attributeList != null ? attributeList.getAccessType() : JSAttributeList.AccessType.PACKAGE_LOCAL, ActionScriptCreateConstructorFix.this.myClass.getName(), "", paramInfos.toArray(new JSParameterInfo[paramInfos.size()]), Collections.emptySet());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "function";
                    objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/ActionScriptCreateConstructorFix$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "handleCall";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "createProcessor";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }.invoke(project, editor, file);
        }
    }

    private static boolean isClassInstantiation(PsiReference psiReference) {
        return psiReference instanceof JSReferenceExpression && ((JSReferenceExpression)psiReference).getParent() instanceof JSNewExpression;
    }

    protected void buildTemplate(Template template, JSReferenceExpression referenceExpression, boolean staticContext, PsiFile file, PsiElement anchorParent) {
        if (this.constructorShouldBePublic()) {
            template.addTextSegment("public ");
        }
        this.writeFunctionAndName(template, this.myClass.getName(), file, null, referenceExpression);
        template.addTextSegment("(");
        ActionScriptCreateConstructorFix.addParameters((Template)template, (JSArgumentList)this.myNode.getArgumentList(), (PsiElement)this.myNode, (PsiFile)file);
        template.addTextSegment("){");
        this.addBody(template, referenceExpression, file);
        template.addTextSegment("}");
    }

    private boolean constructorShouldBePublic() {
        JSClass contextClass;
        return this.myClass.getAttributeList().getAccessType() == JSAttributeList.AccessType.PUBLIC || (contextClass = JSResolveUtil.getClassOfContext((PsiElement)this.myNode)) != null && JSPsiImplUtils.differentPackageName((String)JSResolveUtil.getPackageName((PsiElement)this.myClass), (String)JSResolveUtil.getPackageName((PsiElement)contextClass));
    }

    @NotNull
    public String getName() {
        String string = JSBundle.message((String)"actionscript.create.constructor.intention.name", (Object[])new Object[]{this.myClass.getName()});
        if (string == null) {
            ActionScriptCreateConstructorFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/ActionScriptCreateConstructorFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/ActionScriptCreateConstructorFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateAnchors";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyProcessor
    extends JSChangeSignatureProcessor {
        public MyProcessor(JSFunction method, JSAttributeList.AccessType visibility, String methodName, String returnType, JSParameterInfo[] parameters, Set<JSFunction> methodsToPropagateParameters) {
            super(method, visibility, methodName, returnType, parameters, methodsToPropagateParameters, Collections.emptySet());
        }

        @NotNull
        protected UsageInfo[] findUsages() {
            Collection declarations = Collections.synchronizedCollection(new com.intellij.util.containers.HashSet());
            Collection usages = Collections.synchronizedCollection(new com.intellij.util.containers.HashSet());
            ReferencesSearch.search((PsiElement)ActionScriptCreateConstructorFix.this.myClass, (SearchScope)ActionScriptCreateConstructorFix.this.myClass.getUseScope()).forEach(psiReference -> {
                if (ActionScriptCreateConstructorFix.isClassInstantiation(psiReference)) {
                    PsiElement element = psiReference.getElement();
                    usages.add(new JSChangeSignatureProcessor.OtherUsageInfo(element, null, this.myParameters, this.shouldPropagate(element), 0, 0));
                }
                return true;
            });
            for (JSCallExpression superCall : JSInheritanceUtil.findSuperConstructorCalls((JSClass)ActionScriptCreateConstructorFix.this.myClass)) {
                usages.add(new JSChangeSignatureProcessor.OtherUsageInfo((PsiElement)superCall.getMethodExpression(), null, this.myParameters, this.shouldPropagate((PsiElement)superCall), 0, 0));
            }
            this.findPropagationUsages(declarations, usages);
            ArrayList<UsageInfo> result = new ArrayList<UsageInfo>(declarations);
            result.addAll(usages);
            UsageInfo[] usageInfoArray = result.toArray(new UsageInfo[result.size()]);
            if (usageInfoArray == null) {
                MyProcessor.$$$reportNull$$$0(0);
            }
            return usageInfoArray;
        }

        protected void performRefactoring(@NotNull UsageInfo[] usageInfos) {
            if (usageInfos == null) {
                MyProcessor.$$$reportNull$$$0(1);
            }
            ArrayList<String> toImport = new ArrayList<String>();
            for (JSExpression argument : ActionScriptCreateConstructorFix.this.myNode.getArguments()) {
                String type = JSResolveUtil.getQualifiedExpressionType((JSExpression)argument, (PsiFile)argument.getContainingFile());
                if (!StringUtil.isNotEmpty((String)type) || !ImportUtils.needsImport((JSQualifiedNamedElement)ActionScriptCreateConstructorFix.this.myClass, (String)StringUtil.getPackageName((String)type))) continue;
                toImport.add(type);
            }
            StringBuilder newConstuctorText = new StringBuilder();
            if (ActionScriptCreateConstructorFix.this.constructorShouldBePublic()) {
                newConstuctorText.append("public ");
            }
            newConstuctorText.append("function ").append(ActionScriptCreateConstructorFix.this.myClass.getName());
            JSChangeSignatureDialog.buildParameterListText(Arrays.asList(this.myParameters), (StringBuilder)newConstuctorText, (boolean)true, (DialectOptionHolder)DialectDetector.dialectOfElement((PsiElement)ActionScriptCreateConstructorFix.this.myClass));
            newConstuctorText.append("{}");
            JSFunction constructorPrototype = (JSFunction)JSChangeUtil.createStatementFromText((Project)this.myProject, (String)newConstuctorText.toString(), (JSLanguageDialect)JavaScriptSupportLoader.ECMA_SCRIPT_L4).getPsi();
            PsiElement newConstuctor = ActionScriptCreateConstructorFix.this.myClass.add((PsiElement)constructorPrototype);
            FormatFixer.create((PsiElement)newConstuctor, (FormatFixer.Mode)FormatFixer.Mode.Reformat).fixFormat();
            if (!toImport.isEmpty()) {
                FormatFixer formatFixer = ImportUtils.insertImportStatements((PsiElement)ActionScriptCreateConstructorFix.this.myClass, toImport);
                if (formatFixer != null) {
                    formatFixer.fixFormat();
                }
                List fixers = ECMAScriptImportOptimizer.executeNoFormat((PsiFile)ActionScriptCreateConstructorFix.this.myClass.getContainingFile());
                FormatFixer.fixAll((List)fixers);
            }
            super.performRefactoring(usageInfos);
        }

        @NotNull
        protected String getCommandName() {
            String string = ActionScriptCreateConstructorFix.this.getName();
            if (string == null) {
                MyProcessor.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/ActionScriptCreateConstructorFix$MyProcessor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usageInfos";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findUsages";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/ActionScriptCreateConstructorFix$MyProcessor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommandName";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "performRefactoring";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyMethodNode
    extends JSMethodNode {
        public MyMethodNode(JSFunction method, com.intellij.util.containers.HashSet<JSFunction> called, Runnable cancelCallback) {
            super(method, called, ActionScriptCreateConstructorFix.this.myClass.getProject(), cancelCallback);
        }

        protected List<JSFunction> computeCallers() {
            Collection<PsiReference> refs = Collections.synchronizedCollection(new ArrayList());
            ReferencesSearch.search((PsiElement)ActionScriptCreateConstructorFix.this.myClass, (SearchScope)ActionScriptCreateConstructorFix.this.myClass.getUseScope(), (boolean)true).forEach(psiReference -> {
                if (ActionScriptCreateConstructorFix.isClassInstantiation(psiReference)) {
                    refs.add(psiReference);
                }
                return true;
            });
            HashSet result = new HashSet();
            for (PsiReference reference : refs) {
                this.addCallExpression((JSCallExpression)((JSNewExpression)reference.getElement().getParent()), result);
            }
            for (JSCallExpression superCall : JSInheritanceUtil.findSuperConstructorCalls((JSClass)ActionScriptCreateConstructorFix.this.myClass)) {
                this.addCallExpression(superCall, result);
            }
            return new ArrayList<JSFunction>(result);
        }
    }

    private class MyCallerChooser
    extends JSCallerChooser {
        public MyCallerChooser(JSFunction method, String title, Tree treeToReuse, Consumer<Set<JSFunction>> callback) {
            super(method, method.getProject(), title, treeToReuse, callback);
        }

        protected MemberNodeBase<JSFunction> createTreeNodeFor(JSFunction method, com.intellij.util.containers.HashSet<JSFunction> called, Runnable cancelCallback) {
            return new MyMethodNode(method, called, cancelCallback);
        }
    }

    private class MyDialog
    extends JSChangeSignatureDialog {
        public MyDialog(JSMethodDescriptor descriptor, PsiElement context) {
            super(descriptor, context);
            this.setTitle(JSBundle.message((String)"create.constructor.dialog.title", (Object[])new Object[0]));
        }

        protected CallerChooserBase<JSFunction> createCallerChooser(String title, Tree treeToReuse, Consumer<Set<JSFunction>> callback) {
            return new MyCallerChooser(((JSMethodDescriptor)this.myMethod).getMethod(), title, treeToReuse, callback);
        }

        protected JSChangeSignatureProcessor createRefactoringProcessor() {
            List parameters = this.getParameters();
            return new MyProcessor(((JSMethodDescriptor)this.myMethod).getMethod(), JSAttributeList.AccessType.valueOf((String)((String)this.getVisibility())), ActionScriptCreateConstructorFix.this.myClass.getName(), "", parameters.toArray(new JSParameterInfo[parameters.size()]), this.myMethodsToPropagateParameters != null ? this.myMethodsToPropagateParameters : Collections.emptySet());
        }
    }
}

