/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.BaseCreateFix;
import com.intellij.lang.javascript.validation.fixes.CreateJSFunctionIntentionActionBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;

public class CreateJSPropertyAccessorIntentionAction
extends CreateJSFunctionIntentionActionBase {
    private final boolean myIsGetter;

    public CreateJSPropertyAccessorIntentionAction(String name, boolean getter) {
        super(name, getter ? "javascript.create.get.property.intention.name" : "javascript.create.set.property.intention.name");
        this.myIsGetter = getter;
    }

    protected void writeFunctionAndName(Template template, String referencedName, PsiFile file, PsiElement clazz, JSReferenceExpression referenceExpression) {
        template.addTextSegment("function ");
        template.addTextSegment(this.myIsGetter ? "get " : "set ");
        template.addTextSegment(referencedName);
    }

    protected void addParameters(Template template, JSReferenceExpression refExpr, PsiFile file) {
        if (!this.myIsGetter) {
            template.addTextSegment(refExpr.getReferencedName() + ":");
            this.guessTypeAndAddTemplateVariable(template, (JSExpression)refExpr, file, false);
        }
    }

    protected void addReturnType(Template template, JSReferenceExpression referenceExpression, PsiFile file) {
        if (this.myIsGetter) {
            this.guessTypeAndAddTemplateVariable(template, (JSExpression)referenceExpression, file, false);
        } else {
            template.addTextSegment("void");
        }
    }

    protected void addBody(Template template, JSReferenceExpression refExpr, PsiFile file) {
        String varName;
        String paramName = varName = refExpr.getReferencedName();
        if ((varName = JSRefactoringUtil.transformAccessorNameToPropertyName((String)varName, (Project)file.getProject())).equals(paramName)) {
            varName = StringUtil.fixVariableNameDerivedFromPropertyName((String)varName);
        }
        if (this.myIsGetter) {
            template.addTextSegment("return ");
            CreateJSPropertyAccessorIntentionAction.addVarName(template, varName);
            template.addEndVariable();
        } else {
            CreateJSPropertyAccessorIntentionAction.addVarName(template, varName);
            template.addEndVariable();
            template.addTextSegment(" = " + paramName);
        }
        this.addSemicolonSegment(template, file);
    }

    protected static void addVarName(Template template, String varName) {
        BaseCreateFix.MyExpression expression = new BaseCreateFix.MyExpression(varName);
        template.addVariable("name", (Expression)expression, (Expression)expression, true);
    }
}

