/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.resources.Density;
import com.android.resources.ScreenRatio;
import com.android.resources.ScreenRound;
import com.android.resources.ScreenSize;
import com.android.resources.TouchScreen;
import com.android.sdklib.devices.Multitouch;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.ScreenType;
import com.android.tools.idea.avdmanager.AvdDeviceData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AvdScreenData {
    private AvdDeviceData myDeviceData;

    public AvdScreenData(AvdDeviceData deviceData) {
        this.myDeviceData = deviceData;
    }

    public static double calculateDpi(double screenResolutionWidth, double screenResolutionHeight, double diagonalScreenSize, boolean isRound) {
        double diagonalPixelResolution = isRound ? screenResolutionWidth : Math.sqrt(Math.pow(screenResolutionWidth, 2.0) + Math.pow(screenResolutionHeight, 2.0));
        return diagonalPixelResolution / diagonalScreenSize;
    }

    @NotNull
    public static ScreenSize getScreenSize(@Nullable Double diagonalSize) {
        if (diagonalSize == null) {
            ScreenSize screenSize = ScreenSize.NORMAL;
            if (screenSize == null) {
                AvdScreenData.$$$reportNull$$$0(0);
            }
            return screenSize;
        }
        double diagonalDp = 160.0 * diagonalSize;
        if (diagonalDp >= 1200.0) {
            ScreenSize screenSize = ScreenSize.XLARGE;
            if (screenSize == null) {
                AvdScreenData.$$$reportNull$$$0(1);
            }
            return screenSize;
        }
        if (diagonalDp >= 800.0) {
            ScreenSize screenSize = ScreenSize.LARGE;
            if (screenSize == null) {
                AvdScreenData.$$$reportNull$$$0(2);
            }
            return screenSize;
        }
        if (diagonalDp >= 568.0) {
            ScreenSize screenSize = ScreenSize.NORMAL;
            if (screenSize == null) {
                AvdScreenData.$$$reportNull$$$0(3);
            }
            return screenSize;
        }
        ScreenSize screenSize = ScreenSize.SMALL;
        if (screenSize == null) {
            AvdScreenData.$$$reportNull$$$0(4);
        }
        return screenSize;
    }

    @NotNull
    public static ScreenRatio getScreenRatio(int width, int height) {
        int shortSide;
        int longSide = Math.max(width, height);
        if ((double)longSide / (double)(shortSide = Math.min(width, height)) >= 1.6666666666666667) {
            ScreenRatio screenRatio = ScreenRatio.LONG;
            if (screenRatio == null) {
                AvdScreenData.$$$reportNull$$$0(5);
            }
            return screenRatio;
        }
        ScreenRatio screenRatio = ScreenRatio.NOTLONG;
        if (screenRatio == null) {
            AvdScreenData.$$$reportNull$$$0(6);
        }
        return screenRatio;
    }

    @NotNull
    public static Density getScreenDensity(boolean isTv, double dpi, int screenHeight) {
        Density bucket = Density.MEDIUM;
        if (isTv) {
            bucket = screenHeight <= 720 ? Density.TV : Density.XHIGH;
        } else {
            double minDifference = Double.MAX_VALUE;
            for (Density d : Density.values()) {
                double difference;
                if (!d.isValidValueForDevice() || !d.isRecommended() || !((difference = Math.abs((double)d.getDpiValue() - dpi)) < minDifference)) continue;
                minDifference = difference;
                bucket = d;
            }
        }
        Density density = bucket;
        if (density == null) {
            AvdScreenData.$$$reportNull$$$0(7);
        }
        return density;
    }

    @NotNull
    public Screen createScreen() {
        double screenDiagonal;
        Screen screen = new Screen();
        screen.setMultitouch(Multitouch.JAZZ_HANDS);
        screen.setMechanism(TouchScreen.FINGER);
        screen.setScreenType(ScreenType.CAPACITIVE);
        screen.setScreenRound((Boolean)this.myDeviceData.isScreenRound().get() != false ? ScreenRound.ROUND : ScreenRound.NOTROUND);
        int screenWidth = (Integer)this.myDeviceData.screenResolutionWidth().get();
        int screenHeight = (Integer)this.myDeviceData.screenResolutionHeight().get();
        double effectiveDiagonal = screenDiagonal = ((Double)this.myDeviceData.diagonalScreenSize().get()).doubleValue();
        if (((Boolean)this.myDeviceData.isScreenRound().get()).booleanValue()) {
            effectiveDiagonal *= Math.sqrt(2.0);
        }
        screen.setDiagonalLength(screenDiagonal);
        screen.setSize(AvdScreenData.getScreenSize(effectiveDiagonal));
        screen.setXDimension(screenWidth);
        screen.setYDimension(screenHeight);
        screen.setRatio(AvdScreenData.getScreenRatio(screenWidth, screenHeight));
        Double dpi = (Double)this.myDeviceData.screenDpi().get();
        if (dpi <= 0.0) {
            dpi = AvdScreenData.calculateDpi(screenWidth, screenHeight, screenDiagonal, (Boolean)this.myDeviceData.isScreenRound().get());
        }
        dpi = (double)Math.round(dpi * 100.0) / 100.0;
        screen.setYdpi(dpi.doubleValue());
        screen.setXdpi(dpi.doubleValue());
        screen.setPixelDensity(AvdScreenData.getScreenDensity((Boolean)this.myDeviceData.isTv().get(), dpi, screenHeight));
        Screen screen2 = screen;
        if (screen2 == null) {
            AvdScreenData.$$$reportNull$$$0(8);
        }
        return screen2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/android/tools/idea/avdmanager/AvdScreenData";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getScreenSize";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getScreenRatio";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getScreenDensity";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createScreen";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

