/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.TemporarySceneComponent;
import com.android.tools.idea.common.scene.decorator.SceneDecoratorFactory;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.ConstraintDragDndTarget;
import com.android.util.PropertiesMap;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SceneManager
implements Disposable {
    public static final boolean SUPPORTS_LOCKING = false;
    private final NlModel myModel;
    private final DesignSurface myDesignSurface;
    private Scene myScene;

    public SceneManager(NlModel model, DesignSurface surface) {
        this.myModel = model;
        this.myDesignSurface = surface;
        Disposer.register((Disposable)model, (Disposable)this);
    }

    public void dispose() {
    }

    @NotNull
    public Scene build() {
        assert (this.myScene == null);
        Scene scene = this.myScene = new Scene(this, this.myDesignSurface);
        if (scene == null) {
            SceneManager.$$$reportNull$$$0(0);
        }
        return scene;
    }

    public void update() {
        ImmutableList<NlComponent> components = this.getModel().getComponents();
        Scene scene = this.getScene();
        if (components.isEmpty()) {
            scene.removeAllComponents();
            scene.setRoot(null);
            return;
        }
        HashSet<SceneComponent> usedComponents = new HashSet<SceneComponent>();
        HashSet<SceneComponent> oldComponents = new HashSet<SceneComponent>(scene.getSceneComponents());
        NlComponent rootComponent = this.getRoot();
        if (this.myScene.getRoot() != null && rootComponent != this.myScene.getRoot().getNlComponent()) {
            scene.removeAllComponents();
            scene.setRoot(null);
        }
        SceneComponent root = this.createHierarchy(rootComponent);
        scene.setRoot(root);
        if (root != null) {
            this.updateFromComponent(root, usedComponents);
        }
        oldComponents.removeAll(usedComponents);
        oldComponents.removeIf(component2 -> component2 instanceof TemporarySceneComponent);
        oldComponents.forEach(scene::removeComponent);
        scene.needsRebuildList();
    }

    @NotNull
    protected NlComponent getRoot() {
        NlComponent nlComponent = ((NlComponent)this.getModel().getComponents().get(0)).getRoot();
        if (nlComponent == null) {
            SceneManager.$$$reportNull$$$0(1);
        }
        return nlComponent;
    }

    public static boolean isComponentLocked(@NotNull NlComponent component2) {
        if (component2 == null) {
            SceneManager.$$$reportNull$$$0(2);
        }
        return false;
    }

    @Nullable
    protected SceneComponent createHierarchy(@NotNull NlComponent component2) {
        SceneComponent sceneComponent;
        if (component2 == null) {
            SceneManager.$$$reportNull$$$0(3);
        }
        if ((sceneComponent = this.getScene().getSceneComponent(component2)) == null) {
            sceneComponent = new SceneComponent(this.getScene(), component2);
        }
        sceneComponent.setToolLocked(SceneManager.isComponentLocked(component2));
        HashSet<SceneComponent> oldChildren = new HashSet<SceneComponent>(sceneComponent.getChildren());
        for (NlComponent nlChild : component2.getChildren()) {
            SceneComponent child = this.createHierarchy(nlChild);
            oldChildren.remove(child);
            if (child == null || child.getParent() == sceneComponent) continue;
            sceneComponent.addChild(child);
        }
        for (SceneComponent child : oldChildren) {
            if (child.getParent() != sceneComponent) continue;
            child.removeFromParent();
        }
        return sceneComponent;
    }

    protected final void updateFromComponent(@NotNull SceneComponent component2, @NotNull Set<SceneComponent> seenComponents) {
        if (component2 == null) {
            SceneManager.$$$reportNull$$$0(4);
        }
        if (seenComponents == null) {
            SceneManager.$$$reportNull$$$0(5);
        }
        seenComponents.add(component2);
        this.updateFromComponent(component2);
        for (SceneComponent child : component2.getChildren()) {
            this.updateFromComponent(child, seenComponents);
        }
        this.postUpdateFromComponent(component2);
    }

    protected void postUpdateFromComponent(@NotNull SceneComponent component2) {
        if (component2 == null) {
            SceneManager.$$$reportNull$$$0(6);
        }
    }

    @NotNull
    public TemporarySceneComponent createTemporaryComponent(@NotNull NlComponent component2) {
        if (component2 == null) {
            SceneManager.$$$reportNull$$$0(7);
        }
        Scene scene = this.getScene();
        assert (scene.getRoot() != null);
        TemporarySceneComponent tempComponent = new TemporarySceneComponent(this.getScene(), component2);
        tempComponent.addTarget(new ConstraintDragDndTarget());
        scene.setAnimated(false);
        scene.getRoot().addChild(tempComponent);
        this.updateFromComponent(tempComponent);
        scene.setAnimated(true);
        TemporarySceneComponent temporarySceneComponent = tempComponent;
        if (temporarySceneComponent == null) {
            SceneManager.$$$reportNull$$$0(8);
        }
        return temporarySceneComponent;
    }

    protected void updateFromComponent(SceneComponent sceneComponent) {
        sceneComponent.setToolLocked(false);
    }

    @NotNull
    protected DesignSurface getDesignSurface() {
        DesignSurface designSurface = this.myDesignSurface;
        if (designSurface == null) {
            SceneManager.$$$reportNull$$$0(9);
        }
        return designSurface;
    }

    @NotNull
    protected NlModel getModel() {
        NlModel nlModel = this.myModel;
        if (nlModel == null) {
            SceneManager.$$$reportNull$$$0(10);
        }
        return nlModel;
    }

    @NotNull
    protected Scene getScene() {
        assert (this.myScene != null);
        Scene scene = this.myScene;
        if (scene == null) {
            SceneManager.$$$reportNull$$$0(11);
        }
        return scene;
    }

    public abstract void requestRender();

    public abstract void layout(boolean var1);

    @NotNull
    public abstract SceneDecoratorFactory getSceneDecoratorFactory();

    public abstract Map<Object, PropertiesMap> getDefaultProperties();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/scene/SceneManager";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "seenComponents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/scene/SceneManager";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemporaryComponent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDesignSurface";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getScene";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isComponentLocked";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createHierarchy";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateFromComponent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "postUpdateFromComponent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createTemporaryComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

