/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.connection.assistant.actions;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.assistant.AssistActionState;
import com.android.tools.idea.assistant.AssistActionStateManager;
import com.android.tools.idea.assistant.datamodel.ActionData;
import com.android.tools.idea.assistant.datamodel.DefaultActionState;
import com.android.tools.idea.assistant.view.StatefulButtonMessage;
import com.android.tools.idea.ddms.EdtExecutor;
import com.android.tools.idea.ddms.adb.AdbService;
import com.android.utils.HtmlBuilder;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.concurrent.Executor;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RestartAdbActionStateManager
extends AssistActionStateManager
implements AndroidDebugBridge.IDebugBridgeChangeListener {
    @Nullable
    private Project myProject;
    @Nullable
    private ListenableFuture<AndroidDebugBridge> myAdbFuture;
    private boolean myLoading;

    @NotNull
    private static String generateMessage(@NotNull IDevice[] devices) {
        if (devices == null) {
            RestartAdbActionStateManager.$$$reportNull$$$0(0);
        }
        if (devices.length == 0) {
            String string = AndroidBundle.message("connection.assistant.adb.no_devices", new Object[0]);
            if (string == null) {
                RestartAdbActionStateManager.$$$reportNull$$$0(1);
            }
            return string;
        }
        HtmlBuilder builder = new HtmlBuilder().openHtmlBody();
        builder.add(AndroidBundle.message("connection.assistant.adb.devices", new Object[0])).newline();
        for (IDevice device : devices) {
            builder.addHtml("<h2>" + device.getName() + "</h2>").newline().add(device.getVersion().toString()).newlineIfNecessary();
        }
        String string = builder.closeHtmlBody().getHtml();
        if (string == null) {
            RestartAdbActionStateManager.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public String getId() {
        if ("connection.restart.adb" == null) {
            RestartAdbActionStateManager.$$$reportNull$$$0(3);
        }
        return "connection.restart.adb";
    }

    @Override
    public void init(@NotNull Project project, @NotNull ActionData actionData) {
        if (project == null) {
            RestartAdbActionStateManager.$$$reportNull$$$0(4);
        }
        if (actionData == null) {
            RestartAdbActionStateManager.$$$reportNull$$$0(5);
        }
        this.myProject = project;
        this.initDebugBridge(this.myProject);
        AndroidDebugBridge.addDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
    }

    @Override
    @NotNull
    public AssistActionState getState(@NotNull Project project, @NotNull ActionData actionData) {
        if (project == null) {
            RestartAdbActionStateManager.$$$reportNull$$$0(6);
        }
        if (actionData == null) {
            RestartAdbActionStateManager.$$$reportNull$$$0(7);
        }
        if (this.myLoading) {
            DefaultActionState defaultActionState = DefaultActionState.IN_PROGRESS;
            if (defaultActionState == null) {
                RestartAdbActionStateManager.$$$reportNull$$$0(8);
            }
            return defaultActionState;
        }
        if (this.myAdbFuture == null) {
            DefaultActionState defaultActionState = DefaultActionState.INCOMPLETE;
            if (defaultActionState == null) {
                RestartAdbActionStateManager.$$$reportNull$$$0(9);
            }
            return defaultActionState;
        }
        if (!this.myAdbFuture.isDone()) {
            DefaultActionState defaultActionState = DefaultActionState.IN_PROGRESS;
            if (defaultActionState == null) {
                RestartAdbActionStateManager.$$$reportNull$$$0(10);
            }
            return defaultActionState;
        }
        AndroidDebugBridge adb = AndroidDebugBridge.getBridge();
        if (adb == null || adb.getDevices().length == 0) {
            DefaultActionState defaultActionState = DefaultActionState.ERROR_RETRY;
            if (defaultActionState == null) {
                RestartAdbActionStateManager.$$$reportNull$$$0(11);
            }
            return defaultActionState;
        }
        DefaultActionState defaultActionState = DefaultActionState.PARTIALLY_COMPLETE;
        if (defaultActionState == null) {
            RestartAdbActionStateManager.$$$reportNull$$$0(12);
        }
        return defaultActionState;
    }

    @Override
    @NotNull
    public StatefulButtonMessage getStateDisplay(@NotNull Project project, @NotNull ActionData actionData, @Nullable String message) {
        if (project == null) {
            RestartAdbActionStateManager.$$$reportNull$$$0(13);
        }
        if (actionData == null) {
            RestartAdbActionStateManager.$$$reportNull$$$0(14);
        }
        AssistActionState state = this.getState(project, actionData);
        if (message == null) {
            message = "";
        }
        if (state == DefaultActionState.IN_PROGRESS) {
            message = AndroidBundle.message("connection.assistant.adb.loading", new Object[0]);
        } else if (state == DefaultActionState.PARTIALLY_COMPLETE || state == DefaultActionState.ERROR_RETRY) {
            AndroidDebugBridge adb = AndroidDebugBridge.getBridge();
            message = adb != null ? RestartAdbActionStateManager.generateMessage(adb.getDevices()) : AndroidBundle.message("connection.assistant.adb.failure", new Object[0]);
        }
        StatefulButtonMessage statefulButtonMessage = new StatefulButtonMessage(message, state);
        if (statefulButtonMessage == null) {
            RestartAdbActionStateManager.$$$reportNull$$$0(15);
        }
        return statefulButtonMessage;
    }

    private void setLoading(boolean loading) {
        this.myLoading = loading;
        if (this.myProject != null) {
            this.refreshDependencyState(this.myProject);
        }
    }

    private void initDebugBridge(final @NotNull Project project) {
        File adb;
        if (project == null) {
            RestartAdbActionStateManager.$$$reportNull$$$0(16);
        }
        if ((adb = AndroidSdkUtils.getAdb(project)) == null) {
            return;
        }
        this.myAdbFuture = AdbService.getInstance().getDebugBridge(adb);
        if (this.myAdbFuture == null) {
            return;
        }
        Futures.addCallback(this.myAdbFuture, (FutureCallback)new FutureCallback<AndroidDebugBridge>(){

            public void onSuccess(@Nullable AndroidDebugBridge bridge) {
                RestartAdbActionStateManager.this.refreshDependencyState(project);
            }

            public void onFailure(@Nullable Throwable t) {
                RestartAdbActionStateManager.this.refreshDependencyState(project);
            }
        }, (Executor)EdtExecutor.INSTANCE);
    }

    public void bridgeChanged(@Nullable AndroidDebugBridge bridge) {
    }

    public void restartInitiated() {
        this.setLoading(true);
    }

    public void restartCompleted(boolean isSuccessful) {
        this.setLoading(false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "devices";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/connection/assistant/actions/RestartAdbActionStateManager";
                break;
            }
            case 4: 
            case 6: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/connection/assistant/actions/RestartAdbActionStateManager";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "generateMessage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getStateDisplay";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateMessage";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getStateDisplay";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "initDebugBridge";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

