/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.actions;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.DumpSysAction;
import com.android.tools.idea.ddms.actions.AbstractDeviceAction;
import com.android.tools.idea.run.DeviceStateCache;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import icons.AndroidIcons;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;

public class DumpSysActions {
    public static DefaultActionGroup create(@NotNull Project p, final @NotNull DeviceContext context) {
        if (p == null) {
            DumpSysActions.$$$reportNull$$$0(0);
        }
        if (context == null) {
            DumpSysActions.$$$reportNull$$$0(1);
        }
        DefaultActionGroup group = new DefaultActionGroup("System Information", true){

            public void update(AnActionEvent e) {
                e.getPresentation().setText("System Information");
                e.getPresentation().setIcon(AndroidIcons.Ddms.SysInfo);
                e.getPresentation().setEnabled(context.getSelectedDevice() != null);
            }

            public boolean isDumbAware() {
                return true;
            }
        };
        group.add((AnAction)new MyDumpSysAction(p, context, "activity", "Activity Manager State"));
        group.add((AnAction)new MyDumpSysAction(p, context, "package", "Package Information"));
        group.add((AnAction)new MyDumpSysAction(p, context, "meminfo", "Memory Usage"));
        group.add((AnAction)new MyDumpProcStatsAction(p, context, "procstats", "Memory use over time"));
        group.add((AnAction)new MyDumpSysAction(p, context, "gfxinfo", "Graphics State"));
        return group;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "p";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
        }
        objectArray[1] = "com/android/tools/idea/ddms/actions/DumpSysActions";
        objectArray[2] = "create";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyDumpProcStatsAction
    extends MyDumpSysAction {
        private static final String PKG_NAME = "";
        private final DeviceStateCache<CompletableFuture> myCache;

        public MyDumpProcStatsAction(@NotNull Project p, @NotNull DeviceContext context, @NotNull String service, @NotNull String description) {
            if (p == null) {
                MyDumpProcStatsAction.$$$reportNull$$$0(0);
            }
            if (context == null) {
                MyDumpProcStatsAction.$$$reportNull$$$0(1);
            }
            if (service == null) {
                MyDumpProcStatsAction.$$$reportNull$$$0(2);
            }
            if (description == null) {
                MyDumpProcStatsAction.$$$reportNull$$$0(3);
            }
            super(p, context, service, description);
            this.myCache = new DeviceStateCache((Disposable)p);
        }

        @Override
        protected boolean isEnabled() {
            if (!super.isEnabled()) {
                return false;
            }
            IDevice device = this.myDeviceContext.getSelectedDevice();
            CompletableFuture<Boolean> cf = this.myCache.get(device, PKG_NAME);
            if (cf == null) {
                cf = CompletableFuture.supplyAsync(() -> device.supportsFeature(IDevice.Feature.PROCSTATS));
                this.myCache.put(device, PKG_NAME, cf);
            }
            return cf.getNow(false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "p";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "service";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "description";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/ddms/actions/DumpSysActions$MyDumpProcStatsAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyDumpSysAction
    extends AbstractDeviceAction {
        private final String myService;
        private final Project myProject;

        public MyDumpSysAction(@NotNull Project p, @NotNull DeviceContext context, @NotNull String service, @NotNull String description) {
            if (p == null) {
                MyDumpSysAction.$$$reportNull$$$0(0);
            }
            if (context == null) {
                MyDumpSysAction.$$$reportNull$$$0(1);
            }
            if (service == null) {
                MyDumpSysAction.$$$reportNull$$$0(2);
            }
            if (description == null) {
                MyDumpSysAction.$$$reportNull$$$0(3);
            }
            super(context, description, null, null);
            this.myProject = p;
            this.myService = service;
        }

        @Override
        protected void performAction(@NotNull IDevice device) {
            if (device == null) {
                MyDumpSysAction.$$$reportNull$$$0(4);
            }
            new DumpSysAction(this.myProject, this.myDeviceContext.getSelectedDevice(), this.myService, this.myDeviceContext.getSelectedClient()).performAction();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "p";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "service";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "description";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "device";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/ddms/actions/DumpSysActions$MyDumpSysAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performAction";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

