/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model;

import com.android.builder.model.NativeArtifact;
import com.android.builder.model.NativeFile;
import com.android.builder.model.NativeFolder;
import com.android.builder.model.NativeSettings;
import com.android.builder.model.NativeToolchain;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.model.ModuleModel;
import com.android.tools.idea.gradle.project.model.ide.android.IdeNativeAndroidProject;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.intellij.openapi.module.Module;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NdkModuleModel
implements ModuleModel {
    private static final long serialVersionUID = 2L;
    @NotNull
    private String myModuleName;
    @NotNull
    private File myRootDirPath;
    @NotNull
    private IdeNativeAndroidProject myAndroidProject;
    @Nullable
    private transient GradleVersion myModelVersion;
    @NotNull
    private Map<String, NdkVariant> myVariantsByName;
    @NotNull
    private Map<String, NativeToolchain> myToolchainsByName;
    @NotNull
    private Map<String, NativeSettings> mySettingsByName;
    @NotNull
    private String mySelectedVariantName;

    @Nullable
    public static NdkModuleModel get(@NotNull Module module) {
        NdkFacet facet;
        if (module == null) {
            NdkModuleModel.$$$reportNull$$$0(0);
        }
        return (facet = NdkFacet.getInstance(module)) != null ? NdkModuleModel.get(facet) : null;
    }

    @Nullable
    public static NdkModuleModel get(@NotNull NdkFacet ndkFacet) {
        NdkModuleModel androidModel;
        if (ndkFacet == null) {
            NdkModuleModel.$$$reportNull$$$0(1);
        }
        if ((androidModel = ndkFacet.getNdkModuleModel()) == null) {
            return null;
        }
        return androidModel;
    }

    public NdkModuleModel(@NotNull String moduleName, @NotNull File rootDirPath, @NotNull IdeNativeAndroidProject androidProject) {
        if (moduleName == null) {
            NdkModuleModel.$$$reportNull$$$0(2);
        }
        if (rootDirPath == null) {
            NdkModuleModel.$$$reportNull$$$0(3);
        }
        if (androidProject == null) {
            NdkModuleModel.$$$reportNull$$$0(4);
        }
        this.myVariantsByName = new HashMap<String, NdkVariant>();
        this.myToolchainsByName = new HashMap<String, NativeToolchain>();
        this.mySettingsByName = new HashMap<String, NativeSettings>();
        this.myModuleName = moduleName;
        this.myRootDirPath = rootDirPath;
        this.myAndroidProject = androidProject;
        this.parseAndSetModelVersion();
        this.populateVariantsByName();
        this.populateToolchainsByName();
        this.populateSettingsByName();
        this.initializeSelectedVariant();
    }

    private void populateVariantsByName() {
        for (NativeArtifact artifact : this.myAndroidProject.getArtifacts()) {
            String variantName = this.modelVersionIsAtLeast("2.0.0") ? artifact.getGroupName() : artifact.getName();
            NdkVariant variant = this.myVariantsByName.get(variantName);
            if (variant == null) {
                variant = new NdkVariant(variantName);
                this.myVariantsByName.put(variant.getName(), variant);
            }
            variant.addArtifact(artifact);
        }
        if (this.myVariantsByName.isEmpty()) {
            this.myVariantsByName.put("-----", new NdkVariant("-----"));
        }
    }

    private void populateToolchainsByName() {
        for (NativeToolchain toolchain : this.myAndroidProject.getToolChains()) {
            this.myToolchainsByName.put(toolchain.getName(), toolchain);
        }
    }

    private void populateSettingsByName() {
        for (NativeSettings settings : this.myAndroidProject.getSettings()) {
            this.mySettingsByName.put(settings.getName(), settings);
        }
    }

    private void initializeSelectedVariant() {
        Set<String> variantNames = this.myVariantsByName.keySet();
        assert (!variantNames.isEmpty());
        if (variantNames.size() == 1) {
            this.mySelectedVariantName = (String)Iterables.getOnlyElement(variantNames);
            return;
        }
        for (String variantName : variantNames) {
            if (!variantName.equals("debug")) continue;
            this.mySelectedVariantName = variantName;
            return;
        }
        ArrayList<String> sortedVariantNames = new ArrayList<String>(variantNames);
        Collections.sort(sortedVariantNames);
        assert (!sortedVariantNames.isEmpty());
        this.mySelectedVariantName = (String)sortedVariantNames.get(0);
    }

    private void parseAndSetModelVersion() {
        this.myModelVersion = GradleVersion.tryParse((String)this.myAndroidProject.getModelVersion());
    }

    public boolean modelVersionIsAtLeast(@NotNull String revision) {
        if (revision == null) {
            NdkModuleModel.$$$reportNull$$$0(5);
        }
        return this.myModelVersion != null && this.myModelVersion.compareIgnoringQualifiers(revision) >= 0;
    }

    @Override
    @NotNull
    public String getModuleName() {
        String string = this.myModuleName;
        if (string == null) {
            NdkModuleModel.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public File getRootDirPath() {
        File file = this.myRootDirPath;
        if (file == null) {
            NdkModuleModel.$$$reportNull$$$0(7);
        }
        return file;
    }

    @NotNull
    public IdeNativeAndroidProject getAndroidProject() {
        IdeNativeAndroidProject ideNativeAndroidProject = this.myAndroidProject;
        if (ideNativeAndroidProject == null) {
            NdkModuleModel.$$$reportNull$$$0(8);
        }
        return ideNativeAndroidProject;
    }

    @NotNull
    public Collection<String> getVariantNames() {
        Set<String> set = this.myVariantsByName.keySet();
        if (set == null) {
            NdkModuleModel.$$$reportNull$$$0(9);
        }
        return set;
    }

    @NotNull
    public Collection<NdkVariant> getVariants() {
        Collection<NdkVariant> collection = this.myVariantsByName.values();
        if (collection == null) {
            NdkModuleModel.$$$reportNull$$$0(10);
        }
        return collection;
    }

    @NotNull
    public NdkVariant getSelectedVariant() {
        NdkVariant selected = this.myVariantsByName.get(this.mySelectedVariantName);
        assert (selected != null);
        NdkVariant ndkVariant = selected;
        if (ndkVariant == null) {
            NdkModuleModel.$$$reportNull$$$0(11);
        }
        return ndkVariant;
    }

    public void setSelectedVariantName(@NotNull String name) {
        Collection<String> variantNames;
        if (name == null) {
            NdkModuleModel.$$$reportNull$$$0(12);
        }
        if ((variantNames = this.getVariantNames()).contains(name)) {
            this.mySelectedVariantName = name;
        } else {
            this.initializeSelectedVariant();
        }
    }

    @Nullable
    public NativeToolchain findToolchain(@NotNull String toolchainName) {
        if (toolchainName == null) {
            NdkModuleModel.$$$reportNull$$$0(13);
        }
        return this.myToolchainsByName.get(toolchainName);
    }

    @Nullable
    public NativeSettings findSettings(@NotNull String settingsName) {
        if (settingsName == null) {
            NdkModuleModel.$$$reportNull$$$0(14);
        }
        return this.mySettingsByName.get(settingsName);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.myModuleName);
        out.writeObject(this.myRootDirPath);
        out.writeObject(this.myAndroidProject);
        out.writeObject(this.mySelectedVariantName);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.myModuleName = (String)in.readObject();
        this.myRootDirPath = (File)in.readObject();
        this.myAndroidProject = (IdeNativeAndroidProject)in.readObject();
        this.mySelectedVariantName = (String)in.readObject();
        this.parseAndSetModelVersion();
        this.myVariantsByName = new HashMap<String, NdkVariant>();
        this.myToolchainsByName = new HashMap<String, NativeToolchain>();
        this.mySettingsByName = new HashMap<String, NativeSettings>();
        this.populateVariantsByName();
        this.populateToolchainsByName();
        this.populateSettingsByName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ndkFacet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDirPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidProject";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/model/NdkModuleModel";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolchainName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/model/NdkModuleModel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootDirPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidProject";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariantNames";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedVariant";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "modelVersionIsAtLeast";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedVariantName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findToolchain";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class NdkVariant {
        @NotNull
        private final String myVariantName;
        @NotNull
        private final Map<String, NativeArtifact> myArtifactsByName;

        private NdkVariant(String variantName) {
            if (variantName == null) {
                NdkVariant.$$$reportNull$$$0(0);
            }
            this.myArtifactsByName = new HashMap<String, NativeArtifact>();
            this.myVariantName = variantName;
        }

        private void addArtifact(@NotNull NativeArtifact artifact) {
            if (artifact == null) {
                NdkVariant.$$$reportNull$$$0(1);
            }
            this.myArtifactsByName.put(artifact.getName(), artifact);
        }

        @NotNull
        public String getName() {
            String string = this.myVariantName;
            if (string == null) {
                NdkVariant.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public Collection<NativeArtifact> getArtifacts() {
            Collection<NativeArtifact> collection = this.myArtifactsByName.values();
            if (collection == null) {
                NdkVariant.$$$reportNull$$$0(3);
            }
            return collection;
        }

        @NotNull
        public Collection<File> getSourceFolders() {
            LinkedHashSet<File> sourceFolders = new LinkedHashSet<File>();
            for (NativeArtifact artifact : this.getArtifacts()) {
                if (NdkModuleModel.this.modelVersionIsAtLeast("2.0.0")) {
                    for (File headerRoot : artifact.getExportedHeaders()) {
                        sourceFolders.add(headerRoot);
                    }
                }
                for (NativeFolder sourceFolder : artifact.getSourceFolders()) {
                    sourceFolders.add(sourceFolder.getFolderPath());
                }
                for (NativeFile sourceFile : artifact.getSourceFiles()) {
                    File parentFile = sourceFile.getFilePath().getParentFile();
                    if (parentFile == null) continue;
                    sourceFolders.add(parentFile);
                }
            }
            ImmutableList immutableList = ImmutableList.copyOf(sourceFolders);
            if (immutableList == null) {
                NdkVariant.$$$reportNull$$$0(4);
            }
            return immutableList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variantName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "artifact";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/project/model/NdkModuleModel$NdkVariant";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/project/model/NdkModuleModel$NdkVariant";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArtifacts";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSourceFolders";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "addArtifact";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

