/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model;

import com.android.java.model.JavaLibrary;
import com.android.java.model.JavaProject;
import com.android.java.model.SourceSet;
import com.android.tools.idea.gradle.model.java.JarLibraryDependency;
import com.android.tools.idea.gradle.model.java.JavaModuleContentRoot;
import com.android.tools.idea.gradle.model.java.JavaModuleDependency;
import com.android.tools.idea.gradle.model.java.NewJarLibraryDependencyFactory;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.util.Pair;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.tooling.model.GradleProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.ExtIdeaCompilerOutput;
import org.jetbrains.plugins.gradle.tooling.internal.IdeaCompilerOutputImpl;

public class NewJavaModuleModelFactory {
    @NotNull
    private static final String MAIN_SOURCE_SET_NAME = "main";
    @NotNull
    private static final String TEST_SOURCE_SET_NAME = "test";
    @NotNull
    private static final String COMPILE_SCOPE = "COMPILE";
    @NotNull
    private static final String TEST_SCOPE = "TEST";
    @NotNull
    private final NewJarLibraryDependencyFactory myNewJarLibraryDependencyFactory;

    public NewJavaModuleModelFactory() {
        this(new NewJarLibraryDependencyFactory());
    }

    NewJavaModuleModelFactory(@NotNull NewJarLibraryDependencyFactory newJarLibraryDependencyFactory) {
        if (newJarLibraryDependencyFactory == null) {
            NewJavaModuleModelFactory.$$$reportNull$$$0(0);
        }
        this.myNewJarLibraryDependencyFactory = newJarLibraryDependencyFactory;
    }

    @NotNull
    public JavaModuleModel create(@NotNull GradleProject gradleProject, @NotNull JavaProject javaProject, boolean androidModuleWithoutVariants) {
        if (gradleProject == null) {
            NewJavaModuleModelFactory.$$$reportNull$$$0(1);
        }
        if (javaProject == null) {
            NewJavaModuleModelFactory.$$$reportNull$$$0(2);
        }
        Pair<Collection<JavaModuleDependency>, Collection<JarLibraryDependency>> dependencies2 = this.getDependencies(javaProject);
        JavaModuleModel javaModuleModel = new JavaModuleModel(javaProject.getName(), NewJavaModuleModelFactory.getContentRoots(javaProject, gradleProject), (Collection)dependencies2.first, (Collection)dependencies2.second, Collections.emptyMap(), NewJavaModuleModelFactory.getCompilerOutput(javaProject), gradleProject.getBuildDirectory(), javaProject.getJavaLanguageLevel(), !androidModuleWithoutVariants && JavaModuleModel.isBuildable(gradleProject), androidModuleWithoutVariants);
        if (javaModuleModel == null) {
            NewJavaModuleModelFactory.$$$reportNull$$$0(3);
        }
        return javaModuleModel;
    }

    @NotNull
    private Pair<Collection<JavaModuleDependency>, Collection<JarLibraryDependency>> getDependencies(@NotNull JavaProject javaProject) {
        if (javaProject == null) {
            NewJavaModuleModelFactory.$$$reportNull$$$0(4);
        }
        ArrayList<JavaModuleDependency> javaModuleDependencies = new ArrayList<JavaModuleDependency>();
        ArrayList<JarLibraryDependency> jarLibraryDependencies = new ArrayList<JarLibraryDependency>();
        Map<String, SourceSet> sourceSetByName = javaProject.getSourceSets().stream().collect(Collectors.toMap(SourceSet::getName, SourceSet2 -> SourceSet2));
        if (sourceSetByName.containsKey(MAIN_SOURCE_SET_NAME) && sourceSetByName.containsKey(TEST_SOURCE_SET_NAME)) {
            Collection dependenciesForMain = sourceSetByName.get(MAIN_SOURCE_SET_NAME).getCompileClasspathDependencies();
            Collection dependenciesForTest = sourceSetByName.get(TEST_SOURCE_SET_NAME).getCompileClasspathDependencies();
            ImmutableSet dependenciesForMainInSet = ImmutableSet.copyOf((Collection)dependenciesForMain);
            for (JavaLibrary library : dependenciesForMain) {
                this.createDependency(library, COMPILE_SCOPE, javaModuleDependencies, jarLibraryDependencies);
            }
            for (JavaLibrary library : dependenciesForTest) {
                if (dependenciesForMainInSet.contains((Object)library)) continue;
                this.createDependency(library, TEST_SCOPE, javaModuleDependencies, jarLibraryDependencies);
            }
        }
        Pair pair = Pair.create(javaModuleDependencies, jarLibraryDependencies);
        if (pair == null) {
            NewJavaModuleModelFactory.$$$reportNull$$$0(5);
        }
        return pair;
    }

    private void createDependency(@NotNull JavaLibrary javaLibrary, @NotNull String scope, @NotNull Collection<JavaModuleDependency> javaModuleDependencies, @NotNull Collection<JarLibraryDependency> jarLibraryDependencies) {
        if (javaLibrary == null) {
            NewJavaModuleModelFactory.$$$reportNull$$$0(6);
        }
        if (scope == null) {
            NewJavaModuleModelFactory.$$$reportNull$$$0(7);
        }
        if (javaModuleDependencies == null) {
            NewJavaModuleModelFactory.$$$reportNull$$$0(8);
        }
        if (jarLibraryDependencies == null) {
            NewJavaModuleModelFactory.$$$reportNull$$$0(9);
        }
        if (javaLibrary.getProject() != null) {
            javaModuleDependencies.add(new JavaModuleDependency(javaLibrary.getName(), scope, false));
        } else {
            JarLibraryDependency jarLibraryDependency = this.myNewJarLibraryDependencyFactory.create(javaLibrary, scope);
            if (jarLibraryDependency != null) {
                jarLibraryDependencies.add(jarLibraryDependency);
            }
        }
    }

    @NotNull
    private static ExtIdeaCompilerOutput getCompilerOutput(@NotNull JavaProject javaProject) {
        if (javaProject == null) {
            NewJavaModuleModelFactory.$$$reportNull$$$0(10);
        }
        IdeaCompilerOutputImpl compilerOutput = new IdeaCompilerOutputImpl();
        Map<String, SourceSet> sourceSetByName = javaProject.getSourceSets().stream().collect(Collectors.toMap(SourceSet::getName, SourceSet2 -> SourceSet2));
        if (sourceSetByName.containsKey(MAIN_SOURCE_SET_NAME) && sourceSetByName.containsKey(TEST_SOURCE_SET_NAME)) {
            compilerOutput.setMainClassesDir(sourceSetByName.get(MAIN_SOURCE_SET_NAME).getClassesOutputDirectory());
            compilerOutput.setMainResourcesDir(sourceSetByName.get(MAIN_SOURCE_SET_NAME).getResourcesOutputDirectory());
            compilerOutput.setTestClassesDir(sourceSetByName.get(TEST_SOURCE_SET_NAME).getClassesOutputDirectory());
            compilerOutput.setTestResourcesDir(sourceSetByName.get(TEST_SOURCE_SET_NAME).getResourcesOutputDirectory());
        }
        IdeaCompilerOutputImpl ideaCompilerOutputImpl = compilerOutput;
        if (ideaCompilerOutputImpl == null) {
            NewJavaModuleModelFactory.$$$reportNull$$$0(11);
        }
        return ideaCompilerOutputImpl;
    }

    @NotNull
    private static Collection<JavaModuleContentRoot> getContentRoots(@NotNull JavaProject javaProject, @NotNull GradleProject gradleProject) {
        if (javaProject == null) {
            NewJavaModuleModelFactory.$$$reportNull$$$0(12);
        }
        if (gradleProject == null) {
            NewJavaModuleModelFactory.$$$reportNull$$$0(13);
        }
        ArrayList<File> sourceDirPaths = new ArrayList<File>();
        ArrayList<File> resourceDirPaths = new ArrayList<File>();
        ArrayList<File> testDirPaths = new ArrayList<File>();
        ArrayList<File> testResourceDirPaths = new ArrayList<File>();
        for (SourceSet sourceSet : javaProject.getSourceSets()) {
            if (sourceSet.getName().equals(TEST_SOURCE_SET_NAME)) {
                testDirPaths.addAll(sourceSet.getSourceDirectories());
                testResourceDirPaths.addAll(sourceSet.getResourcesDirectories());
                continue;
            }
            sourceDirPaths.addAll(sourceSet.getSourceDirectories());
            resourceDirPaths.addAll(sourceSet.getResourcesDirectories());
        }
        ArrayList<File> excludeDirPaths = new ArrayList<File>();
        excludeDirPaths.add(gradleProject.getBuildDirectory());
        Set<JavaModuleContentRoot> set = Collections.singleton(new JavaModuleContentRoot(gradleProject.getProjectDirectory(), sourceDirPaths, Collections.emptyList(), resourceDirPaths, testDirPaths, Collections.emptyList(), testResourceDirPaths, excludeDirPaths));
        if (set == null) {
            NewJavaModuleModelFactory.$$$reportNull$$$0(14);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 11: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 11: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newJarLibraryDependencyFactory";
                break;
            }
            case 1: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleProject";
                break;
            }
            case 2: 
            case 4: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaProject";
                break;
            }
            case 3: 
            case 5: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/model/NewJavaModuleModelFactory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaLibrary";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaModuleDependencies";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarLibraryDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/model/NewJavaModuleModelFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilerOutput";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 3: 
            case 5: 
            case 11: 
            case 14: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createDependency";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCompilerOutput";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getContentRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 11: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

