/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.errors.BaseSyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenUrlHyperlink;
import com.android.tools.idea.gradle.util.GradleProperties;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class NdkIntegrationDeprecatedErrorHandler
extends BaseSyncErrorHandler {
    private static final String NDK_INTEGRATION_DEPRECATED = "NDK integration is deprecated in the current plugin.";

    @Override
    protected String findErrorMessage(@NotNull Throwable rootCause, @NotNull Project project) {
        String text;
        if (rootCause == null) {
            NdkIntegrationDeprecatedErrorHandler.$$$reportNull$$$0(0);
        }
        if (project == null) {
            NdkIntegrationDeprecatedErrorHandler.$$$reportNull$$$0(1);
        }
        if (StringUtil.isNotEmpty((String)(text = rootCause.getMessage())) && NdkIntegrationDeprecatedErrorHandler.getFirstLineMessage(text).contains(NDK_INTEGRATION_DEPRECATED)) {
            NdkIntegrationDeprecatedErrorHandler.updateUsageTracker();
            return NDK_INTEGRATION_DEPRECATED;
        }
        return null;
    }

    @Override
    @NotNull
    protected List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull Project project, @NotNull String text) {
        if (project == null) {
            NdkIntegrationDeprecatedErrorHandler.$$$reportNull$$$0(2);
        }
        if (text == null) {
            NdkIntegrationDeprecatedErrorHandler.$$$reportNull$$$0(3);
        }
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
        hyperlinks.add(new OpenUrlHyperlink("https://developer.android.com/studio/build/experimental-plugin.html", "Consider trying the new experimental plugin"));
        hyperlinks.add(new SetUseDeprecatedNdkHyperlink());
        ArrayList<NotificationHyperlink> arrayList = hyperlinks;
        if (arrayList == null) {
            NdkIntegrationDeprecatedErrorHandler.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootCause";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/errors/NdkIntegrationDeprecatedErrorHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/errors/NdkIntegrationDeprecatedErrorHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixHyperlinks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findErrorMessage";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixHyperlinks";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class SetUseDeprecatedNdkHyperlink
    extends NotificationHyperlink {
        public SetUseDeprecatedNdkHyperlink() {
            super("useDeprecatedNdk", "Set \"android.useDeprecatedNdk=true\" in gradle.properties to continue using the current NDK integration");
        }

        @Override
        protected void execute(@NotNull Project project) {
            GradleProperties gradleProperties;
            if (project == null) {
                SetUseDeprecatedNdkHyperlink.$$$reportNull$$$0(0);
            }
            try {
                gradleProperties = new GradleProperties(project);
            }
            catch (IOException e) {
                Messages.showErrorDialog((Project)project, (String)("Failed to read gradle.properties: " + e.getMessage()), (String)"Quick Fix");
                return;
            }
            gradleProperties.getProperties().setProperty("android.useDeprecatedNdk", "true");
            try {
                gradleProperties.save();
            }
            catch (IOException e) {
                Messages.showErrorDialog((Project)project, (String)("Failed to update gradle.properties: " + e.getMessage()), (String)"Quick Fix");
                return;
            }
            GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, GradleSyncStats.Trigger.TRIGGER_PROJECT_MODIFIED, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/errors/NdkIntegrationDeprecatedErrorHandler$SetUseDeprecatedNdkHyperlink", "execute"));
        }
    }
}

