/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressRunner;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.SelectNdkDialog;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.progress.StudioProgressRunner;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.collect.ImmutableList;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstallNdkHyperlink
extends NotificationHyperlink {
    private static final String ERROR_TITLE = "Gradle Sync Error";

    public InstallNdkHyperlink() {
        super("install.ndk", "Install NDK and sync project");
    }

    @Override
    protected void execute(@NotNull Project project) {
        File path;
        if (project == null) {
            InstallNdkHyperlink.$$$reportNull$$$0(0);
        }
        if ((path = InstallNdkHyperlink.getNdkPath(project)) != null) {
            SelectNdkDialog dialog = new SelectNdkDialog(path.getPath(), false, true);
            dialog.setModal(true);
            if (dialog.showAndGet() && InstallNdkHyperlink.setNdkPath(project, dialog.getAndroidNdkPath())) {
                GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, GradleSyncStats.Trigger.TRIGGER_PROJECT_MODIFIED, null);
            }
            return;
        }
        AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        StudioLoggerProgressIndicator progressIndicator = new StudioLoggerProgressIndicator(this.getClass());
        RepoManager sdkManager = sdkHandler.getSdkManager((ProgressIndicator)progressIndicator);
        StudioProgressRunner progressRunner = new StudioProgressRunner(false, false, "Loading Remote SDK", project);
        RepoManager.RepoLoadedCallback onComplete = packages -> {
            if (project == null) {
                InstallNdkHyperlink.$$$reportNull$$$0(6);
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                Map remotePackages;
                RemotePackage ndkPackage;
                if (project == null) {
                    InstallNdkHyperlink.$$$reportNull$$$0(7);
                }
                if ((ndkPackage = (RemotePackage)(remotePackages = packages.getRemotePackages()).get("ndk-bundle")) != null) {
                    ModelWizardDialog dialog = SdkQuickfixUtils.createDialogForPaths(project, (Collection<String>)ImmutableList.of((Object)ndkPackage.getPath()));
                    if (dialog != null && dialog.showAndGet()) {
                        GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, GradleSyncStats.Trigger.TRIGGER_PROJECT_MODIFIED, null);
                    }
                    return;
                }
                InstallNdkHyperlink.notifyNdkPackageNotFound(project);
            }, ModalityState.any());
        };
        Runnable onError = () -> {
            if (project == null) {
                InstallNdkHyperlink.$$$reportNull$$$0(4);
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (project == null) {
                    InstallNdkHyperlink.$$$reportNull$$$0(5);
                }
                InstallNdkHyperlink.notifyNdkPackageNotFound(project);
            }, ModalityState.any());
        };
        sdkManager.load(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, null, (List)ImmutableList.of((Object)onComplete), (List)ImmutableList.of((Object)onError), (ProgressRunner)progressRunner, (Downloader)new StudioDownloader(), StudioSettingsController.getInstance(), false);
    }

    @Nullable
    private static File getNdkPath(@NotNull Project project) {
        if (project == null) {
            InstallNdkHyperlink.$$$reportNull$$$0(1);
        }
        try {
            return new LocalProperties(project).getAndroidNdkPath();
        }
        catch (IOException e) {
            String msg = String.format("Unable to read local.properties file of Project '%1$s'", project.getName());
            Logger.getInstance(InstallNdkHyperlink.class).info(msg, (Throwable)e);
            return null;
        }
    }

    private static boolean setNdkPath(@NotNull Project project, @Nullable String ndkPath) {
        LocalProperties localProperties;
        if (project == null) {
            InstallNdkHyperlink.$$$reportNull$$$0(2);
        }
        try {
            localProperties = new LocalProperties(project);
        }
        catch (IOException e) {
            String msg = String.format("Unable to read local.properties file of Project '%1$s':\n%2$s", project.getName(), e.getMessage());
            Messages.showErrorDialog((Project)project, (String)msg, (String)ERROR_TITLE);
            return false;
        }
        try {
            localProperties.setAndroidNdkPath(ndkPath == null ? null : new File(ndkPath));
            localProperties.save();
        }
        catch (IOException e) {
            String msg = String.format("Unable to save local.properties file of Project '%1$s: %2$s", localProperties.getPropertiesFilePath().getPath(), e.getMessage());
            Messages.showErrorDialog((Project)project, (String)msg, (String)ERROR_TITLE);
            return false;
        }
        return true;
    }

    private static void notifyNdkPackageNotFound(@NotNull Project project) {
        if (project == null) {
            InstallNdkHyperlink.$$$reportNull$$$0(3);
        }
        Messages.showErrorDialog((Project)project, (String)"Failed to obtain NDK package", (String)ERROR_TITLE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/hyperlink/InstallNdkHyperlink";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getNdkPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setNdkPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "notifyNdkPackageNotFound";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$execute$3";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$2";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$execute$1";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

