/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.ng.SyncAction;
import com.android.tools.idea.gradle.project.sync.setup.Facets;
import com.android.tools.idea.gradle.project.sync.setup.module.AndroidModuleSetup;
import com.android.tools.idea.gradle.project.sync.setup.module.android.DependenciesAndroidModuleSetupStep;
import com.android.tools.idea.gradle.project.sync.validation.android.AndroidModuleValidator;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AndroidModuleProcessor {
    static Key<SyncAction.ModuleModels> MODULE_GRADLE_MODELS_KEY = Key.create((String)"module.gradle.models");
    @NotNull
    private final Project myProject;
    @NotNull
    private final IdeModifiableModelsProvider myModelsProvider;
    @NotNull
    private final GradleSyncState mySyncState;
    @NotNull
    private final AndroidModuleValidator.Factory myModuleValidatorFactory;
    @NotNull
    private final AndroidModuleSetup myAndroidModuleSetup;

    AndroidModuleProcessor(@NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (project == null) {
            AndroidModuleProcessor.$$$reportNull$$$0(0);
        }
        if (modelsProvider == null) {
            AndroidModuleProcessor.$$$reportNull$$$0(1);
        }
        this(project, modelsProvider, GradleSyncState.getInstance(project), new AndroidModuleValidator.Factory(), new AndroidModuleSetup(new DependenciesAndroidModuleSetupStep()));
    }

    public AndroidModuleProcessor(@NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull GradleSyncState syncState, @NotNull AndroidModuleValidator.Factory moduleValidatorFactory, @NotNull AndroidModuleSetup moduleSetup) {
        if (project == null) {
            AndroidModuleProcessor.$$$reportNull$$$0(2);
        }
        if (modelsProvider == null) {
            AndroidModuleProcessor.$$$reportNull$$$0(3);
        }
        if (syncState == null) {
            AndroidModuleProcessor.$$$reportNull$$$0(4);
        }
        if (moduleValidatorFactory == null) {
            AndroidModuleProcessor.$$$reportNull$$$0(5);
        }
        if (moduleSetup == null) {
            AndroidModuleProcessor.$$$reportNull$$$0(6);
        }
        this.myProject = project;
        this.myModelsProvider = modelsProvider;
        this.mySyncState = syncState;
        this.myModuleValidatorFactory = moduleValidatorFactory;
        this.myAndroidModuleSetup = moduleSetup;
    }

    void processAndroidModels(@NotNull List<Module> androidModules, @NotNull ProgressIndicator indicator) {
        if (androidModules == null) {
            AndroidModuleProcessor.$$$reportNull$$$0(7);
        }
        if (indicator == null) {
            AndroidModuleProcessor.$$$reportNull$$$0(8);
        }
        AndroidModuleValidator moduleValidator = this.myModuleValidatorFactory.create(this.myProject);
        for (Module module : androidModules) {
            AndroidModuleModel androidModel = this.findAndroidModel(module);
            if (androidModel == null) continue;
            SyncAction.ModuleModels moduleModels = (SyncAction.ModuleModels)module.getUserData(MODULE_GRADLE_MODELS_KEY);
            assert (moduleModels != null);
            boolean syncSkipped = this.mySyncState.isSyncSkipped();
            this.myAndroidModuleSetup.setUpModule(module, this.myModelsProvider, androidModel, moduleModels, indicator, syncSkipped);
            moduleValidator.validate(module, androidModel);
        }
        moduleValidator.fixAndReportFoundIssues();
    }

    @Nullable
    private AndroidModuleModel findAndroidModel(@NotNull Module module) {
        AndroidFacet facet;
        if (module == null) {
            AndroidModuleProcessor.$$$reportNull$$$0(9);
        }
        return (facet = Facets.findFacet(module, this.myModelsProvider, AndroidFacet.ID)) != null ? AndroidModuleModel.get(facet) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncState";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleValidatorFactory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleSetup";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModules";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/ng/AndroidModuleProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "processAndroidModels";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "findAndroidModel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

