/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.tools.idea.gradle.project.GradleExperimentalSettings;
import com.android.tools.idea.gradle.project.sync.GradleSync;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.ng.SyncExecutionCallback;
import com.android.tools.idea.gradle.project.sync.ng.SyncExecutor;
import com.android.tools.idea.gradle.project.sync.ng.SyncResultHandler;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.SystemProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewGradleSync
implements GradleSync {
    @NotNull
    private final Project myProject;
    @NotNull
    private final SyncExecutor mySyncExecutor;
    @NotNull
    private final SyncResultHandler myResultHandler;
    @NotNull
    private final SyncExecutionCallback.Factory myCallbackFactory;

    public static boolean isEnabled() {
        return NewGradleSync.isOptionVisible() && GradleExperimentalSettings.getInstance().USE_NEW_GRADLE_SYNC;
    }

    public static boolean isLevel4Model() {
        return NewGradleSync.isEnabled();
    }

    public static boolean isOptionVisible() {
        return SystemProperties.getBooleanProperty((String)"show.new.sync.preference", (boolean)false);
    }

    public NewGradleSync(@NotNull Project project) {
        if (project == null) {
            NewGradleSync.$$$reportNull$$$0(0);
        }
        this(project, new SyncExecutor(project), new SyncResultHandler(project), new SyncExecutionCallback.Factory());
    }

    @VisibleForTesting
    NewGradleSync(@NotNull Project project, @NotNull SyncExecutor syncExecutor, @NotNull SyncResultHandler resultHandler, @NotNull SyncExecutionCallback.Factory callbackFactory) {
        if (project == null) {
            NewGradleSync.$$$reportNull$$$0(1);
        }
        if (syncExecutor == null) {
            NewGradleSync.$$$reportNull$$$0(2);
        }
        if (resultHandler == null) {
            NewGradleSync.$$$reportNull$$$0(3);
        }
        if (callbackFactory == null) {
            NewGradleSync.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.mySyncExecutor = syncExecutor;
        this.myResultHandler = resultHandler;
        this.myCallbackFactory = callbackFactory;
    }

    @Override
    public void sync(@NotNull GradleSyncInvoker.Request request, @Nullable GradleSyncListener listener) {
        if (request == null) {
            NewGradleSync.$$$reportNull$$$0(5);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.sync(listener, (ProgressIndicator)new EmptyProgressIndicator(), request.isNewOrImportedProject());
            return;
        }
        Task task = this.createSyncTask(request, listener);
        ApplicationManager.getApplication().invokeLater(() -> ((Task)task).queue(), ModalityState.defaultModalityState());
    }

    @VisibleForTesting
    @NotNull
    Task createSyncTask(@NotNull GradleSyncInvoker.Request request, final @Nullable GradleSyncListener listener) {
        if (request == null) {
            NewGradleSync.$$$reportNull$$$0(6);
        }
        String title = "Gradle Sync";
        ProgressExecutionMode executionMode = request.getProgressExecutionMode();
        final boolean isNewProject = request.isNewOrImportedProject();
        switch (executionMode) {
            case MODAL_SYNC: {
                Task.Modal modal = new Task.Modal(this.myProject, title, true){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        NewGradleSync.this.sync(listener, indicator, isNewProject);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/gradle/project/sync/ng/NewGradleSync$1", "run"));
                    }
                };
                if (modal == null) {
                    NewGradleSync.$$$reportNull$$$0(7);
                }
                return modal;
            }
            case IN_BACKGROUND_ASYNC: {
                Task.Backgroundable backgroundable = new Task.Backgroundable(this.myProject, title, true){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        NewGradleSync.this.sync(listener, indicator, isNewProject);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/gradle/project/sync/ng/NewGradleSync$2", "run"));
                    }
                };
                if (backgroundable == null) {
                    NewGradleSync.$$$reportNull$$$0(8);
                }
                return backgroundable;
            }
        }
        throw new IllegalArgumentException(executionMode + " is not a supported execution mode");
    }

    private void sync(@Nullable GradleSyncListener syncListener, @NotNull ProgressIndicator indicator, boolean isNewProject) {
        if (indicator == null) {
            NewGradleSync.$$$reportNull$$$0(9);
        }
        SyncExecutionCallback callback = this.myCallbackFactory.create();
        callback.doWhenDone(() -> {
            if (indicator == null) {
                NewGradleSync.$$$reportNull$$$0(10);
            }
            this.myResultHandler.onSyncFinished(callback, indicator, syncListener, isNewProject);
        }).doWhenRejected(() -> this.myResultHandler.onSyncFailed(callback, syncListener));
        this.mySyncExecutor.syncProject(indicator, callback);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncExecutor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultHandler";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callbackFactory";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/ng/NewGradleSync";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/ng/NewGradleSync";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createSyncTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "sync";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createSyncTask";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$sync$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

