/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.dependency;

import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacetConfiguration;
import com.android.tools.idea.gradle.project.sync.setup.Facets;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.Dependency;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.LibraryDependency;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleDependency
extends Dependency {
    @NotNull
    private final String myGradlePath;
    @Nullable
    private LibraryDependency myBackupDependency;

    @VisibleForTesting
    public ModuleDependency(@NotNull String gradlePath, @NotNull DependencyScope scope) {
        if (gradlePath == null) {
            ModuleDependency.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            ModuleDependency.$$$reportNull$$$0(1);
        }
        super(scope);
        this.myGradlePath = gradlePath;
    }

    @Nullable
    public Module getModule(@NotNull IdeModifiableModelsProvider modelsProvider) {
        if (modelsProvider == null) {
            ModuleDependency.$$$reportNull$$$0(2);
        }
        for (Module module : modelsProvider.getModules()) {
            GradleFacet gradleFacet = Facets.findFacet(module, modelsProvider, GradleFacet.getFacetTypeId());
            if (gradleFacet == null || !this.hasEqualPath(gradleFacet)) continue;
            return module;
        }
        return null;
    }

    @Nullable
    public Module getModule(@NotNull Project project) {
        if (project == null) {
            ModuleDependency.$$$reportNull$$$0(3);
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            GradleFacet gradleFacet = GradleFacet.getInstance(module);
            if (gradleFacet == null || !this.hasEqualPath(gradleFacet)) continue;
            return module;
        }
        return null;
    }

    private boolean hasEqualPath(@NotNull GradleFacet facet) {
        String gradlePath;
        if (facet == null) {
            ModuleDependency.$$$reportNull$$$0(4);
        }
        return StringUtil.isNotEmpty((String)(gradlePath = ((GradleFacetConfiguration)facet.getConfiguration()).GRADLE_PROJECT_PATH)) && gradlePath.equals(this.getGradlePath());
    }

    @NotNull
    public String getGradlePath() {
        String string = this.myGradlePath;
        if (string == null) {
            ModuleDependency.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public LibraryDependency getBackupDependency() {
        return this.myBackupDependency;
    }

    @VisibleForTesting
    public void setBackupDependency(@Nullable LibraryDependency backupDependency) {
        this.myBackupDependency = backupDependency;
        this.updateBackupDependencyScope();
    }

    @Override
    void setScope(@NotNull DependencyScope scope) throws IllegalArgumentException {
        if (scope == null) {
            ModuleDependency.$$$reportNull$$$0(6);
        }
        super.setScope(scope);
        this.updateBackupDependencyScope();
    }

    private void updateBackupDependencyScope() {
        if (this.myBackupDependency != null) {
            this.myBackupDependency.setScope(this.getScope());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModuleDependency)) {
            return false;
        }
        ModuleDependency that = (ModuleDependency)o;
        return Objects.equals(this.myGradlePath, that.myGradlePath) && Objects.equals(this.myBackupDependency, that.myBackupDependency);
    }

    public int hashCode() {
        return Objects.hash(this.myGradlePath, this.myBackupDependency);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[gradlePath=" + this.myGradlePath + ", scope=" + this.getScope() + ", backUpDependency=" + this.myBackupDependency + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradlePath";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/setup/module/dependency/ModuleDependency";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/module/dependency/ModuleDependency";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradlePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getModule";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasEqualPath";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

