/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.quickfix;

import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsLibraryDependency;
import com.android.tools.idea.gradle.structure.model.PsPath;
import com.google.common.base.Joiner;
import org.jetbrains.annotations.NotNull;

public class PsLibraryDependencyVersionQuickFixPath
extends PsPath {
    @NotNull
    private final String myModuleName;
    @NotNull
    private final String myDependency;
    @NotNull
    private final String myVersion;
    @NotNull
    private String myHrefText;

    public PsLibraryDependencyVersionQuickFixPath(@NotNull PsLibraryDependency dependency) {
        if (dependency == null) {
            PsLibraryDependencyVersionQuickFixPath.$$$reportNull$$$0(0);
        }
        this.myHrefText = "[Fix]";
        this.myModuleName = dependency.getParent().getName();
        this.myDependency = PsLibraryDependencyVersionQuickFixPath.getCompactNotation(dependency);
        String version = dependency.getResolvedSpec().getVersion();
        assert (version != null);
        this.myVersion = version;
    }

    public PsLibraryDependencyVersionQuickFixPath(@NotNull PsLibraryDependency dependency, @NotNull String version) {
        if (dependency == null) {
            PsLibraryDependencyVersionQuickFixPath.$$$reportNull$$$0(1);
        }
        if (version == null) {
            PsLibraryDependencyVersionQuickFixPath.$$$reportNull$$$0(2);
        }
        this.myHrefText = "[Fix]";
        this.myModuleName = dependency.getParent().getName();
        this.myDependency = PsLibraryDependencyVersionQuickFixPath.getCompactNotation(dependency);
        this.myVersion = version;
    }

    @NotNull
    private static String getCompactNotation(@NotNull PsLibraryDependency dependency) {
        PsArtifactDependencySpec spec;
        if (dependency == null) {
            PsLibraryDependencyVersionQuickFixPath.$$$reportNull$$$0(3);
        }
        if ((spec = dependency.getDeclaredSpec()) == null) {
            spec = dependency.getResolvedSpec();
        }
        String string = spec.compactNotation();
        if (string == null) {
            PsLibraryDependencyVersionQuickFixPath.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    public String toText(@NotNull PsPath.TexType type) {
        if (type == null) {
            PsLibraryDependencyVersionQuickFixPath.$$$reportNull$$$0(5);
        }
        if (type == PsPath.TexType.HTML) {
            String string = this.getHtmlText();
            if (string == null) {
                PsLibraryDependencyVersionQuickFixPath.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = this.myDependency;
        if (string == null) {
            PsLibraryDependencyVersionQuickFixPath.$$$reportNull$$$0(7);
        }
        return string;
    }

    public void setHrefText(@NotNull String hrefText) {
        if (hrefText == null) {
            PsLibraryDependencyVersionQuickFixPath.$$$reportNull$$$0(8);
        }
        this.myHrefText = hrefText;
    }

    @NotNull
    private String getHtmlText() {
        String path = Joiner.on((char)'/').join((Object)"setLibraryDependency", (Object)this.myModuleName, new Object[]{this.myDependency, this.myVersion});
        String href = "psdFix://" + path;
        String string = String.format("<a href='%1$s'>%2$s</a>", href, this.myHrefText);
        if (string == null) {
            PsLibraryDependencyVersionQuickFixPath.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/quickfix/PsLibraryDependencyVersionQuickFixPath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hrefText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/quickfix/PsLibraryDependencyVersionQuickFixPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompactNotation";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getHtmlText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCompactNotation";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "toText";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setHrefText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

