/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lang.databinding;

import android.databinding.tool.reflection.ModelField;
import com.android.ide.common.res2.DataBindingResourceType;
import com.android.tools.idea.databinding.BrUtil;
import com.android.tools.idea.lang.databinding.DataBindingXmlReferenceContributor;
import com.android.tools.idea.lang.databinding.DbFile;
import com.android.tools.idea.lang.databinding.model.PsiModelClass;
import com.android.tools.idea.lang.databinding.model.PsiModelField;
import com.android.tools.idea.lang.databinding.model.PsiModelMethod;
import com.android.tools.idea.lang.databinding.psi.PsiDbCallExpr;
import com.android.tools.idea.lang.databinding.psi.PsiDbExpr;
import com.android.tools.idea.lang.databinding.psi.PsiDbRefExpr;
import com.android.tools.idea.res.DataBindingInfo;
import com.android.tools.idea.res.PsiDataBindingResourceItem;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class DataBindingCompletionContributor
extends CompletionContributor {
    public DataBindingCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement(), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                boolean fullCompletion;
                if (parameters == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (result == null) {
                    1.$$$reportNull$$$0(1);
                }
                PsiElement position = parameters.getOriginalPosition();
                boolean bl = fullCompletion = parameters.getInvocationCount() > 1;
                if (position == null) {
                    position = parameters.getPosition();
                }
                PsiElement parent = position.getParent();
                PsiReference[] references = parent.getReferences();
                boolean usingGrandparent = false;
                if (references.length == 0) {
                    PsiDbExpr ownerExpr;
                    PsiElement grandParent = parent.getParent();
                    if (grandParent instanceof PsiDbCallExpr) {
                        ((PsiDbCallExpr)grandParent).getRefExpr();
                    }
                    if (grandParent instanceof PsiDbRefExpr) {
                        ownerExpr = ((PsiDbRefExpr)grandParent).getExpr();
                        if (ownerExpr == null) {
                            DataBindingCompletionContributor.autoCompleteVariablesAndUnqualifiedFunctions(DataBindingCompletionContributor.this.getFile(grandParent), result);
                            return;
                        }
                    } else {
                        if (grandParent instanceof DbFile) {
                            DataBindingCompletionContributor.autoCompleteVariablesAndUnqualifiedFunctions((DbFile)grandParent, result);
                            return;
                        }
                        return;
                    }
                    parent = ownerExpr;
                    references = parent.getReferences();
                    usingGrandparent = true;
                }
                for (PsiReference reference : references) {
                    if (!(reference instanceof DataBindingXmlReferenceContributor.ResolvesToModelClass)) continue;
                    DataBindingXmlReferenceContributor.ResolvesToModelClass ref = (DataBindingXmlReferenceContributor.ResolvesToModelClass)reference;
                    boolean staticRef = ref.isStatic();
                    PsiModelClass resolvedType = ref.getResolvedType();
                    if (resolvedType == null) {
                        return;
                    }
                    for (ModelField modelField : resolvedType.getDeclaredFields()) {
                        PsiModelField psiModelField = (PsiModelField)modelField;
                        if (!fullCompletion && (!psiModelField.isPublic() || staticRef && !psiModelField.isStatic())) continue;
                        if (usingGrandparent) {
                            result.addElement((LookupElement)LookupElementBuilder.create((PsiNamedElement)psiModelField.getPsiField()));
                            continue;
                        }
                        result.addElement((LookupElement)LookupElementBuilder.create((Object)psiModelField.getPsiField(), (String)(parent.getText() + "." + psiModelField.getName())));
                    }
                    for (ModelField modelField : resolvedType.getDeclaredMethods()) {
                        PsiMethod psiMethod;
                        PsiModelMethod psiModelMethod = (PsiModelMethod)modelField;
                        if (!fullCompletion && !psiModelMethod.isPublic() || psiModelMethod.isVoid() || (psiMethod = psiModelMethod.getPsiMethod()).isConstructor() || !fullCompletion && staticRef && !psiModelMethod.isStatic()) continue;
                        String name = psiModelMethod.getName() + "()";
                        if (BrUtil.isGetter(psiMethod)) {
                            name = StringUtil.decapitalize((String)psiModelMethod.getName().substring(3));
                        } else if (BrUtil.isBooleanGetter(psiMethod)) {
                            name = StringUtil.decapitalize((String)psiModelMethod.getName().substring(2));
                        }
                        if (usingGrandparent) {
                            result.addElement((LookupElement)LookupElementBuilder.create((Object)psiMethod, (String)name));
                            continue;
                        }
                        result.addElement((LookupElement)LookupElementBuilder.create((Object)psiMethod, (String)(parent.getText() + "." + name)));
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/android/tools/idea/lang/databinding/DataBindingCompletionContributor$1";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    private DbFile getFile(PsiElement element) {
        while (!(element instanceof DbFile)) {
            PsiElement parent = element.getParent();
            if (parent == null) {
                throw new IllegalArgumentException();
            }
            element = parent;
        }
        DbFile dbFile = (DbFile)element;
        if (dbFile == null) {
            DataBindingCompletionContributor.$$$reportNull$$$0(0);
        }
        return dbFile;
    }

    private static void autoCompleteVariablesAndUnqualifiedFunctions(DbFile file, CompletionResultSet result) {
        DataBindingCompletionContributor.autoCompleteUnqualifiedFunctions(result);
        DataBindingInfo dataBindingInfo = DataBindingXmlReferenceContributor.getDataBindingInfo((PsiElement)file);
        if (dataBindingInfo == null) {
            return;
        }
        for (PsiDataBindingResourceItem resourceItem : dataBindingInfo.getItems(DataBindingResourceType.VARIABLE)) {
            result.addElement((LookupElement)LookupElementBuilder.create((Object)resourceItem.getXmlTag(), (String)resourceItem.getName()));
        }
    }

    private static void autoCompleteUnqualifiedFunctions(CompletionResultSet result) {
        LookupElementBuilder item = LookupElementBuilder.create((String)"safeUnbox");
        result.addElement((LookupElement)item);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lang/databinding/DataBindingCompletionContributor", "getFile"));
    }
}

