/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene.targets;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.ScenePicker;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawCommand;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.naveditor.scene.draw.DrawActionHandle;
import com.android.tools.idea.naveditor.scene.draw.DrawActionHandleDrag;
import com.android.tools.idea.naveditor.scene.targets.NavBaseTarget;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import java.awt.Color;
import java.awt.Cursor;
import java.util.List;
import org.jetbrains.android.dom.navigation.NavigationSchema;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionHandleTarget
extends NavBaseTarget {
    private int myCurrentRadius;
    private boolean myIsDragging;

    public ActionHandleTarget(@NotNull SceneComponent component2) {
        if (component2 == null) {
            ActionHandleTarget.$$$reportNull$$$0(0);
        }
        super(component2);
        this.myCurrentRadius = 0;
        this.myIsDragging = false;
    }

    @Override
    public int getPreferenceLevel() {
        return 70;
    }

    @Override
    public boolean layout(@NotNull SceneContext sceneTransform, int l, int t, int r, int b) {
        if (sceneTransform == null) {
            ActionHandleTarget.$$$reportNull$$$0(1);
        }
        this.layoutCircle(r, t + (b - t) / 2, 12);
        return false;
    }

    @Override
    public void mouseDown(int x, int y) {
        this.myIsDragging = true;
        this.myComponent.getScene().needsRebuildList();
        this.getComponent().setDragging(true);
    }

    @Override
    public void mouseRelease(int x, int y, @Nullable List<Target> closestTargets) {
        this.myIsDragging = false;
        this.getComponent().setDragging(false);
    }

    public void createAction(@NotNull SceneComponent destination) {
        NlComponent destinationNlComponent;
        NavigationSchema schema;
        if (destination == null) {
            ActionHandleTarget.$$$reportNull$$$0(2);
        }
        if ((schema = NavigationSchema.getOrCreateSchema((destinationNlComponent = destination.getNlComponent()).getModel().getFacet())).getDestinationType(destinationNlComponent.getTagName()) == null) {
            return;
        }
        final NlComponent myNlComponent = this.getComponent().getNlComponent();
        final NlModel myModel = myNlComponent.getModel();
        new WriteCommandAction(myModel.getProject(), "Create Action", new PsiFile[]{myModel.getFile()}){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    1.$$$reportNull$$$0(0);
                }
                XmlTag tag = myNlComponent.getTag().createChildTag("action", null, null, false);
                NlComponent newComponent = myModel.createComponent(tag, myNlComponent, null);
                NlComponentHelperKt.ensureId(newComponent);
                newComponent.setAttribute("http://schemas.android.com/apk/res-auto", "destination", "@id/" + destinationNlComponent.getId());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/naveditor/scene/targets/ActionHandleTarget$1", "run"));
            }
        }.execute();
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        if (list == null) {
            ActionHandleTarget.$$$reportNull$$$0(3);
        }
        if (sceneContext == null) {
            ActionHandleTarget.$$$reportNull$$$0(4);
        }
        DrawCommand drawCommand = this.myIsDragging ? this.createDrawActionHandleDrag(sceneContext) : this.createDrawActionHandle(sceneContext);
        list.add(drawCommand);
    }

    private DrawCommand createDrawActionHandleDrag(@NotNull SceneContext sceneContext) {
        if (sceneContext == null) {
            ActionHandleTarget.$$$reportNull$$$0(5);
        }
        return new DrawActionHandleDrag(this.getSwingCenterX(sceneContext), this.getSwingCenterY(sceneContext), sceneContext.getColorSet().getSelectedFrames());
    }

    private DrawCommand createDrawActionHandle(@NotNull SceneContext sceneContext) {
        if (sceneContext == null) {
            ActionHandleTarget.$$$reportNull$$$0(6);
        }
        int newRadius = 0;
        if (this.mIsOver) {
            newRadius = 12;
        } else if (this.getComponent().getDrawState() == SceneComponent.DrawState.HOVER || this.getComponent().isSelected()) {
            newRadius = 8;
        }
        Color fillColor = sceneContext.getColorSet().getBackground();
        DrawActionHandle drawCommand = new DrawActionHandle(this.getSwingCenterX(sceneContext), this.getSwingCenterY(sceneContext), this.myCurrentRadius, newRadius, this.getFrameColor(sceneContext), fillColor);
        this.myCurrentRadius = newRadius;
        return drawCommand;
    }

    @Override
    public void addHit(@NotNull SceneContext transform, @NotNull ScenePicker picker) {
        if (transform == null) {
            ActionHandleTarget.$$$reportNull$$$0(7);
        }
        if (picker == null) {
            ActionHandleTarget.$$$reportNull$$$0(8);
        }
        picker.addCircle(this, 0, this.getSwingCenterX(transform), this.getSwingCenterY(transform), 12);
    }

    @Override
    public Cursor getMouseCursor() {
        return Cursor.getPredefinedCursor(12);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneTransform";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneContext";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transform";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "picker";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/naveditor/scene/targets/ActionHandleTarget";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "layout";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "render";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createDrawActionHandleDrag";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createDrawActionHandle";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "addHit";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

