/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.importing;

import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.BuildFileStatement;
import com.android.tools.idea.gradle.parser.Dependency;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.android.tools.idea.gradle.parser.GradleSettingsFile;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateModuleFromArchiveAction
extends WriteCommandAction<Object> {
    @NotNull
    private Project myProject;
    @Nullable
    private GradleSettingsFile mySettingsFile;
    @NotNull
    private String myGradlePath;
    @NotNull
    private File myArchivePath;
    private boolean myMove;
    @Nullable
    private Module myContainingModule;

    public CreateModuleFromArchiveAction(@NotNull Project project, @NotNull String gradlePath, @NotNull String archivePath, boolean move, @Nullable Module containingModule) {
        if (project == null) {
            CreateModuleFromArchiveAction.$$$reportNull$$$0(0);
        }
        if (gradlePath == null) {
            CreateModuleFromArchiveAction.$$$reportNull$$$0(1);
        }
        if (archivePath == null) {
            CreateModuleFromArchiveAction.$$$reportNull$$$0(2);
        }
        this(project, GradleSettingsFile.get(project), gradlePath, archivePath, move, containingModule);
    }

    private CreateModuleFromArchiveAction(@NotNull Project project, @Nullable GradleSettingsFile settingsFile, @NotNull String gradlePath, @NotNull String archivePath, boolean move, @Nullable Module containingModule) {
        if (project == null) {
            CreateModuleFromArchiveAction.$$$reportNull$$$0(3);
        }
        if (gradlePath == null) {
            CreateModuleFromArchiveAction.$$$reportNull$$$0(4);
        }
        if (archivePath == null) {
            CreateModuleFromArchiveAction.$$$reportNull$$$0(5);
        }
        super(project, String.format("create module %1$s", gradlePath), new PsiFile[]{settingsFile != null ? settingsFile.getPsiFile() : null});
        this.myProject = project;
        this.mySettingsFile = settingsFile;
        this.myGradlePath = gradlePath;
        this.myArchivePath = new File(archivePath);
        this.myMove = move;
        this.myContainingModule = containingModule;
    }

    protected static String getBuildGradleText(File jarName) {
        return String.format("configurations.maybeCreate(\"default\")\nartifacts.add(\"default\", file('%1$s'))", jarName.getName());
    }

    private void addDependency(@NotNull Module module, String gradlePath) throws IOException {
        GradleBuildFile buildFile;
        if (module == null) {
            CreateModuleFromArchiveAction.$$$reportNull$$$0(6);
        }
        if ((buildFile = GradleBuildFile.get(module)) == null) {
            throw new IOException("Missing build.gradle");
        }
        List<BuildFileStatement> dependencies2 = buildFile.getDependencies();
        ArrayList newDeps = Lists.newArrayListWithCapacity((int)(dependencies2.size() + 1));
        File moduleRoot = VfsUtilCore.virtualToIoFile((VirtualFile)buildFile.getFile().getParent());
        for (BuildFileStatement dependency : dependencies2) {
            Dependency newDep = this.filterDependencyStatement((Dependency)dependency, moduleRoot);
            if (newDep == null) continue;
            newDeps.add(newDep);
        }
        Dependency.Scope scope = Dependency.Scope.getDefaultScope(this.myProject);
        newDeps.add(new Dependency(scope, Dependency.Type.MODULE, gradlePath));
        buildFile.setValue(BuildFileKey.DEPENDENCIES, newDeps);
    }

    @Nullable
    private Dependency filterDependencyStatement(Dependency dependency, File moduleRoot) {
        Object rawArguments = dependency.data;
        if (dependency.type == Dependency.Type.FILES && rawArguments != null) {
            String[] stringArray;
            if (rawArguments instanceof String[]) {
                stringArray = (String[])rawArguments;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = rawArguments.toString();
            }
            String[] data = stringArray;
            ArrayList list = Lists.newArrayListWithCapacity((int)data.length);
            for (String jarFile : data) {
                File path = new File(jarFile);
                if (!path.isAbsolute()) {
                    path = new File(moduleRoot, jarFile);
                }
                if (FileUtil.filesEqual((File)path, (File)this.myArchivePath)) continue;
                list.add(jarFile);
            }
            if (list.isEmpty()) {
                return null;
            }
            if (list.size() == 1) {
                return new Dependency(dependency.scope, dependency.type, list.get(0));
            }
            return new Dependency(dependency.scope, dependency.type, Iterables.toArray((Iterable)list, String.class));
        }
        return dependency;
    }

    protected void run(@NotNull Result<Object> result) throws Throwable {
        if (result == null) {
            CreateModuleFromArchiveAction.$$$reportNull$$$0(7);
        }
        File moduleLocation = GradleUtil.getModuleDefaultPath(this.myProject.getBaseDir(), this.myGradlePath);
        try {
            VirtualFile moduleRoot = VfsUtil.createDirectoryIfMissing((String)moduleLocation.getAbsolutePath());
            VirtualFile sourceFile = VfsUtil.findFileByIoFile((File)this.myArchivePath, (boolean)true);
            if (sourceFile != null && moduleRoot != null) {
                if (this.myMove) {
                    sourceFile.move((Object)this, moduleRoot);
                } else {
                    VfsUtil.copy((Object)((Object)this), (VirtualFile)sourceFile, (VirtualFile)moduleRoot);
                }
                VirtualFile buildGradle = moduleRoot.createChildData((Object)this, "build.gradle");
                VfsUtil.saveText((VirtualFile)buildGradle, (String)CreateModuleFromArchiveAction.getBuildGradleText(this.myArchivePath));
                if (this.mySettingsFile == null) {
                    this.mySettingsFile = GradleSettingsFile.getOrCreate(this.myProject);
                }
                this.mySettingsFile.addModule(this.myGradlePath, VfsUtilCore.virtualToIoFile((VirtualFile)moduleRoot));
                if (this.myMove && this.myContainingModule != null) {
                    this.addDependency(this.myContainingModule, this.myGradlePath);
                }
            }
        }
        catch (IOException e) {
            Logger.getInstance(CreateModuleFromArchiveAction.class).error((Throwable)e);
        }
    }

    protected boolean isGlobalUndoAction() {
        return true;
    }

    protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
        return UndoConfirmationPolicy.REQUEST_CONFIRMATION;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradlePath";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archivePath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/npw/importing/CreateModuleFromArchiveAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addDependency";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

