/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.perfd;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.profilers.StudioLegacyAllocationTracker;
import com.android.tools.idea.profilers.StudioLegacyCpuTraceProfiler;
import com.android.tools.idea.profilers.perfd.CpuServiceProxy;
import com.android.tools.idea.profilers.perfd.EventServiceProxy;
import com.android.tools.idea.profilers.perfd.MemoryServiceProxy;
import com.android.tools.idea.profilers.perfd.NetworkServiceProxy;
import com.android.tools.idea.profilers.perfd.PerfdProxyService;
import com.android.tools.idea.profilers.perfd.ProfilerServiceProxy;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.grpc.ManagedChannel;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.inprocess.InProcessServerBuilder;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PerfdProxy
implements AndroidDebugBridge.IDeviceChangeListener {
    @NotNull
    private static final String MEMORY_PROXY_EXECUTOR_NAME = "MemoryServiceProxy";
    @NotNull
    private Server myProxyServer;
    @NotNull
    private final List<PerfdProxyService> myProxyServices;
    @NotNull
    private IDevice myDevice;
    @Nullable
    private Runnable myOnDisconnect;

    public PerfdProxy(@NotNull IDevice device, @NotNull ManagedChannel perfdChannel, String channelName) {
        if (device == null) {
            PerfdProxy.$$$reportNull$$$0(0);
        }
        if (perfdChannel == null) {
            PerfdProxy.$$$reportNull$$$0(1);
        }
        this.myDevice = device;
        this.myProxyServices = new LinkedList<PerfdProxyService>();
        this.myProxyServices.add(new ProfilerServiceProxy(device, perfdChannel));
        this.myProxyServices.add(new EventServiceProxy(device, perfdChannel));
        this.myProxyServices.add(new CpuServiceProxy(device, perfdChannel, new StudioLegacyCpuTraceProfiler(device)));
        this.myProxyServices.add(new MemoryServiceProxy(device, perfdChannel, Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat(MEMORY_PROXY_EXECUTOR_NAME).build()), (d, p) -> new StudioLegacyAllocationTracker((IDevice)d, (int)p)));
        this.myProxyServices.add(new NetworkServiceProxy(device, perfdChannel));
        InProcessServerBuilder builder = InProcessServerBuilder.forName((String)channelName);
        this.myProxyServices.forEach(arg_0 -> PerfdProxy.lambda$new$1((ServerBuilder)builder, arg_0));
        this.myProxyServer = builder.build();
    }

    public void connect() throws IOException {
        this.myProxyServer.start();
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
    }

    public void disconnect() {
        this.myProxyServices.forEach(PerfdProxyService::disconnect);
        this.myProxyServer.shutdownNow();
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        if (this.myOnDisconnect != null) {
            this.myOnDisconnect.run();
        }
    }

    public void setOnDisconnectCallback(Runnable onDisconnect) {
        this.myOnDisconnect = onDisconnect;
    }

    public void deviceDisconnected(IDevice device) {
        if (device == this.myDevice) {
            this.disconnect();
        }
    }

    public void deviceConnected(IDevice device) {
    }

    public void deviceChanged(IDevice device, int changeMask) {
    }

    private static /* synthetic */ void lambda$new$1(ServerBuilder builder, PerfdProxyService service) {
        builder.addService(service.getServiceDefinition());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "device";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "perfdChannel";
                break;
            }
        }
        objectArray[1] = "com/android/tools/idea/profilers/perfd/PerfdProxy";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

