/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.project;

import com.android.tools.idea.apk.ApkFacet;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class AndroidProjectInfo {
    @NotNull
    private final Project myProject;

    @NotNull
    public static AndroidProjectInfo getInstance(@NotNull Project project) {
        if (project == null) {
            AndroidProjectInfo.$$$reportNull$$$0(0);
        }
        AndroidProjectInfo androidProjectInfo = (AndroidProjectInfo)ServiceManager.getService((Project)project, AndroidProjectInfo.class);
        if (androidProjectInfo == null) {
            AndroidProjectInfo.$$$reportNull$$$0(1);
        }
        return androidProjectInfo;
    }

    public AndroidProjectInfo(@NotNull Project project) {
        if (project == null) {
            AndroidProjectInfo.$$$reportNull$$$0(2);
        }
        this.myProject = project;
    }

    @NotNull
    public List<Module> getAllModulesOfProjectType(int projectType) {
        List<Module> list = Stream.of(ModuleManager.getInstance((Project)this.myProject).getModules()).filter(module -> {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            return facet != null && facet.getProjectType() == projectType;
        }).collect(Collectors.toList());
        if (list == null) {
            AndroidProjectInfo.$$$reportNull$$$0(3);
        }
        return list;
    }

    public boolean requiresAndroidModel() {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        for (Module module : moduleManager.getModules()) {
            AndroidFacet androidFacet = AndroidFacet.getInstance(module);
            if (androidFacet == null || !androidFacet.requiresAndroidModel()) continue;
            return true;
        }
        return false;
    }

    public boolean isApkProject() {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        for (Module module : moduleManager.getModules()) {
            if (ApkFacet.getInstance(module) == null) continue;
            return true;
        }
        return false;
    }

    public boolean requiredAndroidModelMissing() {
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null || !facet.requiresAndroidModel() || facet.getAndroidModel() != null) continue;
            return true;
        }
        return false;
    }

    public boolean isLegacyIdeaAndroidProject() {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        for (Module module : moduleManager.getModules()) {
            if (!AndroidProjectInfo.isLegacyIdeaAndroidModule(module)) continue;
            return true;
        }
        return false;
    }

    private static boolean isLegacyIdeaAndroidModule(@NotNull Module module) {
        AndroidFacet facet;
        if (module == null) {
            AndroidProjectInfo.$$$reportNull$$$0(4);
        }
        return (facet = AndroidFacet.getInstance(module)) != null && !facet.requiresAndroidModel();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/project/AndroidProjectInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/project/AndroidProjectInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllModulesOfProjectType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isLegacyIdeaAndroidModule";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

