/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.tools.adtui.GotItMessage;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.fd.actions.HotswapAction;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.awt.RelativePoint;
import java.awt.Component;
import java.awt.Point;
import java.lang.reflect.Field;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class InstantRunPrompt {
    private final Project myProject;

    public InstantRunPrompt(@NotNull Project project) {
        if (project == null) {
            InstantRunPrompt.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public void show() {
        ApplicationManager.getApplication().invokeLater(() -> {
            UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.INSTANT_RUN_PROMPT_FOR_APPLY_CHANGES_SHOWN));
            GotItMessage message = GotItMessage.createMessage((String)AndroidBundle.message("instant.run.prompt.title", new Object[0]), (String)AndroidBundle.message("instant.run.prompt.body", new Object[0]));
            message.setShowCallout(true);
            message.setHyperlinkListener(e -> {
                if (HyperlinkEvent.EventType.ACTIVATED == e.getEventType() && "learnmore".equals(e.getDescription())) {
                    BrowserUtil.browse((String)"http://developer.android.com/r/studio-ui/instant-run.html", (Project)this.myProject);
                }
            });
            Component applyChangesButton = this.getApplyChangesActionComponent();
            if (applyChangesButton != null) {
                message.show(new RelativePoint(applyChangesButton, new Point(applyChangesButton.getWidth() / 2, applyChangesButton.getHeight() / 2 + 10)), Balloon.Position.below);
            } else {
                message.show(RelativePoint.getSouthWestOf((JComponent)WindowManager.getInstance().getFrame(this.myProject).getRootPane()), Balloon.Position.above);
            }
        });
    }

    @VisibleForTesting
    public Component getApplyChangesActionComponent() {
        JRootPane rootPane = WindowManager.getInstance().getFrame(this.myProject).getRootPane();
        try {
            Field f = rootPane.getClass().getDeclaredField("myToolbar");
            f.setAccessible(true);
            ActionToolbar toolbar = (ActionToolbar)f.get(rootPane);
            return Arrays.stream(toolbar.getComponent().getComponents()).filter(component2 -> component2 instanceof ActionButton && ((ActionButton)component2).getAction() instanceof HotswapAction).findFirst().orElse(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Logger.getInstance((String)"InstantRunPrompt").debug("Error finding Apply Changes Button: ", (Throwable)e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/run/tasks/InstantRunPrompt", "<init>"));
    }
}

