/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.coordinator;

import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.TargetProvider;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.BaseTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.handlers.coordinator.CoordinatorLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.coordinator.CoordinatorSnapTarget;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u00020\nH\u0016J0\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\nH\u0016J\u001c\u0010\u001a\u001a\u00020\u001b2\b\b\u0001\u0010\u001c\u001a\u00020\n2\b\b\u0001\u0010\u001d\u001a\u00020\nH\u0016J,\u0010\u001e\u001a\u00020\u001b2\b\b\u0001\u0010\u001c\u001a\u00020\n2\b\b\u0001\u0010\u001d\u001a\u00020\n2\u000e\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\u0006H\u0016J,\u0010!\u001a\u00020\u001b2\b\b\u0001\u0010\u001c\u001a\u00020\n2\b\b\u0001\u0010\u001d\u001a\u00020\n2\u000e\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\u0006H\u0016J\b\u0010\"\u001a\u00020\u001bH\u0002J\u0018\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0015H\u0016J\b\u0010'\u001a\u00020\u001bH\u0002J\u0010\u0010(\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020\u0004H\u0016J\u0010\u0010*\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020,H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/android/tools/idea/uibuilder/handlers/coordinator/CoordinatorDragTarget;", "Lcom/android/tools/idea/common/scene/target/BaseTarget;", "()V", "DEBUG", "", "myAttributes", "", "", "myChangedComponent", "myFirstMouseX", "", "myFirstMouseY", "myOffsetX", "myOffsetY", "myOriginalAttributes", "Ljava/util/HashMap;", "mySnapTarget", "Lcom/android/tools/idea/uibuilder/handlers/coordinator/CoordinatorSnapTarget;", "getPreferenceLevel", "layout", "context", "Lcom/android/tools/idea/common/scene/SceneContext;", "left", "top", "right", "bottom", "mouseDown", "", "x", "y", "mouseDrag", "closestTarget", "Lcom/android/tools/idea/common/scene/target/Target;", "mouseRelease", "rememberAttributes", "render", "list", "Lcom/android/tools/idea/common/scene/draw/DisplayList;", "sceneContext", "restoreAttributes", "setComponentSelection", "selection", "updateInteractionState", "interactionState", "Lcom/android/tools/idea/uibuilder/handlers/coordinator/CoordinatorLayoutHandler$InteractionState;", "designer"})
public final class CoordinatorDragTarget
extends BaseTarget {
    private final boolean DEBUG = false;
    private int myFirstMouseX;
    private int myFirstMouseY;
    private int myOffsetX;
    private int myOffsetY;
    private boolean myChangedComponent;
    private CoordinatorSnapTarget mySnapTarget;
    private List<String> myAttributes = CollectionsKt.listOf((Object[])new String[]{"layout_anchor", "layout_anchorGravity"});
    private HashMap<String, String> myOriginalAttributes = new HashMap();

    @Override
    public int getPreferenceLevel() {
        return 20;
    }

    @Override
    public boolean layout(@NotNull SceneContext context, int left, int top, int right, int bottom) {
        int d;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        int minWidth = 16;
        int minHeight = 16;
        int l = left;
        int t = top;
        int r = right;
        int b = bottom;
        if (r - l < minWidth) {
            d = (minWidth - (r - l)) / 2;
            l -= d;
            r += d;
        }
        if (b - t < minHeight) {
            d = (minHeight - (b - t)) / 2;
            t -= d;
            b += d;
        }
        this.myLeft = l;
        this.myTop = t;
        this.myRight = r;
        this.myBottom = b;
        return false;
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        Intrinsics.checkParameterIsNotNull((Object)list, (String)"list");
        Intrinsics.checkParameterIsNotNull((Object)sceneContext, (String)"sceneContext");
        if (this.DEBUG) {
            list.addRect(sceneContext, this.myLeft, this.myTop, this.myRight, this.myBottom, this.mIsOver ? Color.yellow : Color.green);
            list.addLine(sceneContext, this.myLeft, this.myTop, this.myRight, this.myBottom, Color.red);
            list.addLine(sceneContext, this.myLeft, this.myBottom, this.myRight, this.myTop, Color.red);
        }
    }

    private final void rememberAttributes() {
        this.myOriginalAttributes.clear();
        for (String attribute : this.myAttributes) {
            String value = this.myComponent.getNlComponent().getLiveAttribute("http://schemas.android.com/apk/res-auto", attribute);
            if (value == null) continue;
            this.myOriginalAttributes.put(attribute, value);
        }
    }

    private final void restoreAttributes() {
        AttributesTransaction transaction = this.myComponent.getNlComponent().startAttributeTransaction();
        for (String attribute : this.myAttributes) {
            String value = this.myOriginalAttributes.get(attribute);
            transaction.setAttribute("http://schemas.android.com/apk/res-auto", attribute, value);
        }
        transaction.apply();
    }

    private final void updateInteractionState(CoordinatorLayoutHandler.InteractionState interactionState) {
        block1: {
            TargetProvider provider;
            SceneComponent sceneComponent = this.myComponent.getParent();
            TargetProvider targetProvider = provider = sceneComponent != null ? sceneComponent.getTargetProvider() : null;
            if (!(provider instanceof CoordinatorLayoutHandler)) break block1;
            ((CoordinatorLayoutHandler)provider).setInteractionState(interactionState);
            SceneComponent sceneComponent2 = this.myComponent.getParent();
            if (sceneComponent2 != null) {
                sceneComponent2.updateTargets(true);
            }
        }
    }

    @Override
    public void mouseDown(int x, int y) {
        if (this.myComponent.getParent() == null) {
            return;
        }
        this.myFirstMouseX = x;
        this.myFirstMouseY = y;
        this.myOffsetX = x - this.myComponent.getDrawX(System.currentTimeMillis());
        this.myOffsetY = y - this.myComponent.getDrawY(System.currentTimeMillis());
        this.myChangedComponent = false;
        this.updateInteractionState(CoordinatorLayoutHandler.InteractionState.DRAGGING);
        this.rememberAttributes();
    }

    /*
     * WARNING - void declaration
     */
    public void mouseDrag(int x, int y, @Nullable List<? extends Target> closestTarget) {
        Target snapTarget;
        Target target;
        if (this.myComponent.getParent() == null) {
            return;
        }
        this.mySnapTarget = null;
        List<? extends Target> list = closestTarget;
        if (list != null) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)list;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                Target it = (Target)element$iv$iv;
                if (!(it instanceof CoordinatorSnapTarget)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            target = (Target)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        } else {
            target = null;
        }
        Target target2 = snapTarget = target;
        if (target2 != null) {
            target2.setOver(true);
        }
        if (snapTarget instanceof CoordinatorSnapTarget) {
            this.mySnapTarget = (CoordinatorSnapTarget)snapTarget;
        }
        this.myComponent.setDragging(true);
        this.myComponent.setPosition(x - this.myOffsetX, y - this.myOffsetY, false);
        this.myComponent.getScene().repaint();
    }

    public void mouseRelease(int x, int y, @Nullable List<? extends Target> closestTarget) {
        this.updateInteractionState(CoordinatorLayoutHandler.InteractionState.NORMAL);
        if (!this.myComponent.isDragging()) {
            return;
        }
        this.myComponent.setDragging(false);
        if (this.myComponent.getParent() == null) {
            return;
        }
        if (this.mySnapTarget == null) {
            this.restoreAttributes();
        } else {
            AttributesTransaction attributes = this.myComponent.getNlComponent().startAttributeTransaction();
            CoordinatorSnapTarget coordinatorSnapTarget = this.mySnapTarget;
            if (coordinatorSnapTarget == null) {
                Intrinsics.throwNpe();
            }
            AttributesTransaction attributesTransaction = attributes;
            Intrinsics.checkExpressionValueIsNotNull((Object)attributesTransaction, (String)"attributes");
            coordinatorSnapTarget.snap(attributesTransaction);
        }
        this.myComponent.getScene().needsLayout(2);
    }

    @Override
    public void setComponentSelection(boolean selection) {
    }
}

