/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.backgroundremove;

import com.android.tools.idea.uibuilder.mockup.backgroundremove.RemoveAlgorithms;
import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class RemoveColorComposite
implements Composite,
CompositeContext {
    private double myThreshold;
    private int[] myRemoveColor = new int[3];
    private int ox;
    private int oy;
    private boolean myIsAreaOnly;

    public void setRemoveColor(int removeColor) {
        this.myRemoveColor[0] = removeColor >> 16 & 0xFF;
        this.myRemoveColor[1] = removeColor >> 8 & 0xFF;
        this.myRemoveColor[2] = removeColor & 0xFF;
    }

    public void setThreshold(double threshold) {
        this.myThreshold = threshold < 0.0 ? -1.0 : Math.max(0.0, Math.min(1.0, threshold)) * 255.0 * 3.0;
    }

    public void setAreaOnly(boolean areaOnly) {
        this.myIsAreaOnly = areaOnly;
    }

    public void setOriginPixel(int x, int y) {
        this.ox = Math.max(0, x);
        this.oy = Math.max(0, y);
    }

    @Override
    public CompositeContext createContext(ColorModel srcColorModel, ColorModel dstColorModel, RenderingHints hints) {
        return this;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void compose(Raster src, Raster dstIn, WritableRaster dstOut) {
        if (src.getSampleModel().getDataType() == 3 && dstIn.getSampleModel().getDataType() == 3 && dstOut.getSampleModel().getDataType() == 3) {
            if (this.myThreshold < 0.0) {
                dstOut.setDataElements(0, 0, src);
                return;
            }
            if (this.myIsAreaOnly) {
                RemoveAlgorithms.floodFill(src, dstIn, dstOut, this.ox, this.oy, this.myRemoveColor, this.myThreshold);
            } else {
                RemoveAlgorithms.whole(src, dstIn, dstOut, this.myRemoveColor, this.myThreshold);
            }
        }
    }
}

