/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.editor.creators;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.mockup.Mockup;
import com.android.tools.idea.uibuilder.mockup.MockupFileHelper;
import com.android.tools.idea.uibuilder.mockup.editor.creators.FloatingActionButtonCreator;
import com.android.tools.idea.uibuilder.mockup.editor.creators.viewgroupattributes.ViewGroupAttributesManager;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlTag;
import java.awt.Color;
import java.awt.Rectangle;
import java.nio.file.Path;
import java.util.Collections;
import javax.swing.JComponent;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WidgetCreator {
    private static final String COLORS_XML = "colors.xml";
    private final NlModel myModel;
    private final ScreenView myScreenView;
    @NotNull
    private Mockup myMockup;
    @Nullable
    private NlComponent myComponent;
    @Nullable
    private ViewGroupAttributesManager myViewGroupAttributesManager;

    protected WidgetCreator(@NotNull Mockup mockup, @NotNull NlModel model, @NotNull ScreenView screenView) {
        if (mockup == null) {
            WidgetCreator.$$$reportNull$$$0(0);
        }
        if (model == null) {
            WidgetCreator.$$$reportNull$$$0(1);
        }
        if (screenView == null) {
            WidgetCreator.$$$reportNull$$$0(2);
        }
        this.myMockup = mockup;
        this.myModel = model;
        this.myScreenView = screenView;
    }

    protected static void createColorResource(@NotNull String colorName, @NotNull Color color, @NotNull NlModel model) {
        if (colorName == null) {
            WidgetCreator.$$$reportNull$$$0(3);
        }
        if (color == null) {
            WidgetCreator.$$$reportNull$$$0(4);
        }
        if (model == null) {
            WidgetCreator.$$$reportNull$$$0(5);
        }
        if (colorName.isEmpty()) {
            Logger.getInstance(FloatingActionButtonCreator.class).error("The color name can't be empty. Aborting color resource creation");
            return;
        }
        VirtualFile primaryResourceDir = model.getFacet().getPrimaryResourceDir();
        FolderConfiguration configForFolder = FolderConfiguration.getConfigForFolder((String)ResourceFolderType.VALUES.getName());
        if (primaryResourceDir != null && configForFolder != null) {
            AndroidResourceUtil.createValueResource(model.getProject(), primaryResourceDir, colorName, ResourceType.COLOR, COLORS_XML, Collections.singletonList(configForFolder.getFolderName(ResourceFolderType.VALUES)), String.format("#%06X", color.getRGB()));
        }
    }

    public void setViewGroupAttributesManager(@Nullable ViewGroupAttributesManager viewGroupAttributesManager) {
        this.myViewGroupAttributesManager = viewGroupAttributesManager;
    }

    @NotNull
    protected final Mockup getMockup() {
        Mockup mockup = this.myMockup;
        if (mockup == null) {
            WidgetCreator.$$$reportNull$$$0(6);
        }
        return mockup;
    }

    protected final NlModel getModel() {
        return this.myModel;
    }

    @NotNull
    public ScreenView getScreenView() {
        ScreenView screenView = this.myScreenView;
        if (screenView == null) {
            WidgetCreator.$$$reportNull$$$0(7);
        }
        return screenView;
    }

    protected abstract void addAttributes(@NotNull AttributesTransaction var1);

    @Nullable
    public NlComponent addToModel() {
        this.ensureNewComponentCreated();
        assert (this.myComponent != null);
        AttributesTransaction transaction = this.myComponent.startAttributeTransaction();
        this.addAttributes(transaction);
        if (this.myViewGroupAttributesManager != null) {
            this.myViewGroupAttributesManager.addLayoutAttributes(transaction);
        }
        transaction.commit();
        this.myModel.addComponents(Collections.singletonList(this.myComponent), this.myMockup.getComponent(), null, InsertType.CREATE_PREVIEW);
        return this.myComponent;
    }

    public boolean hasOptionsComponent() {
        return false;
    }

    @Nullable
    public JComponent getOptionsComponent(@NotNull DoneCallback doneCallback) {
        if (doneCallback == null) {
            WidgetCreator.$$$reportNull$$$0(8);
        }
        return null;
    }

    protected void addSizeAttributes(@NotNull AttributesTransaction transaction, @NotNull Rectangle bounds) {
        if (transaction == null) {
            WidgetCreator.$$$reportNull$$$0(9);
        }
        if (bounds == null) {
            WidgetCreator.$$$reportNull$$$0(10);
        }
        transaction.setAttribute(null, "android:layout_width", String.format("%ddp", WidgetCreator.pxToDp(this.myModel, bounds.width)));
        transaction.setAttribute(null, "android:layout_height", String.format("%ddp", WidgetCreator.pxToDp(this.myModel, bounds.height)));
    }

    protected void addLayoutEditorPositionAttribute(@NotNull AttributesTransaction transaction, @NotNull Rectangle bounds) {
        if (transaction == null) {
            WidgetCreator.$$$reportNull$$$0(11);
        }
        if (bounds == null) {
            WidgetCreator.$$$reportNull$$$0(12);
        }
        transaction.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX", String.format("%ddp", WidgetCreator.pxToDp(this.myModel, bounds.x)));
        transaction.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY", String.format("%ddp", WidgetCreator.pxToDp(this.myModel, bounds.y)));
    }

    protected void addMockupAttributes(@NotNull AttributesTransaction transaction, @NotNull Rectangle bounds) {
        if (transaction == null) {
            WidgetCreator.$$$reportNull$$$0(13);
        }
        if (bounds == null) {
            WidgetCreator.$$$reportNull$$$0(14);
        }
        this.ensureNewComponentCreated();
        assert (this.myComponent != null);
        Mockup newMockup = Mockup.create(this.myComponent, true);
        if (newMockup == null) {
            return;
        }
        Rectangle cropping = this.myMockup.getComputedCropping();
        newMockup.setCropping(cropping.x + bounds.x, cropping.y + bounds.y, bounds.width, bounds.height);
        transaction.setAttribute("http://schemas.android.com/tools", "mockup_crop", MockupFileHelper.getPositionString(newMockup));
        transaction.setAttribute("http://schemas.android.com/tools", "mockup", WidgetCreator.getMockupImagePath(this.myMockup));
    }

    private void ensureNewComponentCreated() {
        if (this.myComponent == null) {
            XmlTag parentTag = this.myMockup.getComponent().getTag();
            XmlTag childTag = parentTag.createChildTag(this.getAndroidViewTag(), null, null, false);
            this.myComponent = this.myModel.createComponent(childTag);
        }
    }

    @NotNull
    private static String getMockupImagePath(@NotNull Mockup mockup) {
        Path xmlFilePath;
        if (mockup == null) {
            WidgetCreator.$$$reportNull$$$0(15);
        }
        String string = (xmlFilePath = MockupFileHelper.getXMLFilePath(mockup.getComponent().getModel().getProject(), mockup.getFilePath())) != null ? xmlFilePath.toString() : "";
        if (string == null) {
            WidgetCreator.$$$reportNull$$$0(16);
        }
        return string;
    }

    protected static int pxToDp(@NotNull NlModel model, int px) {
        if (model == null) {
            WidgetCreator.$$$reportNull$$$0(17);
        }
        float dpiValue = model.getConfiguration().getDensity().getDpiValue();
        return Math.round((float)px * (160.0f / dpiValue));
    }

    @NotNull
    public abstract String getAndroidViewTag();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mockup";
                break;
            }
            case 1: 
            case 5: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenView";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 6: 
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/mockup/editor/creators/WidgetCreator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doneCallback";
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transaction";
                break;
            }
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/mockup/editor/creators/WidgetCreator";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMockup";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getScreenView";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getMockupImagePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createColorResource";
                break;
            }
            case 6: 
            case 7: 
            case 16: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getOptionsComponent";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addSizeAttributes";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addLayoutEditorPositionAttribute";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addMockupAttributes";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getMockupImagePath";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "pxToDp";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ColorResourceHolder {
        @Nullable
        public Color value;
        @Nullable
        public String name;

        public ColorResourceHolder(@Nullable Color value, @Nullable String name) {
            this.value = value;
            this.name = name;
        }
    }

    public static interface DoneCallback {
        public static final int FINISH = 1;
        public static final int CANCEL = 0;

        public void done(int var1);
    }
}

