/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.adtui.ImageUtils;
import com.android.tools.idea.gradle.dependencies.GradleDependencyManager;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.uibuilder.palette.Palette;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class DependencyManager {
    private final Project myProject;
    private final Set<String> myMissingLibraries;
    private Module myModule;
    private Palette myPalette;

    public DependencyManager(@NotNull Project project, @NotNull JComponent paletteUI, @NotNull Disposable parentDisposable) {
        if (project == null) {
            DependencyManager.$$$reportNull$$$0(0);
        }
        if (paletteUI == null) {
            DependencyManager.$$$reportNull$$$0(1);
        }
        if (parentDisposable == null) {
            DependencyManager.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myMissingLibraries = new HashSet<String>();
        this.registerDependencyUpdates(paletteUI, parentDisposable);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            DependencyManager.$$$reportNull$$$0(3);
        }
        return project;
    }

    public void setPalette(@NotNull Palette palette, @NotNull Module module) {
        if (palette == null) {
            DependencyManager.$$$reportNull$$$0(4);
        }
        if (module == null) {
            DependencyManager.$$$reportNull$$$0(5);
        }
        this.myPalette = palette;
        this.myModule = module;
        this.checkForNewMissingDependencies();
    }

    public boolean needsLibraryLoad(@NotNull Palette.Item item) {
        if (item == null) {
            DependencyManager.$$$reportNull$$$0(6);
        }
        return this.myMissingLibraries.contains(item.getGradleCoordinateId());
    }

    @NotNull
    public Icon createItemIcon(@NotNull Palette.Item item, @NotNull Component componentContext) {
        if (item == null) {
            DependencyManager.$$$reportNull$$$0(7);
        }
        if (componentContext == null) {
            DependencyManager.$$$reportNull$$$0(8);
        }
        Icon icon = this.createItemIcon(item, item.getIcon(), AndroidIcons.Views.DownloadOverlay, componentContext);
        if (icon == null) {
            DependencyManager.$$$reportNull$$$0(9);
        }
        return icon;
    }

    @NotNull
    public Icon createLargeItemIcon(@NotNull Palette.Item item, @NotNull Component componentContext) {
        if (item == null) {
            DependencyManager.$$$reportNull$$$0(10);
        }
        if (componentContext == null) {
            DependencyManager.$$$reportNull$$$0(11);
        }
        Icon icon = this.createItemIcon(item, item.getLargeIcon(), AndroidIcons.Views.DownloadOverlayLarge, componentContext);
        if (icon == null) {
            DependencyManager.$$$reportNull$$$0(12);
        }
        return icon;
    }

    @NotNull
    private Icon createItemIcon(@NotNull Palette.Item item, @NotNull Icon icon, @NotNull Icon downloadIcon, @NotNull Component componentContext) {
        if (item == null) {
            DependencyManager.$$$reportNull$$$0(13);
        }
        if (icon == null) {
            DependencyManager.$$$reportNull$$$0(14);
        }
        if (downloadIcon == null) {
            DependencyManager.$$$reportNull$$$0(15);
        }
        if (componentContext == null) {
            DependencyManager.$$$reportNull$$$0(16);
        }
        if (!this.needsLibraryLoad(item)) {
            Icon icon2 = icon;
            if (icon2 == null) {
                DependencyManager.$$$reportNull$$$0(17);
            }
            return icon2;
        }
        int width = icon.getIconWidth();
        int height = icon.getIconHeight();
        int offset = JBUI.scale((int)1);
        Polygon triangle = new Polygon();
        triangle.addPoint(width / 3, height);
        triangle.addPoint(width, height);
        triangle.addPoint(width, height / 3);
        BufferedImage image = UIUtil.createImage((int)(width + offset), (int)(height + offset), (int)2);
        Area clip = new Area(new Rectangle(0, 0, width, height));
        clip.subtract(new Area(triangle));
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        g2.setClip(clip);
        icon.paintIcon(componentContext, g2, 0, 0);
        g2.setClip(null);
        downloadIcon.paintIcon(componentContext, g2, offset, offset);
        g2.dispose();
        JBImageIcon jBImageIcon = new JBImageIcon((Image)(UIUtil.isRetina() ? ImageUtils.convertToRetinaIgnoringFailures((BufferedImage)image) : image));
        if (jBImageIcon == null) {
            DependencyManager.$$$reportNull$$$0(18);
        }
        return jBImageIcon;
    }

    private boolean checkForNewMissingDependencies() {
        List<GradleCoordinate> coordinates;
        GradleDependencyManager manager;
        Set<Object> missing = Collections.emptySet();
        if (this.myModule != null && !this.myModule.isDisposed() && this.myMissingLibraries.equals(missing = DependencyManager.fromGradleCoordinatesToIds((manager = GradleDependencyManager.getInstance(this.myProject)).findMissingDependencies(this.myModule, coordinates = DependencyManager.toGradleCoordinatesFromIds(this.myPalette.getGradleCoordinateIds()))))) {
            return false;
        }
        this.myMissingLibraries.clear();
        this.myMissingLibraries.addAll(missing);
        return true;
    }

    private void registerDependencyUpdates(final @NotNull JComponent paletteUI, @NotNull Disposable parentDisposable) {
        if (paletteUI == null) {
            DependencyManager.$$$reportNull$$$0(19);
        }
        if (parentDisposable == null) {
            DependencyManager.$$$reportNull$$$0(20);
        }
        GradleSyncState.subscribe(this.myProject, new GradleSyncListener.Adapter(){

            @Override
            public void syncSucceeded(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (DependencyManager.this.checkForNewMissingDependencies()) {
                    paletteUI.repaint();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/palette/DependencyManager$1", "syncSucceeded"));
            }
        }, parentDisposable);
    }

    @NotNull
    private static Set<String> fromGradleCoordinatesToIds(@NotNull Collection<GradleCoordinate> coordinates) {
        if (coordinates == null) {
            DependencyManager.$$$reportNull$$$0(21);
        }
        Set<String> set = coordinates.stream().map(GradleCoordinate::getId).filter(dependency -> dependency != null).collect(Collectors.toSet());
        if (set == null) {
            DependencyManager.$$$reportNull$$$0(22);
        }
        return set;
    }

    @NotNull
    private static List<GradleCoordinate> toGradleCoordinatesFromIds(@NotNull Collection<String> dependencies2) {
        if (dependencies2 == null) {
            DependencyManager.$$$reportNull$$$0(23);
        }
        List<GradleCoordinate> list = dependencies2.stream().map(dependency -> GradleCoordinate.parseCoordinateString((String)(dependency + ":+"))).filter(coordinate -> coordinate != null).collect(Collectors.toList());
        if (list == null) {
            DependencyManager.$$$reportNull$$$0(24);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 9: 
            case 12: 
            case 17: 
            case 18: 
            case 22: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 9: 
            case 12: 
            case 17: 
            case 18: 
            case 22: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paletteUI";
                break;
            }
            case 2: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 3: 
            case 9: 
            case 12: 
            case 17: 
            case 18: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/palette/DependencyManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "palette";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 8: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentContext";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloadIcon";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coordinates";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/palette/DependencyManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 9: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createItemIcon";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createLargeItemIcon";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "fromGradleCoordinatesToIds";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "toGradleCoordinatesFromIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 9: 
            case 12: 
            case 17: 
            case 18: 
            case 22: 
            case 24: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setPalette";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "needsLibraryLoad";
                break;
            }
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createItemIcon";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createLargeItemIcon";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "registerDependencyUpdates";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "fromGradleCoordinatesToIds";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "toGradleCoordinatesFromIds";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 9: 
            case 12: 
            case 17: 
            case 18: 
            case 22: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

