/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.android.exportSignedPackage.CheckModulePanel;
import org.jetbrains.android.exportSignedPackage.ExportSignedPackageWizard;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;

public class GenerateSignedApkAction
extends AnAction {
    public GenerateSignedApkAction() {
        super(AndroidBundle.message("android.generate.signed.apk.action.text", new Object[0]));
    }

    private static boolean checkFacet(@NotNull AndroidFacet facet) {
        if (facet == null) {
            GenerateSignedApkAction.$$$reportNull$$$0(0);
        }
        final CheckModulePanel panel = new CheckModulePanel();
        panel.updateMessages(facet);
        final boolean hasError = panel.hasError();
        if (hasError || panel.hasWarnings()) {
            DialogWrapper dialog = new DialogWrapper(facet.getModule().getProject()){
                {
                    super(arg0);
                    if (!hasError) {
                        this.setOKButtonText("Continue");
                    }
                    this.init();
                }

                @NotNull
                protected Action[] createActions() {
                    if (hasError) {
                        Action[] actionArray = new Action[]{this.getOKAction()};
                        if (actionArray == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return actionArray;
                    }
                    Action[] actionArray = super.createActions();
                    if (actionArray == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return actionArray;
                }

                protected JComponent createCenterPanel() {
                    return panel;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/GenerateSignedApkAction$1", "createActions"));
                }
            };
            dialog.setTitle(hasError ? CommonBundle.getErrorTitle() : CommonBundle.getWarningTitle());
            dialog.show();
            return !hasError && dialog.isOK();
        }
        return true;
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        assert (project != null);
        List<AndroidFacet> facets = AndroidUtils.getApplicationFacets(project);
        assert (!facets.isEmpty());
        if (facets.size() == 1 && !GenerateSignedApkAction.checkFacet(facets.get(0))) {
            return;
        }
        ExportSignedPackageWizard wizard = new ExportSignedPackageWizard(project, facets, true);
        wizard.show();
    }

    public void update(AnActionEvent e) {
        Project project = e.getProject();
        boolean enabled = project != null && !AndroidUtils.getApplicationFacets(project).isEmpty() && (GradleProjectInfo.getInstance(project).isBuildWithGradle() || !AndroidProjectInfo.getInstance(project).requiresAndroidModel());
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/actions/GenerateSignedApkAction", "checkFacet"));
    }
}

