/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler.artifact;

import com.android.sdklib.IAndroidTarget;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.ArtifactPropertiesEditor;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Transient;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.compiler.artifact.AndroidApplicationArtifactType;
import org.jetbrains.android.compiler.artifact.AndroidArtifactPropertiesEditor;
import org.jetbrains.android.compiler.artifact.AndroidArtifactSigningMode;
import org.jetbrains.android.compiler.artifact.AndroidArtifactUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.annotations.NotNull;

public class AndroidApplicationArtifactProperties
extends ArtifactProperties<AndroidApplicationArtifactProperties> {
    private AndroidArtifactSigningMode mySigningMode = AndroidArtifactSigningMode.RELEASE_UNSIGNED;
    private String myKeyStoreUrl = "";
    private String myKeyStorePassword = "";
    private String myKeyAlias = "";
    private String myKeyPassword = "";
    private boolean myRunProGuard;
    private List<String> myProGuardCfgFiles = new ArrayList<String>();

    public void onBuildFinished(@NotNull Artifact artifact, @NotNull CompileContext context) {
        if (artifact == null) {
            AndroidApplicationArtifactProperties.$$$reportNull$$$0(0);
        }
        if (context == null) {
            AndroidApplicationArtifactProperties.$$$reportNull$$$0(1);
        }
        if (!(artifact.getArtifactType() instanceof AndroidApplicationArtifactType)) {
            return;
        }
        if (this.mySigningMode != AndroidArtifactSigningMode.RELEASE_SIGNED && this.mySigningMode != AndroidArtifactSigningMode.DEBUG_WITH_CUSTOM_CERTIFICATE) {
            return;
        }
        AndroidFacet facet = AndroidArtifactUtil.getPackagedFacet(context.getProject(), artifact);
        if (facet == null) {
            return;
        }
        String artifactName = artifact.getName();
        String messagePrefix = "[Artifact '" + artifactName + "'] ";
        Module module = facet.getModule();
        AndroidPlatform platform = AndroidPlatform.getInstance(module);
        if (platform == null) {
            context.addMessage(CompilerMessageCategory.ERROR, messagePrefix + AndroidBundle.message("android.compilation.error.specify.platform", module.getName()), null, -1, -1);
            return;
        }
        String sdkLocation = platform.getSdkData().getPath();
        String artifactFilePath = artifact.getOutputFilePath();
        String keyStorePath = this.myKeyStoreUrl != null ? VfsUtilCore.urlToPath((String)this.myKeyStoreUrl) : "";
        String keyStorePassword = this.myKeyStorePassword != null && !this.myKeyStorePassword.isEmpty() ? this.getPlainKeystorePassword() : null;
        String keyPassword = this.myKeyPassword != null && !this.myKeyPassword.isEmpty() ? this.getPlainKeyPassword() : null;
        try {
            Map messages = AndroidCommonUtils.buildArtifact((String)artifactName, (String)messagePrefix, (String)sdkLocation, (IAndroidTarget)platform.getTarget(), (String)artifactFilePath, (String)keyStorePath, (String)this.myKeyAlias, (String)keyStorePassword, (String)keyPassword);
            AndroidCompileUtil.addMessages(context, AndroidCompileUtil.toCompilerMessageCategoryKeys(messages), null);
        }
        catch (GeneralSecurityException e) {
            AndroidCompileUtil.reportException(context, messagePrefix, e);
        }
        catch (IOException e) {
            AndroidCompileUtil.reportException(context, messagePrefix, e);
        }
    }

    public ArtifactPropertiesEditor createEditor(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            AndroidApplicationArtifactProperties.$$$reportNull$$$0(2);
        }
        return new AndroidArtifactPropertiesEditor(context.getArtifact(), this, context.getProject());
    }

    public AndroidApplicationArtifactProperties getState() {
        return this;
    }

    public void loadState(AndroidApplicationArtifactProperties state) {
        XmlSerializerUtil.copyBean((Object)((Object)state), (Object)((Object)this));
    }

    public AndroidArtifactSigningMode getSigningMode() {
        return this.mySigningMode;
    }

    public void setSigningMode(AndroidArtifactSigningMode signingMode) {
        this.mySigningMode = signingMode;
    }

    public String getKeyStoreUrl() {
        return this.myKeyStoreUrl;
    }

    public String getKeyStorePassword() {
        return this.myKeyStorePassword;
    }

    public String getKeyAlias() {
        return this.myKeyAlias;
    }

    public String getKeyPassword() {
        return this.myKeyPassword;
    }

    public void setKeyStoreUrl(String keyStoreUrl) {
        this.myKeyStoreUrl = keyStoreUrl;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.myKeyStorePassword = keyStorePassword;
    }

    public void setKeyAlias(String keyAlias) {
        this.myKeyAlias = keyAlias;
    }

    public void setKeyPassword(String keyPassword) {
        this.myKeyPassword = keyPassword;
    }

    @Transient
    @NotNull
    public String getPlainKeystorePassword() {
        String string = new String(Base64.getDecoder().decode(this.myKeyStorePassword), StandardCharsets.UTF_8);
        if (string == null) {
            AndroidApplicationArtifactProperties.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Transient
    public void setPlainKeystorePassword(@NotNull String password) {
        if (password == null) {
            AndroidApplicationArtifactProperties.$$$reportNull$$$0(4);
        }
        this.myKeyStorePassword = Base64.getEncoder().encodeToString(password.getBytes(StandardCharsets.UTF_8));
    }

    @Transient
    @NotNull
    public String getPlainKeyPassword() {
        String string = new String(Base64.getDecoder().decode(this.myKeyPassword), StandardCharsets.UTF_8);
        if (string == null) {
            AndroidApplicationArtifactProperties.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Transient
    public void setPlainKeyPassword(@NotNull String password) {
        if (password == null) {
            AndroidApplicationArtifactProperties.$$$reportNull$$$0(6);
        }
        this.myKeyPassword = Base64.getEncoder().encodeToString(password.getBytes(StandardCharsets.UTF_8));
    }

    public boolean isRunProGuard() {
        return this.myRunProGuard;
    }

    public void setRunProGuard(boolean runProGuard) {
        this.myRunProGuard = runProGuard;
    }

    public List<String> getProGuardCfgFiles() {
        return this.myProGuardCfgFiles;
    }

    public void setProGuardCfgFiles(List<String> proGuardCfgFiles) {
        this.myProGuardCfgFiles = proGuardCfgFiles;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/compiler/artifact/AndroidApplicationArtifactProperties";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "password";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/compiler/artifact/AndroidApplicationArtifactProperties";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlainKeystorePassword";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlainKeyPassword";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "onBuildFinished";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setPlainKeystorePassword";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setPlainKeyPassword";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

