/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.CreateFileResourceQuickFix;
import org.jetbrains.android.inspections.CreateValueResourceQuickFix;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;

public class AndroidResourceQuickFixProvider
extends UnresolvedReferenceQuickFixProvider<PsiReferenceExpression> {
    public void registerFixes(@NotNull PsiReferenceExpression exp, @NotNull QuickFixActionRegistrar registrar) {
        ResourceFolderType folderType;
        ResourceType resourceType;
        AndroidFacet resolvedFacet;
        PsiElement parent;
        Module contextModule;
        if (exp == null) {
            AndroidResourceQuickFixProvider.$$$reportNull$$$0(0);
        }
        if (registrar == null) {
            AndroidResourceQuickFixProvider.$$$reportNull$$$0(1);
        }
        if ((contextModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)exp)) == null) {
            return;
        }
        AndroidFacet facet = AndroidFacet.getInstance(contextModule);
        if (facet == null) {
            return;
        }
        PsiFile contextFile = exp.getContainingFile();
        if (contextFile == null) {
            return;
        }
        AndroidResourceUtil.MyReferredResourceFieldInfo info = AndroidResourceUtil.getReferredResourceOrManifestField(facet, exp, true);
        if (info == null && (parent = exp.getParent()) instanceof PsiReferenceExpression) {
            info = AndroidResourceUtil.getReferredResourceOrManifestField(facet, (PsiReferenceExpression)parent, true);
        }
        if (info == null || info.isFromManifest()) {
            return;
        }
        String resClassName = info.getClassName();
        String resFieldName = info.getFieldName();
        Module resolvedModule = info.getResolvedModule();
        if (resolvedModule != null && resolvedModule != contextModule && (resolvedFacet = AndroidFacet.getInstance(resolvedModule)) != null) {
            facet = resolvedFacet;
        }
        if (AndroidResourceUtil.ALL_VALUE_RESOURCE_TYPES.contains(resourceType = ResourceType.getEnum((String)resClassName))) {
            registrar.register((IntentionAction)new CreateValueResourceQuickFix(facet, resourceType, resFieldName, contextFile, true));
        }
        if ((folderType = AndroidResourceUtil.XML_FILE_RESOURCE_TYPES.get(resourceType)) != null) {
            registrar.register((IntentionAction)new CreateFileResourceQuickFix(facet, folderType, resFieldName, contextFile, true));
        }
    }

    @NotNull
    public Class<PsiReferenceExpression> getReferenceClass() {
        if (PsiReferenceExpression.class == null) {
            AndroidResourceQuickFixProvider.$$$reportNull$$$0(2);
        }
        return PsiReferenceExpression.class;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exp";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/inspections/AndroidResourceQuickFixProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/inspections/AndroidResourceQuickFixProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerFixes";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

