/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.tools.lint.checks.UselessViewDetector;
import com.android.tools.lint.detector.api.Issue;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class RemoveUselessViewQuickFix
implements AndroidLintQuickFix {
    private final Issue myIssue;

    public RemoveUselessViewQuickFix(@NotNull Issue issue2) {
        if (issue2 == null) {
            RemoveUselessViewQuickFix.$$$reportNull$$$0(0);
        }
        this.myIssue = issue2;
    }

    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        XmlTag tag;
        if (startElement == null) {
            RemoveUselessViewQuickFix.$$$reportNull$$$0(1);
        }
        if (endElement == null) {
            RemoveUselessViewQuickFix.$$$reportNull$$$0(2);
        }
        if (context == null) {
            RemoveUselessViewQuickFix.$$$reportNull$$$0(3);
        }
        if ((tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class)) == null) {
            return;
        }
        XmlTag parentTag = tag.getParentTag();
        if (parentTag == null) {
            return;
        }
        if (this.myIssue.getId().equals(UselessViewDetector.USELESS_LEAF.getId())) {
            WriteCommandAction.runWriteCommandAction((Project)tag.getProject(), () -> ((XmlTag)tag).delete());
        } else assert (false);
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        XmlTag tag;
        if (startElement == null) {
            RemoveUselessViewQuickFix.$$$reportNull$$$0(4);
        }
        if (endElement == null) {
            RemoveUselessViewQuickFix.$$$reportNull$$$0(5);
        }
        if (contextType == null) {
            RemoveUselessViewQuickFix.$$$reportNull$$$0(6);
        }
        if ((tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class)) == null) {
            return false;
        }
        return tag.getParentTag() != null;
    }

    @Override
    @NotNull
    public String getName() {
        String string = AndroidBundle.message("android.lint.fix.remove.unnecessary.view", new Object[0]);
        if (string == null) {
            RemoveUselessViewQuickFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issue";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/inspections/lint/RemoveUselessViewQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/inspections/lint/RemoveUselessViewQuickFix";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

