/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.resourceManagers;

import com.android.tools.idea.sdk.AndroidSdks;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidFacetScopedService;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.resourceManagers.SystemResourceManager;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleResourceManagers
extends AndroidFacetScopedService {
    @VisibleForTesting
    public static final Key<ModuleResourceManagers> KEY = Key.create((String)ModuleResourceManagers.class.getName());
    private SystemResourceManager myPublicSystemResourceManager;
    private SystemResourceManager myFullSystemResourceManager;
    private LocalResourceManager myLocalResourceManager;

    @NotNull
    public static ModuleResourceManagers getInstance(@NotNull AndroidFacet facet) {
        ModuleResourceManagers resourceManagers;
        if (facet == null) {
            ModuleResourceManagers.$$$reportNull$$$0(0);
        }
        if ((resourceManagers = (ModuleResourceManagers)facet.getUserData(KEY)) == null) {
            resourceManagers = new ModuleResourceManagers(facet);
            facet.putUserData(KEY, resourceManagers);
        }
        ModuleResourceManagers moduleResourceManagers = resourceManagers;
        if (moduleResourceManagers == null) {
            ModuleResourceManagers.$$$reportNull$$$0(1);
        }
        return moduleResourceManagers;
    }

    private ModuleResourceManagers(@NotNull AndroidFacet facet) {
        if (facet == null) {
            ModuleResourceManagers.$$$reportNull$$$0(2);
        }
        super(facet);
    }

    @Nullable
    public ResourceManager getResourceManager(@Nullable String resourcePackage) {
        return this.getResourceManager(resourcePackage, null);
    }

    @Nullable
    public ResourceManager getResourceManager(@Nullable String resourcePackage, @Nullable PsiElement contextElement) {
        if ("android".equals(resourcePackage)) {
            return this.getSystemResourceManager();
        }
        if (contextElement != null && AndroidSdks.getInstance().isInAndroidSdk(contextElement)) {
            return this.getSystemResourceManager();
        }
        return this.getLocalResourceManager();
    }

    @NotNull
    public LocalResourceManager getLocalResourceManager() {
        if (this.myLocalResourceManager == null) {
            this.myLocalResourceManager = new LocalResourceManager(this.getFacet());
        }
        LocalResourceManager localResourceManager = this.myLocalResourceManager;
        if (localResourceManager == null) {
            ModuleResourceManagers.$$$reportNull$$$0(3);
        }
        return localResourceManager;
    }

    @Nullable
    public SystemResourceManager getSystemResourceManager() {
        return this.getSystemResourceManager(true);
    }

    @Nullable
    public SystemResourceManager getSystemResourceManager(boolean publicOnly) {
        AndroidPlatform platform;
        if (publicOnly) {
            AndroidPlatform platform2;
            if (this.myPublicSystemResourceManager == null && (platform2 = ((AndroidFacetConfiguration)this.getFacet().getConfiguration()).getAndroidPlatform()) != null) {
                this.myPublicSystemResourceManager = new SystemResourceManager(this.getModule().getProject(), platform2, true);
            }
            return this.myPublicSystemResourceManager;
        }
        if (this.myFullSystemResourceManager == null && (platform = ((AndroidFacetConfiguration)this.getFacet().getConfiguration()).getAndroidPlatform()) != null) {
            this.myFullSystemResourceManager = new SystemResourceManager(this.getModule().getProject(), platform, false);
        }
        return this.myFullSystemResourceManager;
    }

    public void clear() {
        this.myLocalResourceManager = null;
        this.myPublicSystemResourceManager = null;
    }

    @Override
    protected void onServiceDisposal(@NotNull AndroidFacet facet) {
        if (facet == null) {
            ModuleResourceManagers.$$$reportNull$$$0(4);
        }
        facet.putUserData(KEY, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/resourceManagers/ModuleResourceManagers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/resourceManagers/ModuleResourceManagers";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalResourceManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onServiceDisposal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

