/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.sdk;

import com.android.SdkConstants;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.ddms.adb.AdbService;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.Jdks;
import com.android.tools.idea.sdk.SelectSdkDialog;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.CommonBundle;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.OSProcessManager;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import org.jetbrains.android.actions.AndroidEnableAdbServiceAction;
import org.jetbrains.android.actions.AndroidRunDdmsAction;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidSdkUtils {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.sdk.AndroidSdkUtils");
    public static final String DEFAULT_PLATFORM_NAME_PROPERTY = "AndroidPlatformName";
    public static final String DEFAULT_JDK_NAME = "JDK";
    public static final String ADB_PATH_PROPERTY = "android.adb.path";

    private AndroidSdkUtils() {
    }

    @Nullable
    public static Sdk createNewAndroidPlatform(@Nullable String sdkPath, boolean promptUser) {
        Sdk sdk;
        IAndroidTarget target;
        Sdk jdk = Jdks.getInstance().chooseOrCreateJavaSdk();
        if (sdkPath != null && jdk != null && (target = AndroidSdkUtils.findBestTarget(sdkPath = FileUtil.toSystemIndependentName((String)sdkPath))) != null && (sdk = AndroidSdks.getInstance().create(target, new File(sdkPath), AndroidSdks.getInstance().chooseNameForNewLibrary(target), jdk, true)) != null) {
            return sdk;
        }
        String jdkPath = jdk == null ? null : jdk.getHomePath();
        return promptUser ? AndroidSdkUtils.promptUserForSdkCreation(null, sdkPath, jdkPath) : null;
    }

    @Nullable
    private static IAndroidTarget findBestTarget(@NotNull String sdkPath) {
        AndroidSdkData sdkData;
        if (sdkPath == null) {
            AndroidSdkUtils.$$$reportNull$$$0(0);
        }
        if ((sdkData = AndroidSdkData.getSdkData(sdkPath)) != null) {
            IAndroidTarget[] targets = sdkData.getTargets();
            if (targets.length == 1) {
                return targets[0];
            }
            return AndroidSdkUtils.findBestTarget(targets);
        }
        return null;
    }

    @Nullable
    private static IAndroidTarget findBestTarget(@NotNull IAndroidTarget[] targets) {
        if (targets == null) {
            AndroidSdkUtils.$$$reportNull$$$0(1);
        }
        IAndroidTarget bestTarget = null;
        int maxApiLevel = -1;
        for (IAndroidTarget target : targets) {
            AndroidVersion version = target.getVersion();
            if (!target.isPlatform() || version.isPreview() || version.getApiLevel() <= maxApiLevel) continue;
            bestTarget = target;
            maxApiLevel = version.getApiLevel();
        }
        return bestTarget;
    }

    public static String getTargetPresentableName(@NotNull IAndroidTarget target) {
        if (target == null) {
            AndroidSdkUtils.$$$reportNull$$$0(2);
        }
        return target.isPlatform() ? target.getName() : target.getName() + " (" + target.getVersionName() + ')';
    }

    public static boolean targetHasId(@NotNull IAndroidTarget target, @NotNull String id) {
        if (target == null) {
            AndroidSdkUtils.$$$reportNull$$$0(3);
        }
        if (id == null) {
            AndroidSdkUtils.$$$reportNull$$$0(4);
        }
        return id.equals(target.getVersion().getApiString()) || id.equals(target.getVersionName());
    }

    private static boolean tryToSetAndroidPlatform(@NotNull Module module, @NotNull Sdk sdk) {
        AndroidPlatform platform;
        if (module == null) {
            AndroidSdkUtils.$$$reportNull$$$0(5);
        }
        if (sdk == null) {
            AndroidSdkUtils.$$$reportNull$$$0(6);
        }
        if ((platform = AndroidPlatform.parse(sdk)) != null) {
            ModuleRootModificationUtil.setModuleSdk((Module)module, (Sdk)sdk);
            return true;
        }
        return false;
    }

    private static void setupPlatform(@NotNull Module module) {
        String targetHashString;
        if (module == null) {
            AndroidSdkUtils.$$$reportNull$$$0(7);
        }
        if ((targetHashString = AndroidSdkUtils.getTargetHashStringFromPropertyFile(module)) != null && AndroidSdkUtils.findAndSetSdkWithHashString(module, targetHashString)) {
            return;
        }
        PropertiesComponent component2 = PropertiesComponent.getInstance();
        if (component2.isValueSet(DEFAULT_PLATFORM_NAME_PROPERTY)) {
            String defaultPlatformName = component2.getValue(DEFAULT_PLATFORM_NAME_PROPERTY);
            Sdk defaultLib = ProjectJdkTable.getInstance().findJdk(defaultPlatformName, AndroidSdkType.getInstance().getName());
            if (defaultLib != null && AndroidSdkUtils.tryToSetAndroidPlatform(module, defaultLib)) {
                return;
            }
        }
        for (Sdk sdk : AndroidSdks.getInstance().getAllAndroidSdks()) {
            AndroidPlatform platform = AndroidPlatform.getInstance(sdk);
            if (platform == null || !AndroidSdkUtils.checkSdkRoots(sdk, platform.getTarget(), false) || !AndroidSdkUtils.tryToSetAndroidPlatform(module, sdk)) continue;
            component2.setValue(DEFAULT_PLATFORM_NAME_PROPERTY, sdk.getName());
            return;
        }
    }

    @Nullable
    private static String getTargetHashStringFromPropertyFile(@NotNull Module module) {
        Pair<String, VirtualFile> targetProp;
        if (module == null) {
            AndroidSdkUtils.$$$reportNull$$$0(8);
        }
        return (targetProp = AndroidRootUtil.getProjectPropertyValue(module, "target")) != null ? (String)targetProp.getFirst() : null;
    }

    private static boolean findAndSetSdkWithHashString(@NotNull Module module, @NotNull String targetHashString) {
        Pair<String, VirtualFile> sdkDirProperty;
        if (module == null) {
            AndroidSdkUtils.$$$reportNull$$$0(9);
        }
        if (targetHashString == null) {
            AndroidSdkUtils.$$$reportNull$$$0(10);
        }
        String sdkDir = (sdkDirProperty = AndroidRootUtil.getPropertyValue(module, "local.properties", "sdk.dir")) != null ? (String)sdkDirProperty.getFirst() : null;
        return AndroidSdkUtils.findAndSetSdk(module, targetHashString, sdkDir);
    }

    public static boolean findAndSetSdk(@NotNull Module module, @NotNull String targetHashString, @Nullable String sdkPath) {
        Sdk sdk;
        if (module == null) {
            AndroidSdkUtils.$$$reportNull$$$0(11);
        }
        if (targetHashString == null) {
            AndroidSdkUtils.$$$reportNull$$$0(12);
        }
        File path = null;
        if (sdkPath != null) {
            path = new File(FileUtil.toSystemIndependentName((String)sdkPath));
        }
        if ((sdk = AndroidSdks.getInstance().findSuitableAndroidSdk(targetHashString)) != null) {
            ModuleRootModificationUtil.setModuleSdk((Module)module, (Sdk)sdk);
            return true;
        }
        if (sdkPath != null && AndroidSdkUtils.tryToCreateAndSetAndroidSdk(module, path, targetHashString)) {
            return true;
        }
        String androidHomeValue = System.getenv("ANDROID_HOME");
        if (androidHomeValue != null && AndroidSdkUtils.tryToCreateAndSetAndroidSdk(module, new File(FileUtil.toSystemIndependentName((String)androidHomeValue)), targetHashString)) {
            return true;
        }
        for (File dir : AndroidSdks.getInstance().getAndroidSdkPathsFromExistingPlatforms()) {
            if (!AndroidSdkUtils.tryToCreateAndSetAndroidSdk(module, dir, targetHashString)) continue;
            return true;
        }
        return false;
    }

    public static void updateSdkSourceRoot(@NotNull Sdk sdk) {
        AndroidPlatform platform;
        if (sdk == null) {
            AndroidSdkUtils.$$$reportNull$$$0(13);
        }
        if ((platform = AndroidPlatform.getInstance(sdk)) != null) {
            IAndroidTarget target = platform.getTarget();
            SdkModificator sdkModificator = sdk.getSdkModificator();
            sdkModificator.removeRoots(OrderRootType.SOURCES);
            AndroidSdks.getInstance().findAndSetPlatformSources(target, sdkModificator);
            sdkModificator.commitChanges();
        }
    }

    @VisibleForTesting
    static boolean tryToCreateAndSetAndroidSdk(@NotNull Module module, @NotNull File sdkPath, @NotNull String targetHashString) {
        Sdk sdk;
        if (module == null) {
            AndroidSdkUtils.$$$reportNull$$$0(14);
        }
        if (sdkPath == null) {
            AndroidSdkUtils.$$$reportNull$$$0(15);
        }
        if (targetHashString == null) {
            AndroidSdkUtils.$$$reportNull$$$0(16);
        }
        if ((sdk = AndroidSdks.getInstance().tryToCreate(sdkPath, targetHashString)) != null) {
            ModuleRootModificationUtil.setModuleSdk((Module)module, (Sdk)sdk);
            return true;
        }
        return false;
    }

    @Nullable
    private static Sdk promptUserForSdkCreation(@Nullable IAndroidTarget target, @Nullable String androidSdkPath, @Nullable String jdkPath) {
        Ref sdkRef = new Ref();
        Runnable task = () -> {
            SelectSdkDialog dlg = new SelectSdkDialog(jdkPath, androidSdkPath);
            dlg.setModal(true);
            if (dlg.showAndGet()) {
                AnAction sdkManagerAction;
                Sdk sdk = AndroidSdkUtils.createNewAndroidPlatform(target, dlg.getAndroidHome(), dlg.getJdkHome());
                sdkRef.set((Object)sdk);
                if (sdk != null && (sdkManagerAction = ActionManager.getInstance().getAction("WelcomeScreen.RunAndroidSdkManager")) != null) {
                    sdkManagerAction.update(null);
                }
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            task.run();
            return (Sdk)sdkRef.get();
        }
        application.invokeAndWait(task, ModalityState.any());
        return (Sdk)sdkRef.get();
    }

    @Nullable
    private static Sdk createNewAndroidPlatform(@Nullable IAndroidTarget target, @NotNull String androidSdkPath, @NotNull String jdkPath) {
        if (androidSdkPath == null) {
            AndroidSdkUtils.$$$reportNull$$$0(17);
        }
        if (jdkPath == null) {
            AndroidSdkUtils.$$$reportNull$$$0(18);
        }
        if (StringUtil.isNotEmpty((String)jdkPath)) {
            jdkPath = FileUtil.toSystemIndependentName((String)jdkPath);
            Sdk jdk = Jdks.getInstance().createJdk(jdkPath);
            if (jdk != null) {
                androidSdkPath = FileUtil.toSystemIndependentName((String)androidSdkPath);
                if (target == null) {
                    target = AndroidSdkUtils.findBestTarget(androidSdkPath);
                }
                if (target != null) {
                    return AndroidSdks.getInstance().create(target, new File(androidSdkPath), AndroidSdks.getInstance().chooseNameForNewLibrary(target), jdk, true);
                }
            }
        }
        return null;
    }

    public static void setupAndroidPlatformIfNecessary(@NotNull Module module, boolean forceImportFromProperties) {
        AndroidPlatform platform;
        Sdk currentSdk;
        if (module == null) {
            AndroidSdkUtils.$$$reportNull$$$0(19);
        }
        if ((currentSdk = ModuleRootManager.getInstance((Module)module).getSdk()) == null || !AndroidSdks.getInstance().isAndroidSdk(currentSdk)) {
            AndroidSdkUtils.setupPlatform(module);
            return;
        }
        if (forceImportFromProperties && (platform = AndroidPlatform.getInstance(currentSdk)) != null) {
            String targetHashString = AndroidSdkUtils.getTargetHashStringFromPropertyFile(module);
            String currentTargetHashString = platform.getTarget().hashString();
            if (targetHashString != null && !targetHashString.equals(currentTargetHashString)) {
                AndroidSdkUtils.findAndSetSdkWithHashString(module, targetHashString);
            }
        }
    }

    public static void openModuleDependenciesConfigurable(@NotNull Module module) {
        if (module == null) {
            AndroidSdkUtils.$$$reportNull$$$0(20);
        }
        ProjectSettingsService.getInstance((Project)module.getProject()).openModuleDependenciesSettings(module, null);
    }

    @Nullable
    public static Sdk findAppropriateAndroidPlatform(@NotNull IAndroidTarget target, @NotNull AndroidSdkData sdkData, boolean forMaven) {
        if (target == null) {
            AndroidSdkUtils.$$$reportNull$$$0(21);
        }
        if (sdkData == null) {
            AndroidSdkUtils.$$$reportNull$$$0(22);
        }
        for (Sdk sdk : ProjectJdkTable.getInstance().getAllJdks()) {
            IAndroidTarget currentTarget;
            AndroidSdkAdditionalData data;
            AndroidSdkData currentSdkData;
            String homePath = sdk.getHomePath();
            AndroidSdks androidSdks = AndroidSdks.getInstance();
            if (homePath == null || !androidSdks.isAndroidSdk(sdk) || !sdkData.equals(currentSdkData = AndroidSdkData.getSdkData(homePath)) || (data = androidSdks.getAndroidSdkAdditionalData(sdk)) == null || (currentTarget = data.getBuildTarget(currentSdkData)) == null || !target.hashString().equals(currentTarget.hashString()) || !AndroidSdkUtils.checkSdkRoots(sdk, target, forMaven)) continue;
            return sdk;
        }
        return null;
    }

    public static boolean checkSdkRoots(@NotNull Sdk sdk, @NotNull IAndroidTarget target, boolean forMaven) {
        Sdk javaSdk;
        String homePath;
        if (sdk == null) {
            AndroidSdkUtils.$$$reportNull$$$0(23);
        }
        if (target == null) {
            AndroidSdkUtils.$$$reportNull$$$0(24);
        }
        if ((homePath = sdk.getHomePath()) == null) {
            return false;
        }
        AndroidSdks androidSdks = AndroidSdks.getInstance();
        AndroidSdkAdditionalData sdkAdditionalData = androidSdks.getAndroidSdkAdditionalData(sdk);
        Sdk sdk2 = javaSdk = sdkAdditionalData != null ? sdkAdditionalData.getJavaSdk() : null;
        if (javaSdk == null) {
            return false;
        }
        HashSet filesInSdk = Sets.newHashSet((Object[])sdk.getRootProvider().getFiles(OrderRootType.CLASSES));
        List<VirtualFile> platformAndAddOnJars = androidSdks.getPlatformAndAddOnJars(target);
        for (VirtualFile file : platformAndAddOnJars) {
            if (filesInSdk.contains(file) != forMaven) continue;
            return false;
        }
        boolean containsJarFromJdk = false;
        for (VirtualFile file : javaSdk.getRootProvider().getFiles(OrderRootType.CLASSES)) {
            if (!(file.getFileType() instanceof ArchiveFileType) || !filesInSdk.contains(file)) continue;
            containsJarFromJdk = true;
        }
        return containsJarFromJdk == forMaven;
    }

    @Nullable
    public static File getAdb(@NotNull Project project) {
        AndroidSdkData data;
        String path;
        if (project == null) {
            AndroidSdkUtils.$$$reportNull$$$0(25);
        }
        if ((path = System.getProperty(ADB_PATH_PROPERTY)) != null) {
            File adb = new File(path);
            if (adb.exists()) {
                return adb;
            }
            LOG.warn(String.format("%1$s was set to \"%2$s\", but no such file exists.", ADB_PATH_PROPERTY, path));
        }
        if ((data = AndroidSdkUtils.getProjectSdkData(project)) == null) {
            data = AndroidSdkUtils.getFirstAndroidModuleSdkData(project);
        }
        File adb = data == null ? null : new File(data.getLocation(), AndroidCommonUtils.platformToolPath((String)SdkConstants.FN_ADB));
        return adb != null && adb.exists() ? adb : null;
    }

    @Nullable
    private static AndroidSdkData getFirstAndroidModuleSdkData(Project project) {
        List facets = ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID);
        for (AndroidFacet facet : facets) {
            AndroidPlatform androidPlatform = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidPlatform();
            if (androidPlatform == null) continue;
            return androidPlatform.getSdkData();
        }
        return null;
    }

    @Nullable
    private static AndroidSdkData getProjectSdkData(Project project) {
        Sdk projectSdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        if (projectSdk != null) {
            AndroidPlatform platform = AndroidPlatform.getInstance(projectSdk);
            return platform != null ? platform.getSdkData() : null;
        }
        return null;
    }

    public static boolean activateDdmsIfNecessary(@NotNull Project project) {
        if (project == null) {
            AndroidSdkUtils.$$$reportNull$$$0(26);
        }
        if (AndroidEnableAdbServiceAction.isAdbServiceEnabled()) {
            AndroidDebugBridge bridge = AndroidSdkUtils.getDebugBridge(project);
            if (bridge != null && AdbService.isDdmsCorrupted(bridge)) {
                LOG.info("DDMLIB is corrupted and will be restarted");
                File adb = AndroidSdkUtils.getAdb(project);
                if (adb == null) {
                    throw new RuntimeException("Unable to locate Android SDK used by project: " + project.getName());
                }
                AdbService.getInstance().restartDdmlib(adb);
            }
        } else {
            OSProcessHandler ddmsProcessHandler = AndroidRunDdmsAction.getDdmsProcessHandler();
            if (ddmsProcessHandler != null) {
                String message = "Monitor will be closed to enable ADB integration. Continue?";
                int result = Messages.showYesNoDialog((Project)project, (String)message, (String)"ADB Integration", (Icon)Messages.getQuestionIcon());
                if (result != 0) {
                    return false;
                }
                Runnable destroyingRunnable = () -> {
                    if (!ddmsProcessHandler.isProcessTerminated()) {
                        OSProcessManager.getInstance().killProcessTree(ddmsProcessHandler.getProcess());
                        ddmsProcessHandler.waitFor();
                    }
                };
                if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(destroyingRunnable, "Closing Monitor", true, project)) {
                    return false;
                }
                AndroidEnableAdbServiceAction.setAdbServiceEnabled(project, true);
                return true;
            }
            int result = Messages.showYesNoDialog((Project)project, (String)AndroidBundle.message("android.ddms.disabled.error", new Object[0]), (String)AndroidBundle.message("android.ddms.disabled.dialog.title", new Object[0]), (Icon)Messages.getQuestionIcon());
            if (result != 0) {
                return false;
            }
            AndroidEnableAdbServiceAction.setAdbServiceEnabled(project, true);
        }
        return true;
    }

    public static boolean isAndroidSdkAvailable() {
        return AndroidSdks.getInstance().tryToChooseAndroidSdk() != null;
    }

    public static boolean isGlassInstalled() {
        StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(AndroidSdkUtils.class);
        AndroidSdkHandler handler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        Collection targets = handler.getAndroidTargetManager((com.android.repository.api.ProgressIndicator)progress).getTargets((com.android.repository.api.ProgressIndicator)progress);
        for (IAndroidTarget target : targets) {
            if (target.isPlatform() || !target.getName().startsWith("Glass Development Kit")) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static String getTargetLabel(@NotNull IAndroidTarget target) {
        if (target == null) {
            AndroidSdkUtils.$$$reportNull$$$0(27);
        }
        if (!target.isPlatform()) {
            String string = String.format("%1$s (API %2$s)", target.getFullName(), target.getVersion().getApiString());
            if (string == null) {
                AndroidSdkUtils.$$$reportNull$$$0(28);
            }
            return string;
        }
        AndroidVersion version = target.getVersion();
        if (version.isPreview()) {
            String string = String.format("API %d+: %s", target.getVersion().getApiLevel(), target.getName());
            if (string == null) {
                AndroidSdkUtils.$$$reportNull$$$0(29);
            }
            return string;
        }
        String name = SdkVersionInfo.getAndroidName((int)target.getVersion().getApiLevel());
        if (StringUtil.isNotEmpty((String)name)) {
            String string = name;
            if (string == null) {
                AndroidSdkUtils.$$$reportNull$$$0(30);
            }
            return string;
        }
        String release = target.getProperty("ro.build.version.release");
        if (release != null) {
            String string = String.format("API %1$d: Android %2$s", version.getApiLevel(), release);
            if (string == null) {
                AndroidSdkUtils.$$$reportNull$$$0(31);
            }
            return string;
        }
        String string = String.format("API %1$d", version.getApiLevel());
        if (string == null) {
            AndroidSdkUtils.$$$reportNull$$$0(32);
        }
        return string;
    }

    @Nullable
    public static AndroidDebugBridge getDebugBridge(@NotNull Project project) {
        boolean retry;
        if (project == null) {
            AndroidSdkUtils.$$$reportNull$$$0(33);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        AndroidSdkData data = AndroidSdkUtils.getProjectSdkData(project);
        if (data == null) {
            data = AndroidSdkUtils.getFirstAndroidModuleSdkData(project);
        }
        if (data == null) {
            return null;
        }
        AndroidDebugBridge bridge = null;
        do {
            File adb;
            if ((adb = AndroidSdkUtils.getAdb(project)) == null) {
                LOG.error("Unable to locate adb within SDK");
                return null;
            }
            ListenableFuture<AndroidDebugBridge> future = AdbService.getInstance().getDebugBridge(adb);
            MyMonitorBridgeConnectionTask task = new MyMonitorBridgeConnectionTask(project, (Future<AndroidDebugBridge>)future);
            ProgressManager.getInstance().run((Task)task);
            if (task.wasCanceled()) {
                return null;
            }
            retry = false;
            try {
                bridge = (AndroidDebugBridge)future.get();
            }
            catch (InterruptedException e) {
                break;
            }
            catch (ExecutionException e) {
                String message = "ADB not responding. If you'd like to retry, then please manually kill \"" + SdkConstants.FN_ADB + "\" and click 'Restart'";
                boolean bl = retry = Messages.showYesNoDialog((Project)project, (String)message, (String)CommonBundle.getErrorTitle(), (String)"&Restart", (String)"&Cancel", (Icon)Messages.getErrorIcon()) == 0;
            }
        } while (retry);
        return bridge;
    }

    public static void refreshLibrariesIn(@NotNull Sdk sdk) {
        if (sdk == null) {
            AndroidSdkUtils.$$$reportNull$$$0(34);
        }
        VirtualFile[] libraries = sdk.getRootProvider().getFiles(OrderRootType.CLASSES);
        SdkModificator sdkModificator = sdk.getSdkModificator();
        sdkModificator.removeRoots(OrderRootType.CLASSES);
        sdkModificator.commitChanges();
        sdkModificator = sdk.getSdkModificator();
        for (VirtualFile library : libraries) {
            sdkModificator.addRoot(library, OrderRootType.CLASSES);
        }
        sdkModificator.commitChanges();
    }

    public static boolean isAndroidSdkManagerEnabled() {
        boolean sdkManagerDisabled = SystemProperties.getBooleanProperty((String)"android.studio.sdk.manager.disabled", (boolean)false);
        return !sdkManagerDisabled;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 2: 
            case 3: 
            case 21: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: 
            case 13: 
            case 23: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 10: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetHashString";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidSdkPath";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkPath";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkData";
                break;
            }
            case 25: 
            case 26: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/sdk/AndroidSdkUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/sdk/AndroidSdkUtils";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findBestTarget";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTargetPresentableName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "targetHasId";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "tryToSetAndroidPlatform";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setupPlatform";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTargetHashStringFromPropertyFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findAndSetSdkWithHashString";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findAndSetSdk";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateSdkSourceRoot";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "tryToCreateAndSetAndroidSdk";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createNewAndroidPlatform";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setupAndroidPlatformIfNecessary";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "openModuleDependenciesConfigurable";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findAppropriateAndroidPlatform";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "checkSdkRoots";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getAdb";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "activateDdmsIfNecessary";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getTargetLabel";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getDebugBridge";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "refreshLibrariesIn";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyMonitorBridgeConnectionTask
    extends Task.Modal {
        private final Future<AndroidDebugBridge> myFuture;
        private boolean myCancelled;

        public MyMonitorBridgeConnectionTask(@Nullable Project project, Future<AndroidDebugBridge> future) {
            super(project, "Waiting for adb", true);
            this.myFuture = future;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                MyMonitorBridgeConnectionTask.$$$reportNull$$$0(0);
            }
            indicator.setIndeterminate(true);
            while (!this.myFuture.isDone()) {
                try {
                    this.myFuture.get(200L, TimeUnit.MILLISECONDS);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!indicator.isCanceled()) continue;
                return;
            }
        }

        public void onCancel() {
            this.myCancelled = true;
        }

        public boolean wasCanceled() {
            return this.myCancelled;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/android/sdk/AndroidSdkUtils$MyMonitorBridgeConnectionTask", "run"));
        }
    }
}

