/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application;

import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.boot.model.autoconfigure.jam.EnableAutoConfiguration;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;

public class SpringBootApplicationUtil {
    private static final Condition<PsiClass> RUNNABLE_CONDITION = psiClass -> PsiMethodUtil.MAIN_CLASS.value(psiClass) && psiClass.hasModifierProperty("public");

    public static boolean isSpringApplication(PsiClass psiClass) {
        if (!RUNNABLE_CONDITION.value((Object)psiClass)) {
            return false;
        }
        EnableAutoConfiguration element = (EnableAutoConfiguration)JamService.getJamService((Project)psiClass.getProject()).getJamElement((PsiElement)psiClass, new JamMemberMeta[]{EnableAutoConfiguration.META});
        return element != null;
    }

    public static List<PsiClass> getSpringApplications(Module module) {
        if (DumbService.isDumb((Project)module.getProject())) {
            return Collections.emptyList();
        }
        if (SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.boot.autoconfigure.EnableAutoConfiguration") == null) {
            return Collections.emptyList();
        }
        return (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            JamService jamService = JamService.getJamService((Project)module.getProject());
            GlobalSearchScope scope = module.getModuleScope(false);
            ArrayList<String> fqns = new ArrayList<String>((Collection)EnableAutoConfiguration.getAnnotations().fun((Object)module));
            fqns.add("org.springframework.boot.autoconfigure.EnableAutoConfiguration");
            SmartList applications = new SmartList();
            for (String fqn : fqns) {
                List elements = jamService.getJamClassElements(EnableAutoConfiguration.JAM_KEY, fqn, scope);
                for (EnableAutoConfiguration element : elements) {
                    PsiClass annotatedClass = element.getPsiElement();
                    if (!RUNNABLE_CONDITION.value((Object)annotatedClass)) continue;
                    applications.add(annotatedClass);
                }
            }
            return CachedValueProvider.Result.create((Object)applications, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
    }

    public static boolean hasMainMethod(PsiClass psiClass) {
        return PsiMethodUtil.hasMainMethod((PsiClass)SpringBootApplicationUtil.guessUastMainClass(psiClass));
    }

    @Nullable
    public static PsiClass guessUastMainClass(@Nullable PsiClass springBootClass) {
        if (springBootClass == null) {
            return null;
        }
        PsiFile langFile = (PsiFile)ReadAction.compute(() -> {
            VirtualFile virtualFile = springBootClass.getContainingFile().getVirtualFile();
            if (virtualFile == null) {
                return null;
            }
            return springBootClass.getManager().findFile(virtualFile);
        });
        if (langFile == null) {
            return springBootClass;
        }
        UFile file = (UFile)UastContextKt.toUElement((PsiElement)langFile, UFile.class);
        if (file == null) {
            return springBootClass;
        }
        SmartList mainMethodCandidates = new SmartList();
        for (UClass uClass : file.getClasses()) {
            for (UMethod method : uClass.getMethods()) {
                if (!PsiMethodUtil.isMainMethod((PsiMethod)method)) continue;
                mainMethodCandidates.add(method);
            }
        }
        if (mainMethodCandidates.size() == 1) {
            return ((UMethod)mainMethodCandidates.get(0)).getContainingClass();
        }
        return springBootClass;
    }
}

