/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.boot.application.config.SpringBootPlaceholderReference;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.metadata.additional.DefineLocalMetaConfigKeyFix;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.SmartHashSet;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpringBootConfigFileHighlightingUtil {
    private static final Condition<PsiReference> RELEVANT_REFERENCE_CONDITION = reference -> !reference.isSoft() && !(reference instanceof SpringBootPlaceholderReference);
    private final ProblemsHolder myHolder;

    public SpringBootConfigFileHighlightingUtil(ProblemsHolder holder) {
        this.myHolder = holder;
    }

    public void highlightValueReferences(@NotNull PsiElement valueElement) {
        if (valueElement == null) {
            SpringBootConfigFileHighlightingUtil.$$$reportNull$$$0(0);
        }
        List valueReferences = ContainerUtil.filter((Object[])valueElement.getReferences(), RELEVANT_REFERENCE_CONDITION);
        MultiMap unresolvedReferences = MultiMap.createSmart();
        SmartHashSet resolvedReferencesOffsets = new SmartHashSet();
        for (PsiReference reference : valueReferences) {
            boolean unresolved;
            int startOffset = reference.getRangeInElement().getStartOffset();
            boolean bl = reference instanceof PsiPolyVariantReference ? ((PsiPolyVariantReference)reference).multiResolve(false).length == 0 : (unresolved = reference.resolve() == null);
            if (!unresolved) {
                unresolvedReferences.remove((Object)startOffset);
                resolvedReferencesOffsets.add(startOffset);
                if (!(reference instanceof JavaClassReference)) continue;
                SpringBootConfigFileHighlightingUtil.highlightJavaClassReferenceExtends(this.myHolder, (JavaClassReference)reference);
                continue;
            }
            if (resolvedReferencesOffsets.contains(startOffset)) continue;
            unresolvedReferences.putValue((Object)startOffset, (Object)reference);
        }
        for (PsiReference reference : unresolvedReferences.values()) {
            this.myHolder.registerProblem(reference, ProblemsHolder.unresolvedReferenceMessage((PsiReference)reference), ProblemHighlightType.ERROR);
        }
    }

    private static void highlightJavaClassReferenceExtends(ProblemsHolder holder, JavaClassReference reference) {
        List extendClassNames = reference.getSuperClasses();
        if (extendClassNames.isEmpty()) {
            return;
        }
        PsiElement resolve = reference.resolve();
        if (!(resolve instanceof PsiClass)) {
            return;
        }
        for (String extend : extendClassNames) {
            if (!InheritanceUtil.isInheritor((PsiClass)((PsiClass)resolve), (String)extend)) continue;
            return;
        }
        holder.registerProblem(reference.getElement(), ElementManipulators.getValueText((PsiElement)reference.getElement()) + " is not assignable to " + StringUtil.join((Collection)extendClassNames, (String)"|"), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
    }

    public void highlightDeprecatedConfigKey(PsiElement keyElement, SpringBootApplicationMetaConfigKey configKey, LocalQuickFix ... quickFixes) {
        SpringBootApplicationMetaConfigKey.Deprecation deprecation = configKey.getDeprecation();
        String reasonShortText = deprecation.getReason().getShortText();
        String reason = StringUtil.isNotEmpty((String)reasonShortText) ? ": " + reasonShortText : " configuration property '" + configKey.getName() + "'";
        ProblemHighlightType problemHighlightType = deprecation.getLevel() == SpringBootApplicationMetaConfigKey.Deprecation.DeprecationLevel.ERROR ? ProblemHighlightType.GENERIC_ERROR : ProblemHighlightType.LIKE_DEPRECATED;
        this.myHolder.registerProblem(keyElement, "Deprecated" + reason, problemHighlightType, quickFixes);
    }

    public void highlightUnresolvedConfigKey(PsiElement keyElement, String qualifiedConfigKeyName) {
        this.myHolder.registerProblem(keyElement, "Cannot resolve configuration property '" + qualifiedConfigKeyName + "'", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new DefineLocalMetaConfigKeyFix(qualifiedConfigKeyName)});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueElement", "com/intellij/spring/boot/application/config/SpringBootConfigFileHighlightingUtil", "highlightValueReferences"));
    }
}

