/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesElementFactory;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.model.utils.PlaceholderTextRanges;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.SmartList;
import icons.SpringBootApiIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringBootPlaceholderReference
extends PsiReferenceBase<PsiElement> {
    protected SpringBootPlaceholderReference(PsiElement element, TextRange range) {
        super(element, range);
    }

    @Nullable
    protected abstract PsiElement resolveExistingKey(String var1);

    protected abstract void addExistingKeyVariants(List<LookupElement> var1);

    public static PsiReference[] createPlaceholderReferences(PsiElement element, PairFunction<PsiElement, TextRange, PsiReference> producer) {
        String text = ElementManipulators.getValueText((PsiElement)element);
        Set ranges = PlaceholderTextRanges.getPlaceholderRanges((String)text, (String)"${", (String)"}");
        if (ranges.isEmpty()) {
            return EMPTY_ARRAY;
        }
        ArrayList<Object> placeholderReferences = new ArrayList<Object>(ranges.size());
        int startOffset = ElementManipulators.getOffsetInElement((PsiElement)element);
        for (TextRange range : ranges) {
            placeholderReferences.add(producer.fun((Object)element, (Object)range.shiftRight(startOffset)));
        }
        return placeholderReferences.toArray(new PsiReference[placeholderReferences.size()]);
    }

    @Nullable
    public PsiElement resolve() {
        String key = this.getValue();
        if (key.startsWith("random.")) {
            String after = (String)ObjectUtils.assertNotNull((Object)StringUtil.substringAfter((String)key, (String)"random."));
            for (Random random : Random.values()) {
                String randomValue = random.getValue();
                if ((!random.isSupportsParameters() || !after.startsWith(randomValue)) && !after.equals(randomValue) || !SpringBootLibraryUtil.isAtLeastVersion(this.getModule(), random.getMinimumVersion())) continue;
                PsiClass randomClass = this.findRandomClass();
                return randomClass != null ? randomClass : this.getElement();
            }
            return null;
        }
        IProperty systemProperty = this.getSystemProperties().findPropertyByKey(key);
        if (systemProperty != null) {
            return systemProperty.getPsiElement();
        }
        return this.resolveExistingKey(key);
    }

    @Nullable
    private PsiClass findRandomClass() {
        return SpringCommonUtils.findLibraryClass((Module)this.getModule(), (String)this.getRandomClassName());
    }

    @NotNull
    private String getRandomClassName() {
        if (SpringBootLibraryUtil.isAtLeastVersion(this.getModule(), SpringBootLibraryUtil.SpringBootVersion.VERSION_2_0_0)) {
            if ("org.springframework.boot.env.RandomValuePropertySource" == null) {
                SpringBootPlaceholderReference.$$$reportNull$$$0(0);
            }
            return "org.springframework.boot.env.RandomValuePropertySource";
        }
        if ("org.springframework.boot.context.config.RandomValuePropertySource" == null) {
            SpringBootPlaceholderReference.$$$reportNull$$$0(1);
        }
        return "org.springframework.boot.context.config.RandomValuePropertySource";
    }

    private Module getModule() {
        return ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
    }

    @NotNull
    private PropertiesFile getSystemProperties() {
        PropertiesFile propertiesFile = PropertiesElementFactory.getSystemProperties((Project)this.myElement.getProject());
        if (propertiesFile == null) {
            SpringBootPlaceholderReference.$$$reportNull$$$0(2);
        }
        return propertiesFile;
    }

    @NotNull
    public Object[] getVariants() {
        SmartList variants = new SmartList();
        this.addExistingKeyVariants((List<LookupElement>)variants);
        for (IProperty property : this.getSystemProperties().getProperties()) {
            String key = property.getKey();
            if (key == null) continue;
            variants.add(LookupElementBuilder.create((Object)property, (String)key).withIcon(SpringBootApiIcons.SpringBoot));
        }
        PsiClass randomClass = this.findRandomClass();
        if (randomClass == null) {
            Object[] objectArray = ArrayUtil.toObjectArray((Collection)variants);
            if (objectArray == null) {
                SpringBootPlaceholderReference.$$$reportNull$$$0(3);
            }
            return objectArray;
        }
        Module module = this.getModule();
        for (Random random : Random.values()) {
            if (!SpringBootLibraryUtil.isAtLeastVersion(module, random.getMinimumVersion())) continue;
            String randomText = random.getValue();
            String insertString = "random." + randomText;
            variants.add(LookupElementBuilder.create((Object)randomClass, (String)insertString).withIcon(SpringBootApiIcons.SpringBoot));
            if (!random.isSupportsParameters()) continue;
            variants.add(LookupElementBuilder.create((Object)randomClass, (String)insertString).withPresentableText("random." + randomText + "(value,[max])").withIcon(SpringBootApiIcons.SpringBoot).withInsertHandler((InsertHandler)ParenthesesInsertHandler.WITH_PARAMETERS));
        }
        Object[] objectArray = ArrayUtil.toObjectArray((Collection)variants);
        if (objectArray == null) {
            SpringBootPlaceholderReference.$$$reportNull$$$0(4);
        }
        return objectArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/spring/boot/application/config/SpringBootPlaceholderReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRandomClassName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemProperties";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    static enum Random {
        INT("int", true, SpringBootLibraryUtil.SpringBootVersion.ANY),
        LONG("long", true, SpringBootLibraryUtil.SpringBootVersion.ANY),
        VALUE("value", false, SpringBootLibraryUtil.SpringBootVersion.ANY),
        UUID("uuid", false, SpringBootLibraryUtil.SpringBootVersion.VERSION_1_4_0);

        private final String myValue;
        private final boolean mySupportsParameters;
        private final SpringBootLibraryUtil.SpringBootVersion myMinimumVersion;

        private Random(String value, boolean supportsParameters, SpringBootLibraryUtil.SpringBootVersion minimumVersion) {
            this.myValue = value;
            this.mySupportsParameters = supportsParameters;
            this.myMinimumVersion = minimumVersion;
        }

        SpringBootLibraryUtil.SpringBootVersion getMinimumVersion() {
            return this.myMinimumVersion;
        }

        String getValue() {
            return this.myValue;
        }

        boolean isSupportsParameters() {
            return this.mySupportsParameters;
        }
    }
}

