/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u0012\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u0004\u0018\u00010\u0007J\u0014\u0010\r\u001a\u00020\u00052\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fR\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/spring/boot/model/SpringBootConfigValueSearcher;", "", "myModule", "Lcom/intellij/openapi/module/Module;", "myIncludeTests", "", "myConfigKey", "", "myCheckRelaxedNames", "myActiveProfiles", "", "(Lcom/intellij/openapi/module/Module;ZLjava/lang/String;ZLjava/util/Set;)V", "findValueText", "process", "processor", "Lcom/intellij/util/Processor;", "Lcom/intellij/spring/boot/model/SpringBootModelConfigFileContributor$ConfigurationValueResult;", "Companion", "spring-boot-api"})
public final class SpringBootConfigValueSearcher {
    private final Module myModule;
    private final boolean myIncludeTests;
    private final String myConfigKey;
    private final boolean myCheckRelaxedNames;
    private final Set<String> myActiveProfiles;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final String findValueText() {
        Ref valueText = Ref.create();
        Processor findValueTextProcessor2 = (Processor)new Processor<SpringBootModelConfigFileContributor.ConfigurationValueResult>(valueText){
            final /* synthetic */ Ref $valueText;

            public final boolean process(SpringBootModelConfigFileContributor.ConfigurationValueResult result) {
                String string = result.valueText;
                if (string == null) {
                    return true;
                }
                String text = string;
                this.$valueText.set((Object)text);
                return false;
            }
            {
                this.$valueText = ref;
            }
        };
        this.process((Processor<SpringBootModelConfigFileContributor.ConfigurationValueResult>)findValueTextProcessor2);
        return (String)valueText.get();
    }

    public final boolean process(@NotNull Processor<SpringBootModelConfigFileContributor.ConfigurationValueResult> processor) {
        Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
        SpringBootApplicationMetaConfigKey springBootApplicationMetaConfigKey = SpringBootApplicationMetaConfigKeyManager.getInstance().findApplicationMetaConfigKey(this.myModule, this.myConfigKey);
        if (springBootApplicationMetaConfigKey == null) {
            return true;
        }
        SpringBootApplicationMetaConfigKey metaConfigKey = springBootApplicationMetaConfigKey;
        if (Intrinsics.areEqual((Object)((Object)metaConfigKey.getDeprecation().getLevel()), (Object)((Object)SpringBootApplicationMetaConfigKey.Deprecation.DeprecationLevel.ERROR))) {
            return true;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)this.myModule.getProject());
        for (SpringBootModelConfigFileContributor contributor : (SpringBootModelConfigFileContributor[])SpringBootModelConfigFileContributor.EP_NAME.getExtensions()) {
            for (VirtualFile virtualFile : contributor.getConfigurationFiles(this.myModule, this.myIncludeTests)) {
                PsiFile configPsiFile;
                if (psiManager.findFile(virtualFile) == null) {
                    continue;
                }
                List<SpringBootModelConfigFileContributor.ConfigurationValueResult> result = contributor.findConfigurationValues(configPsiFile, metaConfigKey, this.myCheckRelaxedNames, this.myActiveProfiles);
                if (ContainerUtil.process(result, processor)) continue;
                return false;
            }
        }
        return true;
    }

    public SpringBootConfigValueSearcher(@NotNull Module myModule, boolean myIncludeTests, @NotNull String myConfigKey, boolean myCheckRelaxedNames, @Nullable Set<String> myActiveProfiles) {
        Intrinsics.checkParameterIsNotNull((Object)myModule, (String)"myModule");
        Intrinsics.checkParameterIsNotNull((Object)myConfigKey, (String)"myConfigKey");
        this.myModule = myModule;
        this.myIncludeTests = myIncludeTests;
        this.myConfigKey = myConfigKey;
        this.myCheckRelaxedNames = myCheckRelaxedNames;
        this.myActiveProfiles = myActiveProfiles;
    }

    public /* synthetic */ SpringBootConfigValueSearcher(Module module, boolean bl, String string, boolean bl2, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        if ((n & 0x10) != 0) {
            set = null;
        }
        this(module, bl, string, bl2, set);
    }

    @JvmStatic
    @NotNull
    public static final SpringBootConfigValueSearcher productionForProfiles(@NotNull Module module, @NotNull String configKey, @Nullable Set<String> activeProfiles) {
        return Companion.productionForProfiles(module, configKey, activeProfiles);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\nH\u0007\u00a8\u0006\u000b"}, d2={"Lcom/intellij/spring/boot/model/SpringBootConfigValueSearcher$Companion;", "", "()V", "productionForProfiles", "Lcom/intellij/spring/boot/model/SpringBootConfigValueSearcher;", "module", "Lcom/intellij/openapi/module/Module;", "configKey", "", "activeProfiles", "", "spring-boot-api"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final SpringBootConfigValueSearcher productionForProfiles(@NotNull Module module, @NotNull String configKey, @Nullable Set<String> activeProfiles) {
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            Intrinsics.checkParameterIsNotNull((Object)configKey, (String)"configKey");
            return new SpringBootConfigValueSearcher(module, false, configKey, false, activeProfiles, 10, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

