/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.spring.boot.application.SpringBootApplicationUtil;
import com.intellij.spring.boot.application.metadata.MetaConfigKeyReference;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.model.SpringBootModelConfigFileNameContributor;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.beans.CustomSetting;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public abstract class SpringBootModelConfigFileContributor {
    public static final ExtensionPointName<SpringBootModelConfigFileContributor> EP_NAME = ExtensionPointName.create((String)"com.intellij.spring.boot.modelConfigFileContributor");
    private static final Comparator<VirtualFile> VF_BY_NAME_COMPARATOR = (o1, o2) -> StringUtil.naturalCompare((String)o1.getName(), (String)o2.getName());
    private static final boolean OUR_TEST_MODE = ApplicationManager.getApplication().isUnitTestMode();
    private final FileType myFileType;
    public static final Set<String> PROCESS_ALL_PROFILES = Collections.singleton("PROCESS_ALL_PROFILES");
    private static boolean USE_RESOURCE_ROOTS_FOR_TESTS = false;

    protected SpringBootModelConfigFileContributor(FileType fileType) {
        this.myFileType = fileType;
    }

    public FileType getFileType() {
        return this.myFileType;
    }

    public List<VirtualFile> getConfigurationFiles(Module module, boolean includeTestScope) {
        List files = ContainerUtil.newSmartList();
        for (SpringBootModelConfigFileNameContributor fileNameContributor : (SpringBootModelConfigFileNameContributor[])SpringBootModelConfigFileNameContributor.EP_NAME.getExtensions()) {
            if (!fileNameContributor.accept(module)) continue;
            files.addAll(this.getConfigurationFiles(module, fileNameContributor, includeTestScope));
        }
        return files;
    }

    public List<VirtualFile> getConfigurationFiles(Module module, SpringFileSet fileSet, boolean includeTestScope) {
        List files = ContainerUtil.newSmartList();
        for (SpringBootModelConfigFileNameContributor fileNameContributor : (SpringBootModelConfigFileNameContributor[])SpringBootModelConfigFileNameContributor.EP_NAME.getExtensions()) {
            if (!fileNameContributor.accept(fileSet)) continue;
            files.addAll(this.getConfigurationFiles(module, fileNameContributor, includeTestScope));
            break;
        }
        return files;
    }

    public List<VirtualFile> getConfigurationFiles(Module module, SpringBootModelConfigFileNameContributor fileNameContributor, boolean includeTestScope) {
        String springConfigName = SpringBootModelConfigFileContributor.getSpringConfigName(module, fileNameContributor);
        List<VirtualFile> userConfigurationFiles = this.findApplicationConfigFiles(module, includeTestScope, springConfigName);
        return ContainerUtil.concat(userConfigurationFiles, SpringBootModelConfigFileContributor.findCustomConfigFiles(module, fileNameContributor));
    }

    private static List<VirtualFile> findCustomConfigFiles(Module module, SpringBootModelConfigFileNameContributor fileNameContributor) {
        SpringFacet springFacet = SpringBootModelConfigFileContributor.getRelevantFacet(module);
        if (springFacet == null) {
            return Collections.emptyList();
        }
        CustomSetting.STRING setting = (CustomSetting.STRING)springFacet.findSetting(fileNameContributor.getCustomFilesSettingDescriptor().key);
        assert (setting != null);
        String value = setting.getStringValue();
        if (value == null) {
            return Collections.emptyList();
        }
        List urls = StringUtil.split((String)value, (String)";");
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(urls.size());
        for (String url : urls) {
            VirtualFile configFile = VirtualFileManager.getInstance().findFileByUrl(url);
            ContainerUtil.addIfNotNull(files, (Object)configFile);
        }
        return files;
    }

    @NotNull
    private static String getSpringConfigName(Module module, SpringBootModelConfigFileNameContributor fileNameContributor) {
        SpringFacet springFacet = SpringBootModelConfigFileContributor.getRelevantFacet(module);
        if (springFacet == null) {
            String string = fileNameContributor.getCustomNameSettingDescriptor().defaultValue;
            if (string == null) {
                SpringBootModelConfigFileContributor.$$$reportNull$$$0(0);
            }
            return string;
        }
        CustomSetting.STRING setting = (CustomSetting.STRING)springFacet.findSetting(fileNameContributor.getCustomNameSettingDescriptor().key);
        assert (setting != null);
        String string = StringUtil.notNullize((String)setting.getStringValue(), (String)setting.getDefaultValue());
        if (string == null) {
            SpringBootModelConfigFileContributor.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    private static SpringFacet getRelevantFacet(Module module) {
        if (module.isDisposed()) {
            return null;
        }
        SpringFacet facet = SpringBootModelConfigFileContributor.findSpringBootApplicationFacet(module);
        if (facet != null) {
            return facet;
        }
        for (Module dependentModule : ModuleRootManager.getInstance((Module)module).getDependencies()) {
            SpringFacet dependentFacet = SpringBootModelConfigFileContributor.findSpringBootApplicationFacet(dependentModule);
            if (dependentFacet == null) continue;
            return dependentFacet;
        }
        return null;
    }

    @Nullable
    private static SpringFacet findSpringBootApplicationFacet(Module module) {
        SpringFacet springFacet = SpringFacet.getInstance((Module)module);
        if (springFacet == null) {
            return null;
        }
        List<PsiClass> applications = SpringBootApplicationUtil.getSpringApplications(module);
        return applications.isEmpty() ? null : springFacet;
    }

    public List<VirtualFile> findApplicationConfigFiles(Module module, boolean includeTestScope, @NotNull String baseName) {
        if (baseName == null) {
            SpringBootModelConfigFileContributor.$$$reportNull$$$0(2);
        }
        List<VirtualFile> productionConfigFiles = this.findConfigFilesInScope(module, false, baseName);
        if (!includeTestScope) {
            return productionConfigFiles;
        }
        List<VirtualFile> testConfigFiles = this.findConfigFilesInScope(module, true, baseName);
        return ContainerUtil.concat(productionConfigFiles, testConfigFiles);
    }

    private List<VirtualFile> findConfigFilesInScope(Module module, boolean testScope, @NotNull String baseName) {
        List matchingProfileConfigFiles;
        GlobalSearchScope configFileSearchScope;
        if (baseName == null) {
            SpringBootModelConfigFileContributor.$$$reportNull$$$0(3);
        }
        if ((configFileSearchScope = this.getConfigFileSearchScope(module, testScope)) == null) {
            return Collections.emptyList();
        }
        String fileNamePrefix = baseName + '-';
        SmartList baseNameConfigFiles = new SmartList();
        SmartList profileConfigFiles = new SmartList();
        FileTypeIndex.processFiles((FileType)this.myFileType, arg_0 -> SpringBootModelConfigFileContributor.lambda$findConfigFilesInScope$1(baseName, (Collection)baseNameConfigFiles, fileNamePrefix, (Collection)profileConfigFiles, arg_0), (GlobalSearchScope)configFileSearchScope);
        if (baseNameConfigFiles.isEmpty() && profileConfigFiles.isEmpty()) {
            return Collections.emptyList();
        }
        if (baseNameConfigFiles.size() > 1) {
            return Collections.emptyList();
        }
        VirtualFile baseNameConfigFile = (VirtualFile)ContainerUtil.getFirstItem((Collection)baseNameConfigFiles);
        SmartList result = new SmartList();
        ContainerUtil.addIfNotNull((Collection)result, (Object)baseNameConfigFile);
        if (profileConfigFiles.isEmpty()) {
            return result;
        }
        if (baseNameConfigFile != null) {
            VirtualFile parentDirectory = baseNameConfigFile.getParent();
            if (parentDirectory == null) {
                return result;
            }
            GlobalSearchScope containingDirectoryScope = GlobalSearchScopesCore.directoryScope((Project)module.getProject(), (VirtualFile)parentDirectory, (boolean)false);
            matchingProfileConfigFiles = ContainerUtil.filter((Collection)profileConfigFiles, file -> containingDirectoryScope.contains(file));
        } else {
            matchingProfileConfigFiles = new ArrayList(profileConfigFiles);
        }
        Collections.sort(matchingProfileConfigFiles, VF_BY_NAME_COMPARATOR);
        result.addAll(matchingProfileConfigFiles);
        return result;
    }

    @Nullable
    public GlobalSearchScope getConfigFileSearchScope(Module module, boolean testScope) {
        if (OUR_TEST_MODE && !USE_RESOURCE_ROOTS_FOR_TESTS) {
            return module.getModuleScope(false);
        }
        if (module.isDisposed()) {
            return null;
        }
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        List resourceRoots = moduleRootManager.getSourceRoots((JpsModuleSourceRootType)(testScope ? JavaResourceRootType.TEST_RESOURCE : JavaResourceRootType.RESOURCE));
        if (resourceRoots.isEmpty()) {
            return null;
        }
        return GlobalSearchScopesCore.directoriesScope((Project)module.getProject(), (boolean)true, (VirtualFile[])resourceRoots.toArray(new VirtualFile[resourceRoots.size()]));
    }

    @NotNull
    public abstract List<ConfigurationValueResult> findConfigurationValues(PsiFile var1, SpringBootApplicationMetaConfigKey var2, boolean var3, @Nullable Set<String> var4);

    public static void setUseResourceRootsForTests(boolean useResourceRootsForTests) {
        USE_RESOURCE_ROOTS_FOR_TESTS = useResourceRootsForTests;
    }

    private static /* synthetic */ boolean lambda$findConfigFilesInScope$1(@NotNull String baseName, Collection baseNameConfigFiles, String fileNamePrefix, Collection profileConfigFiles, VirtualFile file) {
        String fileName;
        if (baseName == null) {
            SpringBootModelConfigFileContributor.$$$reportNull$$$0(4);
        }
        if ((fileName = file.getNameWithoutExtension()).equals(baseName)) {
            baseNameConfigFiles.add(file);
        } else if (StringUtil.startsWith((CharSequence)fileName, (CharSequence)fileNamePrefix)) {
            profileConfigFiles.add(file);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/model/SpringBootModelConfigFileContributor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpringConfigName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/model/SpringBootModelConfigFileContributor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findApplicationConfigFiles";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findConfigFilesInScope";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findConfigFilesInScope$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ConfigurationValueResult {
        @Nullable
        public PsiElement keyElement;
        @Nullable
        public PsiElement valueElement;
        @Nullable
        public String valueText;

        public ConfigurationValueResult(@Nullable PsiElement keyElement, @Nullable PsiElement valueElement, @Nullable String valueText) {
            this.keyElement = keyElement;
            this.valueElement = valueElement;
            this.valueText = valueText;
        }

        @Nullable
        public MetaConfigKeyReference getMetaConfigKeyReference() {
            if (this.keyElement == null) {
                return null;
            }
            return (MetaConfigKeyReference)((Object)ContainerUtil.findInstance((Object[])this.keyElement.getReferences(), MetaConfigKeyReference.class));
        }
    }
}

