/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.spring.model.jam.SpringOrder;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SpringOrderClassSorter {
    public static final Comparator<PsiClass> CLASS_NAME_COMPARATOR = (o1, o2) -> StringUtil.compare((String)o1.getQualifiedName(), (String)o2.getQualifiedName(), (boolean)false);
    private static final Comparator<PsiClass> ORDER_COMPARATOR = new Comparator<PsiClass>(){

        @Override
        public int compare(PsiClass o1, PsiClass o2) {
            int order1 = this.getOrderValue(o1);
            int order2 = this.getOrderValue(o2);
            return Comparing.compare((int)order1, (int)order2);
        }

        private int getOrderValue(PsiClass psiClass) {
            SpringOrder order = (SpringOrder)SpringOrder.CLASS_META.getJamElement((PsiModifierListOwner)psiClass);
            if (order == null) {
                return SpringOrder.LOWEST_PRECEDENCE;
            }
            return (Integer)ObjectUtils.notNull((Object)order.getValue(), (Object)SpringOrder.LOWEST_PRECEDENCE);
        }
    };
    private final List<PsiClass> allConfigs;

    public SpringOrderClassSorter(List<PsiClass> allConfigs) {
        this.allConfigs = allConfigs;
    }

    public List<PsiClass> getSortedConfigs() {
        ArrayList<PsiClass> configs = new ArrayList<PsiClass>(this.allConfigs);
        Collections.sort(configs, CLASS_NAME_COMPARATOR);
        Collections.sort(configs, ORDER_COMPARATOR);
        return configs;
    }
}

